<?php
/**
 * Plugin Name:       EDD Customer Dashboard
 * Plugin URI:        http://joshmallard.com
 * Description:       Adds a customer dashboard shortcode which allows customers to quickly edit their profile and view purchase history and download history. Also integrates with the Front-End Submissions and Wishlists plugins.
 * Version:           1.4
 * Author:            Josh Mallard
 * Author URI:        http://joshmallard.com
 * Text Domain:       edd_customer_dashboard
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

require_once( plugin_dir_path( __FILE__ ) . 'public/class-edd-customer-dashboard.php' );
add_action( 'plugins_loaded', array( 'EDD_Customer_Dashboard', 'get_instance' ) );

// Create user-dashboard page
function azin_add_customer_dashboard_page() {

    // Create post object
    $my_post = array(
      'post_title'    => __('Profile', 'edd_customer_dashboard'),
      'post_name' => 'dashboard',
      'post_content'  => '[edd_customer_dashboard]',
      'post_status'   => 'publish',
      'post_author'   => 1,
      'post_type'     => 'page',
    );

    $page_check = get_page_by_title( $new_page_title );

    if ( is_admin() ) {
      if ( ! isset( $page_check->ID ) )
        {
        $new_page_id = wp_insert_post( $my_post );
        if ( ! empty( $new_page_template ) ) {
            update_post_meta( $new_page_id, '_wp_page_template', $new_page_template );
          }
        }
	  }
}
register_activation_hook(__FILE__, 'azin_add_customer_dashboard_page');