<?php
function register_new_widgets( $widgets_manager ) {

	require_once( __DIR__ . '/base/video-widget.php' );

	$widgets_manager->register( new \Custom_Video_Widget() );

}
add_action( 'elementor/widgets/register', 'register_new_widgets' );


add_action( 'elementor/controls/controls_registered', function( $controls_manager ) {
	require_once( __DIR__ . '/base/date-widget.php' );

	$controls_manager->register_control( 'persian_date_picker', new \Control_Persian_Date_Picker() );
} );

function register_widget_styles()
{
	wp_register_style('pDate-style',plugins_url('elementor-pro') . '/megatheme/includes/assets/css/persian-datepicker.min.css');

	wp_register_script('pDate',plugins_url('elementor-pro') . '/megatheme/includes/assets/js/persian-date.min.js',array('jquery') );
	wp_register_script('pDatepicker',plugins_url('elementor-pro') . '/megatheme/includes/assets/js/persian-datepicker.min.js' ,array('pDate'));
	wp_register_script('pDatepickerLoader',plugins_url('elementor-pro') . '/megatheme/includes/assets/js/persian-datepicker-loader.js',array('pDatepicker') );
}

add_action('wp_enqueue_scripts', 'register_widget_styles',1);


/**
 * Register additional document controls.
 *
 * @param \Elementor\Core\DocumentTypes\PageBase $document The PageBase document instance.
 */
function register_document_controls( $document ) {

	if ( ! $document instanceof \Elementor\Core\DocumentTypes\PageBase || ! $document::get_property( 'has_elements' ) ) {
		return;
	}

	$document->start_controls_section(
		'date_section',
		[
			'label' =>  'تاریخ شمسی',
			'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
		]
	);

	$document->add_control(
		'shamsi_date_off',
		[
			'label' => 'خاموش کردن تقویم فارسی',
			'type' => \Elementor\Controls_Manager::SWITCHER,
		]
	);

	$document->end_controls_section();
}
add_action( 'elementor/documents/register_controls', 'register_document_controls' );
