<?php
defined( 'ABSPATH' ) || exit;

class Dlr_Admin extends Mobits
{
	public function __construct() 
	{
		$this->define_constants();
		$this->includes();
		$this->init();
	}

	public function define_constants()
	{
		$this->define( 'DLR_PARTIALS', dirname( __FILE__ ) . '/partials/' );
	}

	public function includes()
	{
		require_once DLR_PARTIALS . 'class-dlr-settings.php';
	}

	public function init()
	{
		add_action( 'admin_menu', [$this, 'admin_menu'] );
		add_action( 'admin_head', [$this, 'admin_head'] );
// 		add_action( 'admin_init', [$this, 'admin_init'] );
	}

	public function admin_init ()
	{
		global $current_user;
		global $wp_roles;
		$user_roles = $current_user->roles;

		$roles = [];
		foreach( $user_roles as $role ) 
		{
			$roles[] = strtolower( $wp_roles->roles[$role]['name'] );
		}

		$limiteds = get_option('_limit_panel_access_by_role', []);

		foreach ( $limiteds as $limited ) 
		{
			if ( in_array($limited, $roles)  ) 
			{
				wp_redirect( home_url() );
				exit;
			}
		}
	}

	public function display_menu_by_roles()
	{
		global $current_user;
    	$user_roles = $current_user->roles;
		$allowed_roles = get_option('_display_mobits_menu', []);
		$allowed_roles = $allowed_roles == '' ? [] : $allowed_roles;

		foreach ( $user_roles as $user_role ) 
		{
			if ( in_array( strtolower($user_role), $allowed_roles ) || $user_role == 'administrator' ) return $user_role;
		}

		return false;
	}
	
	public function admin_menu() 
	{
		$user_role = $this->display_menu_by_roles();

	    add_menu_page(
            __('Mobits' , 'dlr'),
            __('Mobits' , 'dlr'),
            'administrator',
            'dlr-settings',
            ['Dlr_Settings', 'dlr_main_settings'],
            'dashicons-smartphone',
            50
        );

		$submenues = [
			[ 'title' => __('General', 'dlr'), 			'slug' => 'general' ],
			[ 'title' => __('Login', 'dlr'),			'slug' => 'login' ],
			[ 'title' => __('Register', 'dlr'), 		'slug' => 'register' ],
			[ 'title' => __('Redirect', 'dlr'), 		'slug' => 'redirect' ],
			[ 'title' => __('Design', 'dlr'), 			'slug' => 'design' ],
			[ 'title' => __('Webservice', 'dlr'), 		'slug' => 'sms' ],
			[ 'title' => __('Other plugins', 'dlr'), 	'slug' => 'others' ],
			[ 'title' => __('Google Captcha', 'dlr'), 	'slug' => 'captcha' ],
			[ 'title' => __('Woocommerce', 'dlr'),  	'slug' => 'woocommerce' ],
			[ 'title' => __('Import/Export', 'dlr'), 	'slug' => 'import-export' ],
			[ 'title' => __('Reports', 'dlr'), 			'slug' => 'reports' ],
			[ 'title' => __('Roadmap', 'dlr'), 			'slug' => 'roadmap' ],
		];

		foreach( $submenues as $submenue )
		{
			add_submenu_page('dlr-settings', $submenue['title'], $submenue['title'], 'manage_options',  'admin.php?page=dlr-settings&dlr_tab='.$submenue['slug']);
		}
		remove_submenu_page('dlr-settings', 'dlr-settings');

	}

	function admin_head()
	{
		$this->admin_head_styles();
		$this->admin_head_fonts();
	}

	private function admin_head_fonts()
	{
		$global_font = get_option('_dlr_font_global', 0);
		if ( $global_font == 1 || ( isset($_GET['page']) && $_GET['page'] == 'dlr-settings' ) ):

		$font = get_option('_dlr_admin_font', 'iranyekan');
		$font_name = $font=='iranyekan' ? 'iranyekanweblightfanum' : 'IRANSansX-Regular';
		$bold = $font=='iranyekan' ? 'bold' : 'normal';
		?>
		<style>
	    @font-face{
			font-family: Mobits;
			src: url(<?php echo DLR_BASE_URL; ?>public/fonts/<?php echo $font_name; ?>.woff) format('woff')
		}

		.dlr_setting, .dlr_setting h1, .rtl h1,
		.rtl h2, .rtl h3, .rtl h4, .rtl h5, .rtl h6 , .dlr_mobits_new_version,
		#dlr_setting_wrapper th,
		.dlr_setting p, .dlr_setting input[type=text], .dlr_setting input[type=password], .dlr_setting .regular-text, .dlr_setting select, .dlr_setting input[type=search], .select2-container
		 {
			font-family: Mobits;
			font-weight: <?php echo $bold; ?> !important;
		}
		
	    </style>

		<?php if($global_font==1): ?>
		<style>
		body, ul, li, h1,h2,h3,h4,h5,h6, strong, a,
		.select2-container, #footer-thankyou, #footer-upgrade
		{
			font-family: Mobits;
			font-weight: <?php echo $bold; ?> !important;
		}
		</style>
		<?php endif;?>
		
		<?php endif;
	}

	private function admin_head_styles()
	{
		if( get_option('_dlr_update_notice_in_admin_bar') == 1 ):
		?>
		<style>
		#wp-admin-bar-new_mobits a {
			background: yellow !important;
			padding: 0 10px !important;
			-webkit-animation:newmobits 1s infinite;
			color: green !important;
		}
		@keyframes newmobits{
			0% { transform: skewX(-15deg); }
			5% { transform: skewX(15deg); }
			10% { transform: skewX(-15deg); }
			15% { transform: skewX(15deg); }
			20% { transform: skewX(0deg); }
			100% { transform: skewX(0deg); }
		}
		#wp-admin-bar-new_mobits a span {
			font-weight: bold;
		}
		</style>
		<?php
		endif;
	}

	public function is_mobits_settings()
	{
		return isset($_GET['page']) && $_GET['page'] == 'dlr-settings' ? true : false;
	}

	public function dlr_delete_extra_code_cron ()
	{
		wp_die();
	}
}
