jQuery(document).ready(function($){
    
     $( document ).on( 'click', '#_dlr_logo_button',  function(e1) {
        e1.stopImmediatePropagation();
        e1.preventDefault();
        var image = wp.media({
            title: 'انتخاب عکس',
            multiple: false
        }).open()
        .on('select', function(e){
            var uploaded_image = image.state().get('selection').first();
            var image_url = uploaded_image.toJSON().url;
            $('._dlr_logo_box').val( image_url );
        });
    
    });
    
    $( document ).on( 'click', '#_dlr_favicon_button',  function(e1) {
        e1.stopImmediatePropagation();
        e1.preventDefault();
        var image = wp.media({
            title: 'انتخاب عکس',
            multiple: false
        }).open()
        .on('select', function(e){
            var uploaded_image = image.state().get('selection').first();
            var image_url = uploaded_image.toJSON().url;
            $('._dlr_favicon_box').val( image_url );
        });
    
    });
    
    $( document ).on( 'click', '#_dlr_background_image',  function(e1) {
        e1.stopImmediatePropagation();
        e1.preventDefault();
        var image = wp.media({
            title: 'انتخاب عکس',
            multiple: false
        }).open()
        .on('select', function(e){
            var uploaded_image = image.state().get('selection').first();
            var image_url = uploaded_image.toJSON().url;
            $('._dlr_background_image_box').val( image_url );
        });
    
    });
    
    function smsView() 
    {
        var sms = $('select[name="_dlr_sms_service"]').find(":selected").val();
        var all = ['smsir', 'melipayamak', 'ippanel', 'payamresan', 'kavenegar', 'farapayamak', 'payamito'];
        all.forEach(e=> {
            if(e!=sms) $('#'+e).hide(); else $('#'+e).show();
        });
    }
    
    smsView();
    
    $(document).on('change', 'select[name="_dlr_sms_service"]', function(){
        smsView();
    });

    $(document).on('click', '.nav-tab', function(){
        $('#dlr_setting_wrapper').animate({opacity: .4}, 200);
    });
    
    $(document).on('click', '.dlr_admin_send_test_btn_melipayamak', function()
    {
        if ( $('#dlr_melipayamak_test_mobile').val() == '' ) return;
        
        $('.dlr_admin_send_test_check_melipayamak').fadeOut();
        $('.dlr_melipayamak_loader').fadeIn();
        
    	jQuery.ajax({
            type : "POST",
            dataType : "JSON",
            url : dlr.home + '/wp-json/api/sendSmsMelliPayamakAdmin',
            beforeSend: function(xhr) {
                xhr.setRequestHeader('X-WP-Nonce', dlr.nonce);
            },
            data : {
                mobile: $('input[name="dlr_melipayamak_test_mobile"]').val(),
                bodyId: $('input[name="_dlr_sms_melipayamak_theme"]').val(),
                username: $('input[name="_dlr_sms_melipayamak_username"]').val(),
                password: $('input[name="_dlr_sms_melipayamak_password"]').val(),
            },
        
            error: function(response, error) {
                $('.dlr_melipayamak_loader').fadeOut();
                $('.dlr_admin_send_test_check_melipayamak').fadeIn();
				$('.dlr_mp_result').text( response ).fadeIn(100);
            },
        
            success : function(response) {
                $('.dlr_melipayamak_loader').fadeOut();
                $('.dlr_admin_send_test_check_melipayamak').fadeIn();
				$('.dlr_mp_result').text( response ).fadeIn(100);
            }
        });
    });

	$(document).on('click', '.dlr_admin_send_test_btn_farapayamak', function()
    {
        if ( $('#dlr_farapayamak_test_mobile').val() == '' ) return;
        
        $('.dlr_admin_send_test_check_farapayamak').fadeOut();
        $('.dlr_farapayamak_loader').fadeIn();
        
    	jQuery.ajax({
            type : "POST",
            dataType : "JSON",
            url : dlr.home + '/wp-json/api/sendSmsFaraPayamakAdmin',
            beforeSend: function(xhr) {
                xhr.setRequestHeader('X-WP-Nonce', dlr.nonce);
            },
            data : {
                mobile: $('input[name="dlr_farapayamak_test_mobile"]').val(),
                bodyId: $('input[name="_dlr_sms_farapayamak_theme"]').val(),
                username: $('input[name="_dlr_sms_farapayamak_username"]').val(),
                password: $('input[name="_dlr_sms_farapayamak_password"]').val(),
            },
        
            error: function(response, error) {
                $('.dlr_farapayamak_loader').fadeOut();
                $('.dlr_admin_send_test_check_farapayamak').fadeIn();
				$('.dlr_mp_result').text( response ).fadeIn(100);
            },
        
            success : function(response) {
                $('.dlr_farapayamak_loader').fadeOut();
                $('.dlr_admin_send_test_check_farapayamak').fadeIn();
				$('.dlr_mp_result').text( response ).fadeIn(100);
            }
        });
    });

	$(document).on('click', '.dlr_admin_send_test_btn_payamito', function()
    {
        if ( $('#dlr_payamito_test_mobile').val() == '' ) return;
        
        $('.dlr_admin_send_test_check_payamito').fadeOut();
        $('.dlr_payamito_loader').fadeIn();
        
    	jQuery.ajax({
            type : "POST",
            dataType : "JSON",
            url : dlr.home + '/wp-json/api/sendSmsPayamitoAdmin',
            beforeSend: function(xhr) {
                xhr.setRequestHeader('X-WP-Nonce', dlr.nonce);
            },
            data : {
                mobile: $('input[name="dlr_payamito_test_mobile"]').val(),
                bodyId: $('input[name="_dlr_sms_payamito_theme"]').val(),
                username: $('input[name="_dlr_sms_payamito_username"]').val(),
                password: $('input[name="_dlr_sms_payamito_password"]').val(),
            },
        
            error: function(response, error) {
                $('.dlr_payamito_loader').fadeOut();
                $('.dlr_admin_send_test_check_payamito').fadeIn();
				$('.dlr_mp_result').text( response ).fadeIn(100);
            },
        
            success : function(response) {
                $('.dlr_payamito_loader').fadeOut();
                $('.dlr_admin_send_test_check_payamito').fadeIn();
				$('.dlr_mp_result').text( response ).fadeIn(100);
            }
        });
    });
    
    $(document).on('click', '.dlr_admin_send_test_btn_ippanel', function()
    {
        if ( $('#dlr_ippanel_test_mobile').val() == '' ) return;
        
        $('.dlr_admin_send_test_check_ippanel').fadeOut();
        $('.dlr_ippanel_loader').fadeIn();
        
    	jQuery.ajax({
            type : "POST",
            dataType : "JSON",
            url : dlr.home + '/wp-json/api/sendSmsIppanelAdmin',
            beforeSend: function(xhr) {
                xhr.setRequestHeader('X-WP-Nonce', dlr.nonce);
            },
            data : {
                mobile: $('input[name="dlr_ippanel_test_mobile"]').val(),
                bodyId: $('input[name="_dlr_sms_ippanel_theme"]').val(),
                username: $('input[name="_dlr_sms_ippanel_username"]').val(),
                password: $('input[name="_dlr_sms_ippanel_password"]').val(),
                from: $('input[name="_dlr_sms_ippanel_from"]').val(),
            },
        
            error: function(response, error) {
                $('.dlr_ippanel_loader').fadeOut();
                $('.dlr_admin_send_test_check_ippanel').fadeIn();
				$('.dlr_ip_result').text( response ).fadeIn(100);
            },
        
            success : function(response) {
                $('.dlr_ippanel_loader').fadeOut();
                $('.dlr_admin_send_test_check_ippanel').fadeIn();
				$('.dlr_ip_result').text( response ).fadeIn(100);
            }
        });
    });
    
    $(document).on('click', '.dlr_admin_send_test_btn_smsir', function()
    {
        if ( $('#dlr_smsir_test_mobile').val() == '' ) return;
        
        $('.dlr_admin_send_test_check_smsir').fadeOut();
        $('.dlr_smsir_loader').fadeIn();
        
    	jQuery.ajax({
            type : "POST",
            dataType : "JSON",
            url : dlr.home + '/wp-json/api/sendSmsSmsirAdmin',
            beforeSend: function(xhr) {
                xhr.setRequestHeader('X-WP-Nonce', dlr.nonce);
            },
            data : {
                mobile: $('input[name="dlr_smsir_test_mobile"]').val(),
                key: $('input[name="_dlr_sms_smsir_secretKey"]').val(),
                bodyId: $('input[name="_dlr_sms_smsir_theme"]').val()
            },
        
            error: function(response, error) {
                $('.dlr_smsir_loader').fadeOut();
                $('.dlr_admin_send_test_check_smsir').fadeIn();

				$res = JSON.parse(response);
				$('.dlr_sms_result').text( $res.message ).fadeIn(100);
            },
        
            success : function(response) {
                $('.dlr_smsir_loader').fadeOut();
                $('.dlr_admin_send_test_check_smsir').fadeIn();

				$res = JSON.parse(response);
				$('.dlr_sms_result').text( $res.message ).fadeIn(100);
            }
        });
    });

	$(document).on('click', '.dlr_admin_send_test_btn_payamresan', function()
    {
        if ( $('#dlr_payamresan_test_mobile').val() == '' ) return;
        
        $('.dlr_admin_send_test_check_payamresan').fadeOut();
        $('.dlr_payamresan_loader').fadeIn();
        
    	jQuery.ajax({
            type : "POST",
            dataType : "JSON",
            url : dlr.home + '/wp-json/api/sendSmsPayamresanAdmin',
            beforeSend: function(xhr) {
                xhr.setRequestHeader('X-WP-Nonce', dlr.nonce);
            },
            data : {
                key: $('input[name="_dlr_sms_payamresan_accessKey"]').val(),
                theme: $('input[name="_dlr_sms_payamresan_theme"]').val(),
				mobile: $('input[name="dlr_payamresan_test_mobile"]').val(),
            },
        
            error: function(response, error) {
                $('.dlr_payamresan_loader').fadeOut();
                $('.dlr_admin_send_test_check_payamresan').fadeIn();
				$('.dlr_pr_result').text( response ).fadeIn(100);
            },
        
            success : function(response) {
                $('.dlr_payamresan_loader').fadeOut();
                $('.dlr_admin_send_test_check_payamresan').fadeIn();
				$('.dlr_pr_result').text( response ).fadeIn(100);
            }
        });
    });

	$(document).on('click', '.dlr_admin_send_test_btn_kavenegar', function()
    {
        if ( $('#dlr_kavenegar_test_mobile').val() == '' ) return;
        
        $('.dlr_admin_send_test_check_kavenegar').fadeOut();
        $('.dlr_kavenegar_loader').fadeIn();
        
    	jQuery.ajax({
            type : "POST",
            dataType : "JSON",
            url : dlr.home + '/wp-json/api/sendSmsKavenegarAdmin',
            beforeSend: function(xhr) {
                xhr.setRequestHeader('X-WP-Nonce', dlr.nonce);
            },
            data : {
                key: $('input[name="_dlr_sms_kavenegar_apikey"]').val(),
                theme: $('input[name="_dlr_sms_kavenegar_theme"]').val(),
				mobile: $('input[name="dlr_kavenegar_test_mobile"]').val(),
            },
        
            error: function(response, error) {
                $('.dlr_kavenegar_loader').fadeOut();
                $('.dlr_admin_send_test_check_kavenegar').fadeIn();
				$('.dlr_pr_result').text( response ).fadeIn(100);
            },
        
            success : function(response) {
                $('.dlr_kavenegar_loader').fadeOut();
                $('.dlr_admin_send_test_check_kavenegar').fadeIn();
				$('.dlr_pr_result').text( response ).fadeIn(100);
            }
        });
    });

	$(document).on( 'click', 'input[name=dlr_import]', function(e){
		if ( $('input[name=dlr_import_settings]').val() == '' ) {
			e.preventDefault();
			alert(dlr.empty_file_error);
		}
	});

	$(document).on( 'click', 'input[name=dlr_import_settings]', function(e){
		if ( $('#_dlr_import_csv').val() == '' ) {
			e.preventDefault();
			alert(dlr.empty_file_error);
		}
	});

	$(document).on( 'click', 'input[name=quick_user_create]', function(e)
	{
		const mobile = $('input[name=dlr_mobile]').val();

		if ( mobile == '' ) {
			e.preventDefault();
			alert(dlr.quick_user_empty_mobile);
		}
		if( mobile.length != 11 || ! /(\+98|0|98|0098)?([ ]|-|[()]){0,2}9[0-9]([ ]|-|[()]){0,2}(?:[0-9]([ ]|-|[()]){0,2}){8}/.test(fixNumbers(mobile)) ) {
			e.preventDefault();
			alert(dlr.quick_user_empty_mobile);
		}
	});

	$(document).on( 'click', 'input[name=dlr_send_feedback]', function(e)
	{
		const email = $('input[name=dlr_feedback_reply_email]').val();
		const body  = $('textarea[name=dlr_feedback_body]').val();

		if ( email == '' ) {
			e.preventDefault();
			alert(dlr.feedback_empty_email);
		}

		if( !/\S+@\S+\.\S+/.test(email) ) {
			e.preventDefault();
			alert(dlr.feedback_empty_email);
		}

		if ( body == '' ) {
			e.preventDefault();
			alert(dlr.feedback_empty_body);
		}
	});

	var persianNumbers = [/۰/g, /۱/g, /۲/g, /۳/g, /۴/g, /۵/g, /۶/g, /۷/g, /۸/g, /۹/g],
	arabicNumbers  = [/٠/g, /١/g, /٢/g, /٣/g, /٤/g, /٥/g, /٦/g, /٧/g, /٨/g, /٩/g],
	fixNumbers = function (str) {
		if(typeof str === 'string') {
			
			for(var i=0; i<10; i++)
			{
				str = str.replace(persianNumbers[i], i).replace(arabicNumbers[i], i);
			}
			
		}
		return str;
	};

	$(document).on('change', '.dlr_reports_date_filter, .dlr_reports_status_filter', function()
	{
		var date = $('.dlr_reports_date_filter').find(":selected").val();
		var status = $('.dlr_reports_status_filter').find(":selected").val();
		$('.dlr_reports_table').css('opacity', '0.5');
		window.location.href = dlr.home + '/wp-admin/admin.php?page=dlr-settings&dlr_tab=reports&section=sendsms&date='+date+'&status='+status;
	});

	$(document).on( 'click', '.dlr_mobits_new_version_close', function(){
		$(this).parent().fadeOut(300, function() { $(this).remove(); });
	})

	$(document).on('change', '.dlr_wrongcodes_date_filter', function()
	{
		var date = $('.dlr_wrongcodes_date_filter').find(":selected").val();
		$('.dlr_reports_table').css('opacity', '0.5');
		window.location.href = dlr.home + '/wp-admin/admin.php?page=dlr-settings&dlr_tab=reports&section=wrongcodes&date='+date;
	});

	$(document).on('click', '.dlr_add_block_btn', function(){
		$('.dlr_block_box').slideToggle(300);
	});

	$(document).on('click', '.redirect_by_role', function()
	{
		var select = '<div><select name="_dlr_redirect_by_role_role[]" class="redirect_by_role_role">';
		select += dlr.roles;
		select += '</select>';

		var input = '<input class="regular-text" style="margin-right: 15px;" name="_dlr_redirect_by_role_address[]" placeholder="'+dlr.address+' ..." class="redirect_by_role_address" type="text" /> <span class="dlr_close_redirect">*</span></div>';
		$('.dlr_redirects').append(select+input);

		$('.redirect_by_role_role').select2({
			minimumResultsForSearch: -1,
			containerCssClass: "redirect_by_role_select2" 
		});
	});

	$(document).on('click', '.dlr_close_redirect', function(){
		$(this).parent().remove();
	});

	$('.redirect_by_role_role').select2(); 

	$(document).on('click', '.cs-nav li', function()
	{
		$('.cs-content article.active').removeClass('active');
		var id = $(this).attr('data-id');
		$('#'+id).addClass('active');

		if ( id != 'variables' ) {
			$('#'+id).fadeOut(50);
			$('#'+id).fadeIn(50);
		}
		
		$('.cs-nav li.active').removeClass('active');
		$(this).addClass('active');
	});

	$(document).on('click', '.dlr_customer_sms .cs-nav li', function()
	{
		var id = $(this).attr('data-id');
		localStorage.setItem('dlr_woocommerce_tab', id);
	})

	$(document).on('click', '.dlr_admin_sms .cs-nav li', function()
	{
		var id = $(this).attr('data-id');
		localStorage.setItem('dlr_woocommerce_tab_admin', id);
	})
});
