<?php
class Dlr_Admin_Enqueue extends Dlr_Admin
{
	public function __construct()
	{
		$this->init();
	}

	public function init()
	{
		add_action( 'admin_enqueue_scripts', [$this, 'enqueue_styles'] );
		add_action( 'admin_enqueue_scripts', [$this, 'enqueue_scripts'] );
	}

	public function enqueue_styles($screen) 
	{
		wp_enqueue_style( 'dlr-global-styles', DLR_ADMIN_ASSETS . 'css/dlr-admin-global.css', array(), DLR_VERSION, 'all' );

		if( $screen != 'toplevel_page_dlr-settings' ) return;

		wp_enqueue_style( DLR_NAME, DLR_ADMIN_ASSETS . 'css/dlr-admin.css', array(), DLR_VERSION, 'all' );
		
		if(is_rtl())
		    wp_enqueue_style( 'dlr-rtl-admin', DLR_ADMIN_ASSETS . 'css/dlr-rtl-admin.css', array(), DLR_VERSION, 'all' );

		wp_enqueue_style( 'select2-css', DLR_ADMIN_ASSETS . 'css/dlr-select2.css', array(), DLR_VERSION, 'all');
	}

	public function enqueue_scripts($screen) 
	{
		if ( $screen == 'user-edit.php' )
			wp_enqueue_script( 'dlr-users-scripts', DLR_ADMIN_ASSETS . 'js/dlr-users.js', array(), DLR_VERSION, false );

		if( $screen != 'toplevel_page_dlr-settings' ) return;

	    wp_enqueue_media();
		wp_enqueue_script( DLR_NAME, DLR_ADMIN_ASSETS . 'js/dlr-admin.js', array( 'jquery' ), DLR_VERSION, false );
	    wp_localize_script( DLR_NAME, 'dlr', array(
	       'home'   				=> home_url(),
	       'nonce' 					=> wp_create_nonce('wp_rest'),
		   'empty_file_error' 		=> __('Please select a file', 'dlr'),
		   'quick_user_empty_mobile'=> __('Please insert a value mobile number', 'dlr'),
		   'feedback_empty_email'   => __('Please insert a valid email', 'dlr'),
		   'feedback_empty_body'    => __('Please insert feedback body', 'dlr'),
		   'roles'					=> $this->get_avilable_roles($screen),
		   'address'    			=> __('Address', 'dlr'),
	    ));
		wp_enqueue_script( 'select2-js', DLR_ADMIN_ASSETS . 'js/dlr-select2.js', array(), DLR_VERSION, false );
	}

	private function get_avilable_roles($screen)
	{ 
		if( isset($_GET['dlr_tab']) && $_GET['dlr_tab'] != 'redirect' ) return [];

		global $wp_roles;
		$output = '';
		foreach( $wp_roles->roles as $key=>$role ) 
		{
			if ( $role["name"] != 'Administrator' ) 
			$output .= '<option value="'.$key.'">'.translate_user_role($role["name"]).'</option>';
		}

		return $output;
	}
}