<?php
class Dlr_Rest
{
	public function __construct()
	{
		$this->init();
	}

	public function init()
	{
		add_action( 'rest_api_init', [$this, 'dlr_admin_rest_api_init'] );
	}

	public function dlr_admin_rest_api_init()
    {
        register_rest_route( 'api', '/sendSmsMelliPayamakAdmin', array(
            'methods' => 'post',
            'callback' => [$this, 'send_mellipayamak_admin_rest_callback'],
			'permission_callback'   => function () {
                return current_user_can('administrator');
            }
        ));

		register_rest_route( 'api', '/sendSmsFaraPayamakAdmin', array(
            'methods' => 'post',
            'callback' => [$this, 'send_farapayamak_admin_rest_callback'],
			'permission_callback'   => function () {
                return current_user_can('administrator');
            }
        ));

		register_rest_route( 'api', '/sendSmsPayamitoAdmin', array(
            'methods' => 'post',
            'callback' => [$this, 'send_payamito_admin_rest_callback'],
			'permission_callback'   => function () {
                return current_user_can('administrator');
            }
        ));
        
        register_rest_route( 'api', '/sendSmsIppanelAdmin', array(
            'methods' => 'post',
            'callback' => [$this, 'send_ippanel_admin_rest_callback'],
			'permission_callback'   => function () {
                return current_user_can('administrator');
            }
        ));
        
        register_rest_route( 'api', '/sendSmsSmsirAdmin', array(
            'methods' => 'post',
            'callback' => [$this, 'send_smsir_admin_rest_callback'],
			'permission_callback'   => function () {
                return current_user_can('administrator');
            }
        ));

		register_rest_route( 'api', '/sendSmsPayamresanAdmin', array(
            'methods' => 'post',
            'callback' => [$this, 'send_payamresan_admin_rest_callback'],
			'permission_callback'   => function () {
                return current_user_can('administrator');
            }
        ));

		register_rest_route( 'api', '/sendSmsKavenegarAdmin', array(
            'methods' => 'post',
            'callback' => [$this, 'send_kavenegar_admin_rest_callback'],
			'permission_callback'   => function () {
                return current_user_can('administrator');
            }
        ));

		register_rest_route( 'api', '/dlrGetOrderSms', array(
            'methods' => 'post',
            'callback' => [$this, 'dlr_get_order_sms'],
			'permission_callback'   => '__return_true'
        ));
    }

	private function randomNumber($length) {
		$result = '';

		for($i = 0; $i < $length; $i++) {
			$result .= mt_rand(0, 9);
		}

		return $result;
	}

	public function send_mellipayamak_admin_rest_callback($data)
    {
	    $params = $data->get_params();

		$fields_string = "";

		$data = [
			'username' 	=> $params['username'],
			'password' 	=> $params['password'],
			'text' 		=> $this->randomNumber( get_option('_dlr_number_of_codes', 4) ),
			'to' 		=> $params['mobile'],
			'bodyId' 	=> $params['bodyId']
		];

		if ( ! is_null($data) ) 
		{
			$fields_string = http_build_query($data);
		}

		$url = "https://rest.payamak-panel.com/api/SendSMS/BaseServiceNumber";

		$handle = curl_init();

		curl_setopt($handle, CURLOPT_URL, $url);
		curl_setopt($handle, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($handle, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($handle, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($handle, CURLOPT_POST, true);
		curl_setopt($handle, CURLOPT_POSTFIELDS, $fields_string);

		$server_output  = json_decode( curl_exec($handle) );
		
		$value = $server_output->RetStatus == 1 ? 1 : $server_output->Value;
		return $this->melipayamak_status($value);
    }

	public function send_farapayamak_admin_rest_callback($data)
    {
	    $params = $data->get_params();

		$fields_string = "";

		$data = [
			'username' 	=> $params['username'],
			'password' 	=> $params['password'],
			'text' 		=> $this->randomNumber( get_option('_dlr_number_of_codes', 4) ),
			'to' 		=> $params['mobile'],
			'bodyId' 	=> $params['bodyId'] 
		];

		if ( ! is_null($data) ) 
		{
			$fields_string = http_build_query($data);
		}

		$url = "https://rest.payamak-panel.com/api/SendSMS/BaseServiceNumber";

		$handle = curl_init();

		curl_setopt($handle, CURLOPT_URL, $url);
		curl_setopt($handle, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($handle, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($handle, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($handle, CURLOPT_POST, true);
		curl_setopt($handle, CURLOPT_POSTFIELDS, $fields_string);

		$server_output  = json_decode( curl_exec($handle) );
		
		$value = $server_output->RetStatus == 1 ? 1 : $server_output->Value;
		return $this->melipayamak_status($value);
    }

	public function send_payamito_admin_rest_callback($data)
    {
	    $params = $data->get_params();

		$fields_string = "";

		$data = [
			'username' 	=> $params['username'],
			'password' 	=> $params['password'],
			'text' 		=> $this->randomNumber( get_option('_dlr_number_of_codes', 4) ),
			'to' 		=> $params['mobile'],
			'bodyId' 	=> $params['bodyId'] 
		];

		if ( ! is_null($data) ) 
		{
			$fields_string = http_build_query($data);
		}

		$url = "https://rest.payamak-panel.com/api/SendSMS/BaseServiceNumber";

		$handle = curl_init();

		curl_setopt($handle, CURLOPT_URL, $url);
		curl_setopt($handle, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($handle, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($handle, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($handle, CURLOPT_POST, true);
		curl_setopt($handle, CURLOPT_POSTFIELDS, $fields_string);

		$server_output  = json_decode( curl_exec($handle) );
		
		$value = $server_output->RetStatus == 1 ? 1 : $server_output->Value;
		return $this->melipayamak_status($value);
    }

	private function melipayamak_status($value)
	{
		switch($value)
		{
			case "-7":
				return "خطایی در شماره فرستنده رخ داده است با پشتیبانی تماس بگیرید";
				break;
			case "-6":
				return "خطای داخلی رخ داده است با پشتیبانی تماس بگیرید";
				break;
			case "-5":
				return "متن ارسالی باتوجه به متغیرهای مشخص شده در متن پیشفرض همخوانی ندارد";
				break;
			case "-4":
				return "کد متن ارسالی صحیح نمی‌باشد و یا توسط مدیر سامانه تأیید نشده است";
				break;
			case "-3":
				return "خط ارسالی در سیستم تعریف نشده است، با پشتیبانی سامانه تماس بگیرید";
				break;
			case "-2":
				return "محدودیت تعداد شماره، محدودیت هربار ارسال یک شماره موبایل می‌باشد";
				break;
			case "-1":
				return "دسترسی برای استفاده از این وبسرویس غیرفعال است. با پشتیبانی تماس بگیرید";
				break;
			case "0":
				return "نام کاربری یا رمزعبور صحیح نمی‌باشد";
				break;
			case "2":
				return "اعتبار کافی نمی‌باشد";
				break;
			case "6":
				return "سامانه درحال بروزرسانی می‌باشد";
				break;
			case "7":
				return "متن حاوی کلمه فیلتر شده می‌باشد، با واحد اداری تماس بگیرید";
				break;
			case "10":
				return "کاربر موردنظر فعال نمی‌باشد";
				break;
			case "11":
				return "ارسال نشده";
				break;
			case "12":
				return "مدارک کاربر کامل نمی‌باشد";
				break;
			case "35":
				return "وجود شماره موبایل گیرنده در لیست سیاه مخابرات";
				break;
			case "1":
				return "با موفقیت ارسال گردید";
				break;
			default: 
				return "خطای نامشخص";
		}
	}
    
    public function send_ippanel_admin_rest_callback($data)
    {
        $params = $data->get_params();
        
        $username 	= $params['username'];
		$password 	= $params['password'];
		$from 		= $params['from'];
		$pattern_code = $params['bodyId'];
		$to 		= array($params['mobile']);
		$input_data = array(
        	"verification-code" => $this->randomNumber( get_option('_dlr_number_of_codes', 4) )
        );
		$url = "https://ippanel.com/patterns/pattern?username=" . $username . "&password=" . urlencode($password) . "&from=$from&to=" . json_encode($to) . "&input_data=" . urlencode(json_encode($input_data)) . "&pattern_code=$pattern_code";
		$handler = curl_init($url);
		curl_setopt($handler, CURLOPT_CUSTOMREQUEST, "POST");
		curl_setopt($handler, CURLOPT_POSTFIELDS, $input_data);
		curl_setopt($handler, CURLOPT_RETURNTRANSFER, true);
		$output = json_decode(curl_exec($handler));

		return $this->ippanel_status($output);
    }

	private function ippanel_status($output)
	{
		if ( $output == '' ) return "شناسه قالب نامعتبر می باشد.";
		if ( is_numeric ($output) ) return "پیامک با موفقیت ارسال گردید.";

		if ( !is_array($output) ) return "خطای نامشخص، لطفا با پشتیبانی تماس بگیرید.";

		switch($output[0])
		{
			case "2":
				return "کاربر محدود گردیده است.";
				break;
			case "3":
				return "خط به شما تعلق ندارد.";
				break;
			case "5":
				return "اعتبار کافی نیست.";
				break;
			case "9":
				return "خط مورد نظر در این ساعت امکان ارسال ندارد.";
				break;
			case "99":
				return "اپراتور خط ارسالی قطع می‌باشد.";
				break;
			case "301":
				return "از حرف ویژه در نام کاربری استفاده گردیده است.";
				break;
			case "303":
				return "نام کاربری وارد نگردیده است.";
				break;
			case "305":
				return "نام کاربری وارد نگردیده است.";
				break;
			case "317":
				return "کلمه عبور وارد نشده است.";
				break;
			case "962":
				return "نام کاربری یا کلمه عبور نادرست می باشد.";
				break;
			case "971":
				return "پترن ارسالی نامعتبر است.";
				break;
			case "970":
				return "پارامتر های ارسالی برای پترن نامعتبر است.";
				break;
			case "994":
				return "لطفا تصویری از کارت بانکی خود را از منو مدارک ارسال کنید";
				break;
			case "998":
				return "کارت ملی یا کارت بانکی شما تایید نشده است.";
				break;
			default: 
				return "خطای نامشخص";
		}
	}
    
    public function send_smsir_admin_rest_callback($data) 
    {
	    $mobile 	= $data['mobile'];
        
        $curl = curl_init();

        curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://api.sms.ir/v1/send/verify',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS =>'{
            "mobile": "'.$mobile.'",
            "templateId": '.$data["bodyId"].',
            "parameters": [
                {
                  "name": "CODE",
                  "value": "'.$this->randomNumber( get_option('_dlr_number_of_codes', 4) ).'"
                }
            ]
        }',
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'Accept: text/plain',
            'x-api-key: '.$data['key']
        ),
        ));
        
        $response = curl_exec($curl);
        
        curl_close($curl);
        
        return $response;
    }

	public function send_payamresan_admin_rest_callback ( $data )
    {
        $params = array(
			'ApiKey' 		=> $data['key'],
			'TemplateKey' 	=> $data['theme'],
			'Destination' 	=> $data['mobile'],
			'p1' 			=> $this->randomNumber( get_option('_dlr_number_of_codes', 4) )
		);

		$BaseUrl = "http://api.sms-webservice.com/api/V3/";

		$url = $BaseUrl.'SendTokenSingle?' . http_build_query($params);
		$curl = curl_init();
		curl_setopt_array($curl, array(
			CURLOPT_URL => $url,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'GET',
		));

		$response = json_decode( curl_exec($curl) );
		curl_close($curl);

		return $response->Success == true ? 'پیام با موفقیت ارسال شد.' : $response->Error;
    }

	public function send_kavenegar_admin_rest_callback($data)
    {
	    $params 	= $data->get_params();
    	$key   		= $params['key'];

		$url = 'https://api.kavenegar.com/v1/'.$key.'/verify/lookup.json?';

		$fields = array(
			'receptor' 	=> $params['mobile'],
			"template" 	=> $params['theme'],
			"token"		=> $this->randomNumber( get_option('_dlr_number_of_codes', 4) )
		);

		$ch = curl_init();
		curl_setopt( $ch,CURLOPT_URL, $url );
		curl_setopt( $ch,CURLOPT_POST, true );
		curl_setopt( $ch,CURLOPT_POSTFIELDS, http_build_query($fields) );
		curl_setopt( $ch,CURLOPT_RETURNTRANSFER, true );
		curl_setopt( $ch,CURLOPT_SSL_VERIFYPEER, false );

		$response = json_decode(curl_exec($ch));
		curl_close($ch);
		
		return $response->return->status == 200 ? $response->entries[0]->statustext : $response->return->message;
    }

	public function dlr_get_order_sms ($data)
	{
		$status = $data['status'];
		$status = str_replace("wc-", "", $status);

		switch ( $status ) {
			case 'on-hold':
				$status = 'onhold';
				break;
			case 'checkout-draft':
				$status = 'draft';
				break;
		}

		$sms_status = get_option('_dlr_customer_'.$status.'_sms_status', 0);
		$checked = $sms_status==1 ? 'checked="checked"' : '';
		$sms_type = get_option('_dlr_'.$status.'_sms_type', 'text');

		if ( $sms_type == 'template' ) 
		{
			return '
				<div>
					<input '.$checked.' id="dlr_order_sms_status" type="checkbox" name="dlr_order_sms_status" />
					<label for="dlr_order_sms_status">'.__("Send sms (mobits)", "dlr").' ('.__("templatable", "dlr").')</label>
				</div>
			';
		}

		$sms_body 	= get_option('_dlr_customer_'.$status.'_sms_body', '');

		$output = '';
		$notdisplay = $sms_status==1 ? '' : 'display: none;';
		$output .= '
			<div>
				<input '.$checked.' id="dlr_order_sms_status" type="checkbox" name="dlr_order_sms_status" />
				<label for="dlr_order_sms_status">'.__("Send sms (mobits)", "dlr").' ('.__("Textable", "dlr").')</label>
			</div>

			<div class="dlr_order_sms_body" style="'.$notdisplay.'">
				<label for="dlr_order_sms_body">'.__("Sms body", "dlr").'</label>
				<textarea rows="10" id="dlr_order_sms_body" name="dlr_order_sms_body" >'.$sms_body.'</textarea>
			</div>
		';

		return $output;
	}
}

new Dlr_Rest();