<?php 
class Dlr_Settings extends Dlr_Admin
{
	public static $wpdb;
	private static $options;
	public static $table;

	public function __construct()
	{
		global $wpdb;
		self::$wpdb = $wpdb;
		self::$table = $wpdb->prefix . "dlr_activation";
		
		$this->define_constants();
	}

	public function define_constants() 
	{
		$this->define( 'DLR_ABSPATH', dirname( DLR_PLUGIN_FILE ) . '/' );
	}

	public static function dlr_main_settings () 
	{
		parent::ok_mobits();

		$path = isset($_GET['dlr_tab']) ? $_GET['dlr_tab'] : 'general';
		require DLR_PARTIALS . '/settings/class-dlr-settings-'.$path.'.php';
	}

	public static function template_loader($path)
	{
		require DLR_PARTIALS . $path;
	}

	private static function _prepare_in ( $values ) 
	{
		return implode( ',', array_map( function ( $value ) {
			return self::$wpdb->prepare( '%s', $value );
		}, $values ) );
	}

	public static function admin_options($args)
	{
		if( !isset($args[0]) ) return [];

		$status = sprintf(
			'option_name IN (%s)',
			self::_prepare_in( $args )
		);

		global $wpdb;

		$table = $wpdb->prefix . 'options';

		$results = $wpdb->get_results( "SELECT option_name,option_value FROM $table WHERE $status;" );
		
		$output = [];
		
		foreach($results as $item)
			$output[$item->option_name] = $item->option_value;

		foreach( $args as $item ) 
			if ( !isset( $output[$item] ) ) $output[$item] = '';

		return $output;
	}

	public static function save_settings ($args)
	{
		date_default_timezone_set('Asia/Tehran');

		$dlr_woo_admins = [];
		foreach ( WOO_STATUSES as $key=>$status ) 
			$dlr_woo_admins[] = '_dlr_admin_'.$key.'_managers';
		
        foreach( $args as $value )
        {
			if ( $value == 'dlr_delete_extra_code_time' ) 
			{
				if ( $_POST[$value] == '-1' ) 
				{
					wp_clear_scheduled_hook( 'dlr_delete_extra_code' );
				}
				else 
				{
					wp_clear_scheduled_hook( 'dlr_delete_extra_code' );
					if ( get_option('dlr_delete_extra_code_time') != $_POST[$value] && ! wp_next_scheduled('dlr_delete_extra_code') ) 
					{
						wp_schedule_event( strtotime($_POST[$value]), 'dlr_delete_extra_code_interval', 'dlr_delete_extra_code');
					}
				}
				$output = $_POST[$value];
			}
			else if ( $value == 'dlr_delete_sendsms_report' ) 
			{
				if ( $_POST[$value] == '-1' ) 
				{
					wp_clear_scheduled_hook( 'dlr_delete_sendsms_report' );
				}
				else 
				{
					wp_clear_scheduled_hook( 'dlr_delete_sendsms_report' );
					if ( get_option('dlr_delete_sendsms_report') != $_POST[$value] && ! wp_next_scheduled('dlr_delete_sendsms_report') ) 
					{
						wp_schedule_event( time(), 'dlr_delete_sendsms_report_interval', 'dlr_delete_sendsms_report');
					}
				}
				$output = $_POST[$value];
			}
			else if ( $value == 'dlr_delete_wrongcodes_report' ) 
			{
				if ( $_POST[$value] == '-1' ) 
				{
					wp_clear_scheduled_hook( 'dlr_delete_wrongcodes_report' );
				}
				else 
				{
					wp_clear_scheduled_hook( 'dlr_delete_wrongcodes_report' );
					if ( get_option('dlr_delete_wrongcodes_report') != $_POST[$value] && ! wp_next_scheduled('dlr_delete_wrongcodes_report') ) 
					{
						wp_schedule_event( time(), 'dlr_delete_wrongcode_report_interval', 'dlr_delete_wrongcodes_report');
					}
				}
				$output = $_POST[$value];
			}
			else if (
				$value == '_display_mobits_menu' || 
				$value == '_dlr_redirect_by_role_role' || 
				$value == '_dlr_redirect_by_role_address' || 
				$value == '_limit_panel_access_by_role' || 
				$value == '_limit_admin_bar_by_role' || 
				in_array( $value, $dlr_woo_admins )
				) 
				{
				$output = isset($_POST[$value]) ? $_POST[$value] : [];
			}
			else {
				$output = isset($_POST[$value]) ? wp_kses_post($_POST[$value]) : '0';
			}
            
			update_option( $value, $output );
            
            if( $value == '_dlr_page_slug' && $_POST[$value] === ""  )
                update_option( $value, 'dlr-login-register' );
        }
        
        add_rewrite_endpoint( get_option('_dlr_page_slug', 'dlr-login-register'), EP_ROOT );
        flush_rewrite_rules();
	}
}

new Dlr_Settings();
