<?php
class Dlr_Update_Notifier extends Mobits
{
	public function __construct()
	{
		$this->define_constants();
		$this->init();
	}

	public function define_constants() 
	{
		$this->define( 'DLR_NOTIFIER_PLUGIN_FOLDER_NAME', 'mobits' );
		$this->define( 'DLR_NOTIFIER_PLUGIN_FILE_NAME', '/dlr.php' );
		$this->define( 'DLR_NOTIFIER_PLUGIN_XML_FILE', 'https://biawp.ir/mobits-notifier.xml' );
		$this->define( 'DLR_PLUGIN_NOTIFIER_CACHE_INTERVAL', 5 );
	}

	public function init()
	{
		add_action( 'admin_bar_menu', [$this, 'dlr_update_notifier_bar_menu'], 1000 );
	}

	public function dlr_update_notifier_bar_menu()
	{
		if ( function_exists( 'simplexml_load_string' ) ) 
		{
			global $wp_admin_bar, $wpdb;

			if ( ! is_admin_bar_showing() )
			return;

			$xml = $this->dlr_get_latest_plugin_version( DLR_PLUGIN_NOTIFIER_CACHE_INTERVAL );

			if(is_admin()) 
			{
				$plugin_data 	= get_plugin_data( WP_PLUGIN_DIR . '/' . DLR_NOTIFIER_PLUGIN_FOLDER_NAME . '/' .DLR_NOTIFIER_PLUGIN_FILE_NAME );
				if( (string) $xml->latest > (string) $plugin_data['Version'] ) {
					$wp_admin_bar->add_menu( array( 
						'id' => 'new_mobits', 
						'title' => '<span>'.__('New mobits', 'dlr').'</span>', 
						'href' => 'https://biawp.ir/product/mobits-login-register-with-mobile-wordpress-plugin', 
						'meta'  => array(
							'target'=> '_blank',
							'title' => __('New mobits', 'dlr'),
						),
					) );
				}
			}
			
		}
	}

	private function dlr_get_latest_plugin_version( $interval ) 
	{
		$notifier_file_url = DLR_NOTIFIER_PLUGIN_XML_FILE;	
		$db_cache_field = 'notifier-cache';
		$db_cache_field_last_updated = 'notifier-cache-last-updated';
		$last = get_option( $db_cache_field_last_updated );
		$now = time();

		if ( ! $last || ( ( $now - $last ) > $interval ) ) {
			if( function_exists( 'curl_init' ) ) {
				$ch = curl_init( $notifier_file_url );
				curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );
				curl_setopt( $ch, CURLOPT_HEADER, 0 );
				curl_setopt( $ch, CURLOPT_TIMEOUT, 10 );
				$cache = curl_exec( $ch );
				curl_close( $ch );
			} else {
				$cache = file_get_contents( $notifier_file_url );
			}

			if ( $cache ) {				
				update_option( $db_cache_field, $cache );
				update_option( $db_cache_field_last_updated, time() );
			} 
			$notifier_data = get_option( $db_cache_field );
		}
		else {
			$notifier_data = get_option( $db_cache_field );
		}

		if( strpos( (string) $notifier_data, '<notifier>' ) === false ) {
			$notifier_data = '<?xml version="1.0" encoding="UTF-8"?><notifier><latest>1.0</latest><changelog></changelog></notifier>';
		}

		$xml = simplexml_load_string( $notifier_data ); 
		return $xml;
	}
}