<?php 

class Dlr_Admin_Users extends Dlr_Admin
{
	public function __construct()
	{
		$this->init();
	}

	public function init()
	{
		add_action( 'user_profile_update_errors', [$this, 'dlr_user_profile_update_errors'], 10, 3 );
		add_action( 'user_new_form', [$this, 'dlr_remove_require_email'], 10, 1);
        add_action( 'show_user_profile', [$this, 'dlr_remove_require_email'], 10, 1);
        add_action( 'edit_user_profile', [$this, 'dlr_remove_require_email'], 10, 1);

		add_filter( 'manage_users_custom_column', [$this, 'dlr_manage_users_custom_column'], 10, 3 );
		add_filter( 'manage_users_columns', [$this, 'dlr_manage_users_columns'] );

		add_filter( 'bulk_actions-users', [$this, 'dlr_bulk_actions_users'] );
		add_filter( 'handle_bulk_actions-users' , [$this, 'dlr_handle_bulk_actions_users'], 10, 3);
		
		add_action( 'restrict_manage_users', [$this, 'restrict_manage_users'] );
		add_filter( 'pre_get_users', [$this, 'pre_get_users'] );

		add_action( 'personal_options_update', [ $this, 'edit_user_profile_update'] );
		add_action( 'edit_user_profile_update',  [ $this, 'edit_user_profile_update' ] );

		add_filter( 'manage_users_sortable_columns', [$this, 'manage_users_sortable_columns'] );
	}

	function edit_user_profile_update($user_id)
	{
		$nun = $_POST['dlr_new_username'];

		$user = get_user_by('login', $nun);

		if ( $nun != '' && $user == null ) 
		{
			global $wpdb;
			$wpdb->update(
				$wpdb->prefix . 'users',
				[
					'user_login' => $nun,
				],
				[
					'ID'	=> $user_id
				]
			);
		}
	}

	function dlr_user_profile_update_errors($errors, $update, $user) 
	{
        $errors->remove('empty_email');
    }

	function dlr_remove_require_email($form_type)
    {
        ?>
        <script type="text/javascript">
        jQuery('#email').closest('tr').removeClass('form-required').find('.description').remove();
        <?php if (isset($form_type) && $form_type === 'add-new-user') : ?>
        jQuery('#send_user_notification').removeAttr('checked');
        <?php endif; ?>
        </script>
        <?php
    }

	public function manage_users_sortable_columns ( $columns )
	{
		if( get_option('_dlr_sort_users_by_date', 0) == 1 )
			return wp_parse_args( array( 'dlr_sort_users_by_date' => 'registered' ), $columns );

		return $columns;
	}

	public function dlr_manage_users_custom_column ( $val, $column_name, $user_id )
	{
		$date_format = 'Y-m-d';

		if ( !function_exists('jdate1') ) {
			require_once DLR_BASE . '/libs/jdf.php';
		}

		switch ($column_name) 
		{
			case 'dlr_last_login' :
                $d = get_user_meta( $user_id, 'dlr_last_login', true );
				return $d!='' ? $this->dlr_to_persian( get_user_meta( $user_id, 'dlr_last_login', true ) ) : '';
			break;
			case 'dlr_user_status' :
                $x = get_user_meta( $user_id, 'dlr_user_status', true );
				return $x==1 || $x=='' ? '<span class="dlr_user_status_active">'.__("Active", "dlr").'</span>' : '<span class="dlr_user_status_block">'.__("Block", "dlr").'</span>';
			break;
			case 'dlr_sort_users_by_date':
				return jdate1( $date_format, strtotime( get_the_author_meta( 'registered', $user_id ) ) );
				break;
		}
		return $val;
	}

	public function dlr_manage_users_columns ( $column )
	{
		if( get_option('_dlr_last_login', 0) == 1 )
			$column['dlr_last_login'] = __('Last login (Mobits)', 'dlr');

		$column['dlr_user_status'] = __('User status (Mobits)', 'dlr');

		if( get_option('_dlr_sort_users_by_date', 0) == 1 )
			$column['dlr_sort_users_by_date'] = __('Register date', 'dlr');

    	return $column;
	}

	public function dlr_to_persian($date) 
    {
        $date = explode( "-", gmdate( "Y-m-d", $date ) );
        $gy = $date[0];
        $gm = $date[1];
        $gd = $date[2];

        $g_d_m = array(0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334);
        $gy2 = ($gm > 2)? ($gy + 1) : $gy;
        $days = 355666 + (365 * $gy) + ((int)(($gy2 + 3) / 4)) - ((int)(($gy2 + 99) / 100)) + ((int)(($gy2 + 399) / 400)) + $gd + $g_d_m[$gm - 1];
        $jy = -1595 + (33 * ((int)($days / 12053)));
        $days %= 12053;
        $jy += 4 * ((int)($days / 1461));
        $days %= 1461;
        if ($days > 365) {
            $jy += (int)(($days - 1) / 365);
            $days = ($days - 1) % 365;
        }
        if ($days < 186) {
            $jm = 1 + (int)($days / 31);
            $jd = 1 + ($days % 31);
        } else{
            $jm = 7 + (int)(($days - 186) / 30);
            $jd = 1 + (($days - 186) % 30);
        }

        return $jy .'/'. $jm .'/'. $jd;
    }

	public function dlr_bulk_actions_users($bulk_actions)
    {
		if ( get_option('_dlr_export_csv', '0') == 1 )
		{
			$bulk_actions['_dlr_export_csv'] = __('Excel output of users', 'dlr');
		}
        	

		$bulk_actions['dlr_set_user_active'] 	= __('Active user (Mobits)', 'dlr');
		$bulk_actions['dlr_set_user_block'] 	= __('Block user (Mobits)', 'dlr');

	    return $bulk_actions;
    }
    
    public function dlr_handle_bulk_actions_users($redirect, $action, $object_ids)
    {
        if ($action == '_dlr_export_csv') 
        {
    		$users = get_users(array(
    		    'include' =>  $object_ids,
    		    'fields'  => array('ID' ,'user_login')
    		));
    		
    		$FileName = 'users.csv';
    		$fp = fopen($FileName, 'w');
    		
    		foreach($users as $user) 
    		{
    		    $row = [
    		        'mobile' => $user->user_login,
    		        'name' => get_user_meta($user->ID, 'first_name', true),
    		        'last' => get_user_meta($user->ID, 'last_name', true)
    		    ];
    		    
    		    fputcsv($fp, $row);
    		}
    		
            fclose($fp);
            header("Location: $FileName");
			return;
    	}

		if ($action == 'dlr_set_user_active') 
        {
    		$users = get_users(array(
    		    'include' =>  $object_ids,
    		    'fields'  => array('ID' ,'user_login')
    		));
    		
    		foreach($users as $user) 
    		{
    		    update_user_meta( $user->ID, 'dlr_user_status', 1 );
    		}
    	}

		if ($action == 'dlr_set_user_block') 
        {
    		$users = get_users(array(
    		    'include' =>  $object_ids,
    		    'fields'  => array('ID' ,'user_login')
    		));
    		
    		foreach($users as $user) 
    		{
    		    update_user_meta( $user->ID, 'dlr_user_status', 0 );
    		}
    	}
		
		return $redirect;
    }

    function restrict_manage_users($which) 
	{
		$st = '<select name="dlrstatus_%s" class="dlr_filter_status">
			<option value="">%s</option>%s</select>';


		$selected = isset($_GET["dlrstatus_top"]) && $_GET["dlrstatus_top"]=='active' ? 'selected="selected"' : '';
		$options = '<option '.$selected.' value="active">'.__("Active", "dlr").'</option>';

		$selected = isset($_GET["dlrstatus_top"]) && $_GET["dlrstatus_top"]=='block' ? 'selected="selected"' : '';
		$options .= '<option '.$selected.' value="block">'.__("Block", "dlr").'</option>';

		$select = sprintf( $st, $which, __("All users", "dlr"), $options );

		echo $select;
		submit_button(__( 'Filter' ), false, $which, false);
    }
	
	function pre_get_users($query)
	{
		 global $pagenow;
		
		 if ( is_admin() && 'users.php' == $pagenow ) 
		 {

			  $dlrstatus = isset( $_GET['dlrstatus_top'] ) && $_GET['dlrstatus_top'] != '' ? $_GET['dlrstatus_top'] : null;

			  if ( $dlrstatus )
			  {
				  
				  if( $dlrstatus == 'block' ) 
				  {
					  $meta_query = array ( array (
						  'key' 	=> 'dlr_user_status',
						  'value' 	=> 0,
						  'compare' => 'LIKE'
					   ) );
				  }
				  else 
				  {
					  $meta_query = array ( 
						  'relation'	=> 'or',
						  array (
							  'key' 	=> 'dlr_user_status',
							  'value' 	=> 1
						   ), 
						  array (
							  'key' 	=> 'dlr_user_status',
							  'compare'	=> 'NOT EXISTS'
						  ),
					  );
				  }
				   

				   $query->set('meta_query', $meta_query);
			 }
			 
		 }
	}
}