<?php 

defined( 'ABSPATH' ) || exit;

class Dlr_Settings_Captcha extends Dlr_Settings
{
	private static $options = [
		'_dlr_google_captcha_in_login_form',
		'_dlr_google_captcha_in_register_form',
		'_dlr_google_captcha_in_recovery_form',
		'_dlr_google_recaptchav2_site_key'
	];

	public function __construct()
	{
		self::controller();
		self::load_template();
	}

	private static function controller()
	{
		if ( isset( $_POST['dlr_submit'] ) ) parent::save_settings( self::$options );
	}

	private static function load_template()
	{
		$GLOBALS['dlr_options'] = parent::admin_options( self::$options );

		parent::template_loader('settings/header.php');
		parent::template_loader('settings/templates/captcha.php');
		parent::template_loader('settings/footer.php');
	}
}

new Dlr_Settings_Captcha();