<?php 

defined( 'ABSPATH' ) || exit;

class Dlr_Settings_Design extends Dlr_Settings
{
	private static $options = [
		'_dlr_logo',
		'_dlr_favicon',
		'_dlr_background_image',
		'_dlr_description',
		'_dlr_color',
		'_dlr_color_tab',
		'_dlr_form_width',
		'_dlr_extra_style',
		'_dlr_dark_mode_status',
		'_dlr_design_type',
		'_dlr_button_image'
	];

	public function __construct()
	{
		self::controller();
		self::load_template();
	}

	private static function controller()
	{
		if ( isset( $_POST['dlr_submit'] ) ) parent::save_settings( self::$options );
	}

	private static function load_template()
	{
		$GLOBALS['dlr_options'] = parent::admin_options( self::$options );

		parent::template_loader('settings/header.php');
		parent::template_loader('settings/templates/design.php');
		parent::template_loader('settings/footer.php');
	}
}

new Dlr_Settings_Design();