<?php 

defined( 'ABSPATH' ) || exit;

class Dlr_Settings_General extends Dlr_Settings
{
	private static $options;

	public function __construct()
	{
		if ( !isset( $_GET['section'] ) || $_GET['section'] == 'general' ) 
		{
			self::$options = [
				'_dlr_page_slug',
				'_dlr_recovery_status',
				'_dlr_limit_wrong_code',
				'_dlr_resend_code_time',
				'_dlr_update_notice_in_admin_bar',
				'_dlr_display_header',
				'_dlr_display_footer',
				'_dlr_number_of_codes',
			];
		}
		else if ( $_GET['section'] == 'font' ) 
		{
			self::$options = [
				'_dlr_font_global',
				'_dlr_public_font',
				'_dlr_admin_font',
			];
		}
		else if ( $_GET['section'] == 'user-management' ) 
		{
			self::$options = [
				'_display_mobits_menu',
				'_limit_panel_access_by_role',
				'_limit_admin_bar_by_role',
				'_dlr_sort_users_by_date'
			];
		}
		else if ( $_GET['section'] == 'optimization' ) 
		{
			self::$options = [
				'dlr_delete_extra_code_time',
				'_dlr_delete_mobits_data',
			];
		}
		else if ( $_GET['section'] == 'mobits-button' ) 
		{
			self::$options = [
				'mobits_button_panel_link',
				'mobits_button_logined_text',
				'mobits_button_logout_text',
				'mobits_button_color',
				'mobits_button_background',
				'mobits_button_fontsize',
				'mobits_button_padding',
				'mobits_button_border',
				'mobits_button_submenu',
				'mobits_button_submenu_align'
			];
		}

		self::controller();
		self::load_template();
	}

	private static function controller()
	{
		if ( isset( $_POST['dlr_submit'] ) ) parent::save_settings( self::$options );
		if ( isset( $_POST['dlr_optimize'] ) ) self::dlr_optimize_database();
	}

	private static function load_template()
	{  
		$GLOBALS['dlr_unused_code'] = self::unused_codes_count();

		$GLOBALS['dlr_options'] = parent::admin_options( self::$options );

		$GLOBALS['dlr_roles'] 	= self::get_avilable_roles(0);
		$GLOBALS['dlr_roles1'] 	= self::get_avilable_roles(1);
		$GLOBALS['dlr_roles2'] 	= self::get_avilable_roles(2);

		parent::template_loader('settings/header.php');
		parent::template_loader('settings/templates/general.php');
		parent::template_loader('settings/footer.php');
	}

	private static function get_avilable_roles($rolee) 
	{
		global $wp_roles;
		$all_roles = $wp_roles->roles;
		
		$options = '';

		switch ($rolee)
		{
			case 0:
				$selecteds = get_option('_display_mobits_menu', []);
				break;
			case 1:
				$selecteds = get_option('_limit_panel_access_by_role', []);
				break;
			case 2:
				$selecteds = get_option('_limit_admin_bar_by_role', []);
				break;
		}

		$selecteds = $selecteds == '' ? [] : $selecteds;

		foreach( $all_roles as $role )
		{
			if ( $role["name"] != 'Administrator' ) 
			{
				$selected = in_array( strtolower($role["name"]), $selecteds ) ? 'selected="selected"' : '';
				$options .= '<option '.$selected.' value="'.strtolower($role["name"]).'">'.translate_user_role($role["name"]).'</option>';
			}
				
		}

		return $options;
	}

	private static function dlr_optimize_database()
	{
		parent::$wpdb->query("TRUNCATE TABLE ".parent::$table);
	}

	private static function unused_codes_count() 
	{
		$count = parent::$wpdb->get_var("SELECT COUNT(*) FROM ".parent::$table);

		$output = $count !=0 ? $count . ' ' . __('unused records found.', 'dlr') : __('No unused codes found.', 'dlr');
		return $output;
	}
}

new Dlr_Settings_General();