<?php 

defined( 'ABSPATH' ) || exit;

class Dlr_Settings_Import_Export extends Dlr_Settings
{
	private static $options = [
		'_dlr_export_csv'
	];

	public function __construct()
	{
		self::controller();
		self::load_template();
	}

	private static function controller()
	{
		if ( isset( $_POST['dlr_submit'] ) ) parent::save_settings( self::$options );

		if ( isset( $_POST['quick_user_create'] ) ) self::dlr_quick_user_create();

		if ( isset( $_POST['dlr_import'] ) ) self::import_csv();

		if ( isset ( $_POST['get_settings_export'] ) ) self::get_settings_export();

		if ( isset ( $_POST['dlr_import_settings'] ) ) self::dlr_import_settings();
	}

	private static function get_settings_export()
	{
		$options = [
			'_dlr_page_slug',
			'_dlr_recovery_status',
			'_dlr_limit_wrong_code',
			'_dlr_resend_code_time',
			'_dlr_update_notice_in_admin_bar',
			'_dlr_font_global',
			'_dlr_public_font',
			'_dlr_admin_font',
			'_dlr_display_header',
			'_dlr_display_footer',
			'_dlr_number_of_codes',
			'_dlr_forget_password',
			'_dlr_login_status',
			'_dlr_login_with_password_status',
			'_dlr_register_in_login_form',
			'_dlr_last_login',
			'_dlr_login_with_mobile',
			'_dlr_login_with_email',
			'_dlr_forget_password_email',
			'_dlr_register_status',
			'_dlr_password_field_in_register_status',
			'_dlr_name_field_in_register_status',
			'_dlr_family_field_in_register_status',
			'_dlr_email_field_in_register_status',
			'_dlr_password_rules_required',
			'_dlr_password_rules_ten_character',
			'_dlr_password_rules_one_letter',
			'_dlr_password_rules_one_specials',
			'_dlr_redirect_previous_page',
			'_dlr_redirect_url',
			'_dlr_redirect_logout',
			'_dlr_auto_confirm',
			'_dlr_login_force_all',
			'_dlr_admin_login_redirect',
			'_dlr_redirect_new_user_to_register_form',
			'_dlr_logo',
			'_dlr_favicon',
			'_dlr_background_image',
			'_dlr_description',
			'_dlr_color',
			'_dlr_color_tab',
			'_dlr_form_width',
			'_dlr_extra_style',
			'_dlr_dark_mode_status',
			'_dlr_design_type',
			'_dlr_button_image',
			'_dlr_sms_service',
			'_dlr_sms_melipayamak_username',
			'_dlr_sms_melipayamak_password',
			'_dlr_sms_melipayamak_theme',
			'_dlr_sms_smsir_secretKey',
			'_dlr_sms_ippanel_username',
			'_dlr_sms_ippanel_password',
			'_dlr_sms_ippanel_from',
			'_dlr_sms_ippanel_theme',
			'_dlr_sms_smsir_appKey',
			'_dlr_sms_smsir_theme',
			'_dlr_display_melipayamak_remain',
			'_dlr_display_ippanel_remain',
			'_dlr_display_smsir_remain',
			'_dlr_webservice_reports',
			'_dlr_sms_payamresan_accessKey',
			'_dlr_sms_payamresan_theme',
			'_dlr_support_digits',
			'_dlr_support_woocommerce',
			'_dlr_google_captcha_in_login_form',
			'_dlr_google_captcha_in_register_form',
			'_dlr_google_captcha_in_recovery_form',
			'_dlr_google_recaptchav2_site_key',
			'_dlr_redirect_my_account',
			'_dlr_redirect_checkout',
			'_dlr_save_mobile_in_woocommerce',
			'_dlr_save_name_in_woocommerce',
			'_dlr_save_family_in_woocommerce',
			'_dlr_checkout_notif',
			'_dlr_review_author',
			'_dlr_export_csv',
			'_dlr_webservice_reports',
			'_dlr_wrong_code_reports',
			'dlr_li3nce',
			'_dlr_customer_pending_sms_status',
			'_dlr_customer_pending_sms_body',
			'_dlr_customer_processing_sms_status',
			'_dlr_customer_processing_sms_body',
			'_dlr_customer_onhold_sms_status',
			'_dlr_customer_onhold_sms_body',
			'_dlr_customer_completed_sms_status',
			'_dlr_customer_completed_sms_body',
			'_dlr_customer_cancelled_sms_status',
			'_dlr_customer_cancelled_sms_body',
			'_dlr_customer_refunded_sms_status',
			'_dlr_customer_refunded_sms_body',
			'_dlr_customer_failed_sms_status',
			'_dlr_customer_failed_sms_body',
			'_dlr_customer_draft_sms_status',
			'_dlr_customer_draft_sms_body',
			'_dlr_display_return_back_btn',
			'_dlr_return_back_btn_text',
			'_dlr_support_sms_service',
			'_dlr_sms_smsir_sender',
			'_dlr_sms_melipayamak_sender',
			'_dlr_sms_payamresan_sender',
			'_dlr_sms_kavenegar_apikey',
			'_dlr_sms_kavenegar_theme',
			'_dlr_welcome_sms_status',
			'_dlr_welcome_sms_body'
		];

		$FileName = 'MobitsSettings.csv';
		$fp = fopen($FileName, 'w');

		foreach($options as $option) 
		{
			$value = get_option($option, '');
			$row = [
				'key' 	=> $option,
				'value' => $value
			];
			
			fputcsv($fp, $row);
		}

		fclose($fp);
		header("Location: $FileName");
	}

	private static function dlr_import_settings ()
	{
		$tmpName = $_FILES['_dlr_import_settings']['tmp_name'];
		$options = array_map('str_getcsv', file($tmpName));
		
		$count = 0;
		foreach( $options as $option ) 
		{
			update_option( $option[0], $option[1] );
			$count++;
		}
		$GLOBALS['dlr_imported_settings_count'] = $count;
	}

	private static function load_template()
	{
		$GLOBALS['dlr_options'] = parent::admin_options( self::$options );

		parent::template_loader('settings/header.php');
		parent::template_loader('settings/templates/import-export.php');
		parent::template_loader('settings/footer.php');
	}

	private static function dlr_quick_user_create()
	{
		$mobile 	= sanitize_text_field($_POST['dlr_mobile']);
		$name 		= sanitize_text_field($_POST['dlr_first_name']);
		$family 	= sanitize_text_field($_POST['dlr_last_name']);

		$options = parent::get_options(['_dlr_support_woocommerce', '_dlr_save_mobile_in_woocommerce', '_dlr_save_name_in_woocommerce']);

		$user_id = wp_insert_user([
			'user_login'	=> $mobile,
			'user_pass'  	=> wp_generate_password( 12, true ),
			'first_name'	=> $name,
			'last_name'	    => $family
		]);

		if( ! is_wp_error( $user_id ) ) 
		{
			$GLOBALS['dlr_quick_user_class'] 	= 'dlr_success_quick_user_creation';
			$GLOBALS['dlr_quick_user'] 			= __('The user created successfully.', 'dlr');
			
			// Woocommerce options
			if( isset($_POST['dlr_q_woocommerce']) && $options['_dlr_support_woocommerce'] == 1  ) 
			{
				// Save mobile in woocommerce
				if( $options['_dlr_save_mobile_in_woocommerce'] == 1 )
				{
					update_user_meta( $user_id, 'billing_phone', $mobile );
					update_user_meta( $user_id, 'shipping_phone', $mobile );
				}
				
				// Save name in woocommerce
				if( $options['_dlr_save_name_in_woocommerce'] == 1 )
				{
					update_user_meta( $user_id, 'billing_first_name', $name );
					update_user_meta( $user_id, 'shipping_first_name', $name );
				}

				// Save family in woocommerce
				if( $options['_dlr_save_family_in_woocommerce'] == 1 )
				{
					update_user_meta( $user_id, 'billing_last_name', $family );
					update_user_meta( $user_id, 'shipping_last_name', $family );
				}
			}
			
			// Save mobile as metadata
			update_user_meta( $user_id, 'mobits_mobile_number', '+98'.$mobile );
		}
		else 
		{
			$GLOBALS['dlr_quick_user_class'] 	= 'dlr_failed_quick_user_creation';
			$GLOBALS['dlr_quick_user'] 			= $user_id->get_error_message();
		}
			
	}

	private static function import_csv()
	{
		$tmpName = $_FILES['_dlr_import_csv']['tmp_name'];
		$users = array_map('str_getcsv', file($tmpName));
		
		$count = 0;
		foreach( $users as $user ) 
		{
			$mobile = substr($user[0], 0, 1) == '0' ? $user[0] : '0'.$user[0];

			if( username_exists( $mobile ) ) continue;

			$userdata = array(
    			'user_login' 		=>  $mobile,
    			'user_pass'			=>  wp_generate_password( 8, true),
    			'first_name'		=>  $user[1]
    		);

			$userId = wp_insert_user( $userdata );

			if( get_option('_dlr_support_woocommerce', 0) == 1  ) 
			{
				if( get_option('_dlr_save_mobile_in_woocommerce', 0) == 1 )
				{
					update_user_meta( $userId, 'billing_phone', $mobile );
					update_user_meta( $userId, 'shipping_phone', $mobile );
				}
				
				if( get_option('_dlr_save_name_in_woocommerce', 0) == 1 && $user[1] != '' )
				{
					update_user_meta( $userId, 'billing_first_name', $user[1] );
					update_user_meta( $userId, 'shipping_first_name', $user[1] );
				}
			}
			
			update_user_meta( $userId, 'mobits_mobile_number', '+98'.$mobile );

			$count++;
		}

		$GLOBALS['dlr_imported_count'] = $count;
	}
}

new Dlr_Settings_Import_Export();