<?php 

defined( 'ABSPATH' ) || exit;

class Dlr_Settings_Login extends Dlr_Settings
{
	private static $options = [
		'_dlr_forget_password',
		'_dlr_login_status',
		'_dlr_login_with_password_status',
		'_dlr_register_in_login_form',
		'_dlr_last_login',
		'_dlr_login_with_mobile',
		'_dlr_login_with_email',
		'_dlr_forget_password_email',
		'_dlr_login_priority'
	];

	public function __construct()
	{
		self::controller();
		self::load_template();
	}

	private static function controller()
	{
		if ( isset( $_POST['dlr_submit'] ) ) parent::save_settings( self::$options );

		if( isset( $_POST['dlr_submit'] ) && ! isset( $_POST['_dlr_login_with_password_status'] ) )
			update_option( '_dlr_login_with_email', 0 );
	}

	private static function load_template()
	{
		$GLOBALS['dlr_options'] = parent::admin_options( self::$options );

		parent::template_loader('settings/header.php');
		parent::template_loader('settings/templates/login.php');
		parent::template_loader('settings/footer.php');
	}
}

new Dlr_Settings_Login();