<?php 

defined( 'ABSPATH' ) || exit;

class Dlr_Settings_Redirect extends Dlr_Settings
{
	private static $options = [
		'_dlr_redirect_previous_page',
		'_dlr_redirect_url',
		'_dlr_redirect_logout',
		'_dlr_auto_confirm',
		'_dlr_login_force_all',
		'_dlr_admin_login_redirect',
		'_dlr_redirect_new_user_to_register_form',
		'_dlr_redirect_by_role_role',
		'_dlr_redirect_by_role_address',
		'_dlr_display_return_back_btn',
		'_dlr_return_back_btn_text'
	];

	public function __construct()
	{
		self::controller();
		self::load_template();
	}

	private static function controller()
	{
		if ( isset( $_POST['dlr_submit'] ) ) parent::save_settings( self::$options );
	}

	private static function get_avilable_roles($status) 
	{
		global $wp_roles;
		$all_roles = $wp_roles->roles;
		
		$options = '';

		$option = $status == 1 ? '_limit_panel_access_by_role' : '_limit_admin_bar_by_role';
		$selecteds = get_option($option, []);
		$selecteds = $selecteds == '' ? [] : $selecteds;

		foreach( $all_roles as $role )
		{
			if ( $role["name"] != 'Administrator' ) 
			{
				$selected = in_array( strtolower($role["name"]), $selecteds ) ? 'selected="selected"' : '';
				$options .= '<option '.$selected.' value="'.strtolower($role["name"]).'">'.translate_user_role($role["name"]).'</option>';
			}
				
		}

		return $options;
	}

	private static function load_template()
	{
		$GLOBALS['dlr_options'] = parent::admin_options( self::$options );
		$GLOBALS['redirect_roles_method'] = self::redirect_roles();
		$GLOBALS['dlr_roles'] 	= self::get_avilable_roles(1);
		$GLOBALS['dlr_roles2'] 	= self::get_avilable_roles(2);

		parent::template_loader('settings/header.php');
		parent::template_loader('settings/templates/redirect.php');
		parent::template_loader('settings/footer.php');
	}

	private static function redirect_roles()
	{
		$roles = get_option('_dlr_redirect_by_role_role');
		$addresses = get_option('_dlr_redirect_by_role_address');

		$final = '';
		foreach( $roles as $key=>$role ) 
		{
			$final .= '<div class="dlr_oh">';
				$final .= '<select name="_dlr_redirect_by_role_role[]" class="redirect_by_role_role">';
					$final .= self::redirect_role_options($role);
				$final .= '</select>';
				$final .= '<input class="regular-text" name="_dlr_redirect_by_role_address[]" placeholder="آدرس ..." value="'.$addresses[$key].'" class="redirect_by_role_address" type="text" />';
				$final .= '<span class="dlr_close_redirect">*</span>';
			$final .= '</div>';
		}

		return $final;
	}

	private static function redirect_role_options($rolee)
	{
		global $wp_roles;
		$output = '';
		foreach( $wp_roles->roles as $key=>$role ) 
		{
			if ( $role["name"] != 'Administrator' ) 
			{
				$selected = ( $rolee == $key ) ? 'selected="selected"' : '';
				$output .= '<option '.$selected.' value="'.$key.'">'.translate_user_role($role["name"]).'</option>';
			}
			
		}
		return $output;
	}
}

new Dlr_Settings_Redirect();