<?php 

defined( 'ABSPATH' ) || exit;

class Dlr_Settings_Register extends Dlr_Settings
{
	private static $options;

	public function __construct()
	{
		if ( !isset( $_GET['section'] ) || $_GET['section'] == 'general' ) 
		{
			self::$options = [
				'_dlr_register_status',
				'_dlr_password_field_in_register_status',
				'_dlr_name_field_in_register_status',
				'_dlr_family_field_in_register_status',
				'_dlr_email_field_in_register_status',
				'_dlr_email_field_required_in_register',
				'_dlr_password_rules_required',
				'_dlr_password_rules_ten_character',
				'_dlr_password_rules_one_letter',
				'_dlr_password_rules_one_specials',
			];
		}
		else if ( $_GET['section'] == 'welcome-sms' ) 
		{
			self::$options = [
				'_dlr_welcome_sms_status',
				'_dlr_welcome_sms_body',
				'_dlr_welcome_sms_type',
				'_dlr_welcome_sms_template_code',
				'_dlr_welcome_sms_template_variables',
				'_dlr_welcome_sms_template_name_replace'
			];
		}

		self::controller();
		self::load_template();
	}

	private static function controller()
	{
		if ( isset( $_POST['dlr_submit'] ) ) parent::save_settings( self::$options );
	}

	private static function load_template()
	{
		$GLOBALS['dlr_options'] = parent::admin_options( self::$options );

		parent::template_loader('settings/header.php');
		parent::template_loader('settings/templates/register.php');
		parent::template_loader('settings/footer.php');
	}
}

new Dlr_Settings_Register();