<?php 

defined( 'ABSPATH' ) || exit;

class Dlr_Settings_Reports extends Dlr_Settings
{
	private static $options = [
		'_dlr_webservice_reports',
		'_dlr_wrong_code_reports',
		'dlr_delete_sendsms_report',
		'dlr_delete_wrongcodes_report'
	];
	private static $pages;
	private static $wrong_codes_table;
	private static $pagenum;
	private static $total;
	private static $send_sms_table;
	private static $offset;

	public function __construct()
	{
		self::$send_sms_table = parent::$wpdb->prefix . 'dlr_send_sms';
		self::$wrong_codes_table = parent::$wpdb->prefix . 'dlr_wrong_codes';

		self::controller();
		self::load_template();
	}

	private static function controller()
	{
		if ( isset($_GET['section']) && $_GET['section'] == 'blockedmobiles' && isset($_GET['action']) && $_GET['action'] == 'delete') 
		{
			self::delete_blocked_mobile_number();
		}

		if ( !isset($_GET['section']) || $_GET['section'] == 'settings' ) 
		{
			if ( isset( $_POST['dlr_submit'] ) ) parent::save_settings( self::$options );
			$GLOBALS['dlr_options'] = parent::admin_options( self::$options );
		}

		if ( isset( $_POST["dlr_truncate_reports"] ) ) self::truncate_reports();

		if ( isset($_GET['section']) && $_GET['section'] == 'sendsms' ) 
		{
			$GLOBALS['dlr_reports'] = self::get_reports();
		}

		if ( isset( $_POST["dlr_truncate_wrongcodes"] ) ) self::truncate_wrongcode();

		if ( isset($_GET['section']) && $_GET['section'] == 'wrongcodes' ) 
		{
			$GLOBALS['dlr_wrong_codes'] = self::get_wrongcodes();
		}

		if ( isset( $_POST["dlr_add_block"] ) ) self::dlr_add_block();

		if ( isset($_GET['section']) && $_GET['section'] == 'blockedmobiles' ) 
		{
			$GLOBALS['dlr_blocked_mobile_number'] = self::get_blocked_mobile_number();
		}
	}

	private static function delete_blocked_mobile_number()
	{
		parent::$wpdb->delete(
			parent::$wpdb->prefix . 'dlr_blocked_mobile_numbers',
			[
				'id' => $_GET['id']
			]
		);
	}

	private static function dlr_add_block()
	{
		$name 	= sanitize_text_field($_POST['block_user_name']);
		$family = sanitize_text_field($_POST['block_user_family']);
		$mobile = sanitize_text_field($_POST['block_user_mobile']);

		$table 	= parent::$wpdb->prefix . 'dlr_blocked_mobile_numbers';
		$user 	= parent::$wpdb->get_row("select * from $table where mobile='$mobile'");

		if( $user ) {
			$GLOBALS['is_blicked_mobile_exists'] = true;
		}
		else {
			$GLOBALS['is_blicked_mobile_exists'] = false;
			parent::$wpdb->insert(
				$table,
				[
					'name' 		=> $name,
					'family'	=> $family,
					'mobile'	=> $mobile
				]
			);
		}
		
	}

	private static function get_blocked_mobile_number()
	{
		self::$pagenum = isset($_GET['pagenum']) ? $_GET['pagenum'] : 1;
		$limit 	= 20;
		self::$offset = ( self::$pagenum - 1 ) * $limit;
		$offset = self::$offset;
		$table = parent::$wpdb->prefix . 'dlr_blocked_mobile_numbers';

		$total = parent::$wpdb->get_results("select count(id) as count from $table");

		self::$total = $total[0]->count;
		self::$pages = ceil( self::$total / $limit );

		$items = parent::$wpdb->get_results("select * from $table order by id desc limit $offset, $limit");

		$blocks = [];
		foreach( $items as $item ) 
		{
			$blocks[] = [
				'id' 		=> $item->id,
				'number' 	=> self::$offset+=1,
				'name' 		=> $item->name,
				'family'   	=> $item->family,
				'mobile'   	=> $item->mobile
			];
		}

		// set new pagination
		$GLOBALS['dlr_reports_pagination'] = self::get_pagination();

		return $blocks;
	}

	private static function load_template()
	{
		parent::template_loader('settings/header.php');
		parent::template_loader('settings/templates/reports.php');
		parent::template_loader('settings/footer.php');
	}

	private static function return_sql($table)
	{
		self::$pagenum = isset($_GET['pagenum']) ? $_GET['pagenum'] : 1;
		$limit 	= 20;
		self::$offset = ( self::$pagenum - 1 ) * $limit;
		$offset = self::$offset;

		$sql = "select * from $table ";
		$total_sql = "select count(id) from $table ";
		$and = 0;

		if ( isset( $_GET['date']) && $_GET['date'] == 'today' ) 
		{
			$sql .= "where DATE(`time`) = CURDATE()";
			$total_sql .= "where DATE(`time`) = CURDATE()";
			$and = 1;
		}
		else if ( isset( $_GET['date']) && $_GET['date'] == 'yesterday' ) 
		{
			$where = "where DATE(`time`) = DATE_SUB(CURDATE(), INTERVAL 1 DAY)";
			$sql .= $where;
			$total_sql .= $where;
			$and = 1;
		}
		else if ( isset( $_GET['date']) && $_GET['date'] == 'week' ) 
		{
			$where = "where DATE_SUB(CURDATE(),INTERVAL 7 DAY) <= DATE(`time`)";
			$sql .= $where;
			$total_sql .= $where;
			$and = 1;
		}
		else if ( isset( $_GET['date']) && $_GET['date'] == 'month' ) 
		{
			$where = "where DATE_SUB(CURDATE(),INTERVAL 30 DAY) <= DATE(`time`)";
			$sql .= $where;
			$total_sql .= $where;
			$and = 1;
		}

		if( isset( $_GET['status']) && $_GET['status'] == 1 ) 
		{
			if ( $and == 1 ) {
				$sql .= ' and '; 
			}
			else {
				$sql .= ' where ';
			}

			$sql .= " status=1 ";
			$total_sql .= " and status=1";
		}

		else if( isset( $_GET['status']) && $_GET['status'] == 0 ) 
		{
			if ( $and == 1 ) {
				$sql .= ' and '; 
			}
			else {
				$sql .= ' where ';
			}

			$sql .= " status=0 ";
			$total_sql .= " and status=0 ";
		}

		self::$total = parent::$wpdb->get_var($total_sql);
		$sql .= "order by id desc limit $offset, $limit";
			
		self::$pages = ceil( self::$total / $limit );

		return $sql;
	}

	private static function get_today_reports_count ()
	{
		$table 	= self::$send_sms_table;
		$sql 	= "select * from $table where DATE(`time`) = CURDATE()";

		$results = parent::$wpdb->get_results($sql);
		$ok = 0;
		$nok = 0;

		foreach( $results as $item ) {
			if( $item->status == 1 ) $ok++;
			else $nok++;
		}

		return [
			'total'	=> count($results),
			'ok'	=> $ok,
			'nok'	=> $nok
		];
	}

	private static function get_reports ()
	{
		$sql = self::return_sql(self::$send_sms_table);
			
		// Get reports
		$items = parent::$wpdb->get_results($sql);

		$reports = [];
		foreach( $items as $item ) 
		{
			$reports[] = [
				'number' 	 => self::$offset+=1,
				'webservice' => self::webservice_name( $item->webservice ),
				'template'   => $item->template,
				'receiver'   => self::user_login( $item->receiver ),
				'time'   	 => self::time_to_persian( $item->time ),
				'status'     => self::send_status($item->status),
				'result'	 => $item->result
			];
		}

		// set new pagination
		$GLOBALS['dlr_reports_pagination'] = self::get_pagination();

		return [
			'reports'   => $reports,
			'total'		=> self::$total,
			'today'		=> self::get_today_reports_count()
		];
	}

	private static function get_today_wrong_codes_count ()
	{
		$table 	= self::$wrong_codes_table;
		$sql 	= "select count(id) as count from $table where DATE(`time`) = CURDATE()";

		$results = parent::$wpdb->get_row($sql);
		return $results->count;
	}

	private static function get_most_user_wrong_codes_count ()
	{
		$table 	= self::$wrong_codes_table;
		$sql 	= "select *, count(id) as count from $table group by receiver order by count desc";

		$results = parent::$wpdb->get_results($sql);
		return isset($results[0]) ? $results[0]->receiver : false;
	}

	private static function get_wrongcodes ()
	{
		$sql = self::return_sql(self::$wrong_codes_table);

		// Get reports
		$items = parent::$wpdb->get_results($sql);

		$wrong_codes = [];
		foreach( $items as $item ) 
		{
			$wrong_codes[] = [
				'number' 	 => self::$offset+=1,
				'webservice' => self::webservice_name( $item->webservice ),
				'template'   => $item->template,
				'receiver'   => self::user_login( $item->receiver ),
				'time'   	 => self::time_to_persian( $item->time )
			];
		}

		// Delete last pagination
		delete_transient( 'dlr_wrong_codes_pagination' );

		// set new pagination
		$GLOBALS['dlr_wrong_codes_pagination'] = self::get_pagination();

		return [
			'wrong_codes'   => $wrong_codes,
			'total'			=> self::$total,
			'today'			=> self::get_today_wrong_codes_count(),
			'user'			=> self::get_most_user_wrong_codes_count()
		];
	}

	private static function get_pagination ()
	{
		$page_links = paginate_links( array(
			'base' 		=> add_query_arg( 'pagenum', '%#%' ),
			'format'	=> '',
			'prev_text' => __( '<', 'text-domain' ),
			'next_text' => __( '>', 'text-domain' ),
			'total' 	=> self::$pages,
			'current' 	=> self::$pagenum
		) );

		return $page_links ? '<div class="dlr_reports_pagination"><span>'.self::$total.' نتیجه </span><div class="tablenav-pages">' . $page_links . '</div></div>' : ''; 
	}

	private static function send_status($status)
	{
		if( $status )
			return '<span class="dlr_report_sended">✓ '. __("Sended", "dlr") . '</span>';

		return  '<span class="dlr_report_notsended"><span>X</span> '. __("Not sended", "dlr") . '</span>';
	}

	private static function webservice_name ($webservice)
	{
		switch( $webservice )
		{
			case 'ippanel':
				return __('Ippanel', 'dlr');
				break;
			case 'melipayamak':
				return __('melipayamak', 'dlr');
				break;
			case 'smsir':
				return __('Sms.ir', 'dlr');
				break;
			case 'payamresan':
				return __('payamresan', 'dlr');
				break;
			case 'kavenegar':
				return __('kavenegar', 'dlr');
				break;
			case 'farapayamak':
				return __('farapayamak', 'dlr');
				break;
			case 'payamito':
				return __('payamito (payamito.com)', 'dlr');
				break;
		}
	}

	private static function user_login ( $receiver )
	{
		$user = get_user_by('login', $receiver);

		if ( ! $user ) return $receiver . ' ('.__("Guest", "dlr").')';

		$roles = $user->roles;
		$role = isset($roles[0]) ? translate_user_role( wp_roles()->get_names()[$roles[0]] ) : __("Subscriber", "dlr");
		return '<a class="dlr_report_user" target="_blank" href="'.admin_url().'user-edit.php?user_id='.$user->ID.'">' .$receiver. ' ('.$role. ') </a>';
	}

	private static function time_to_persian($time)
	{
		if ( !function_exists('jdate1') ) {
			require_once dirname(__FILE__) . '/libs/jdf.php';
		}
		
		$time1 = explode(" ", $time);

		return jdate1('d F Y ساعت ', strtotime($time), 'GMT') . ' ' . $time1[1];
	}

	private static function truncate_reports()
	{
		$table = self::$send_sms_table;
		parent::$wpdb->query( "TRUNCATE TABLE $table" );
		delete_transient( 'dlr_reports' );
		delete_transient( 'dlr_reports_pagination' );
	}

	private static function truncate_wrongcode()
	{
		$table = self::$wrong_codes_table;
		parent::$wpdb->query( "TRUNCATE TABLE $table" );
	}
}

new Dlr_Settings_Reports();