<?php 

defined( 'ABSPATH' ) || exit;

class Dlr_Settings_Roadmap extends Dlr_Settings
{
	private static $options = [];

	public function __construct()
	{
		self::controller();
		self::load_template();
	}

	private static function controller()
	{
		if ( isset( $_POST['dlr_send_feedback'] ) ) self::dlr_send_feedback();
	}

	private static function load_template()
	{
		parent::template_loader('settings/header.php');
		parent::template_loader('settings/templates/roadmap.php');
		parent::template_loader('settings/footer.php');
	}

	public static function dlr_send_feedback()
	{
		$to = 'mobits.ir@gmail.com';
		$reply_to = $_POST['dlr_feedback_reply_email'];
		$subject = __('Mobits feedback' , 'dlr');
		$body = nl2br($_POST['dlr_feedback_body']);
		$headers = array(
			'Content-Type: text/html; charset=UTF-8',
			'Reply-To: '.$reply_to
		);

		$send = wp_mail( $to, $subject, $body, $headers );

		if ($send) 
			set_transient( 'dlr_feedback_success', __('<div class="dlr_feedback_success">Feedback send successfully</div>' , 'dlr'), 50);
		else
			set_transient( 'dlr_feedback_success', __('<div class="dlr_feedback_error">feedback is not send</div>' ,'dlr'), 50);
	}
}

new Dlr_Settings_Roadmap();