<?php 

defined( 'ABSPATH' ) || exit;

class Dlr_Settings_Sms extends Dlr_Settings
{
	private static $options = [
		'_dlr_sms_service',
		'_dlr_sms_melipayamak_username',
		'_dlr_sms_melipayamak_password',
		'_dlr_sms_melipayamak_theme',
		'_dlr_sms_smsir_secretKey',
		'_dlr_sms_ippanel_username',
		'_dlr_sms_ippanel_password',
		'_dlr_sms_ippanel_from',
		'_dlr_sms_ippanel_theme',
		'_dlr_sms_smsir_appKey',
		'_dlr_sms_smsir_theme',
		'_dlr_display_melipayamak_remain',
		'_dlr_display_ippanel_remain',
		'_dlr_display_smsir_remain',
		'_dlr_sms_payamresan_accessKey',
		'_dlr_sms_payamresan_theme',
		'_dlr_support_sms_service',
		'_dlr_sms_smsir_sender',
		'_dlr_sms_melipayamak_sender',
		'_dlr_sms_payamresan_sender',
		'_dlr_sms_kavenegar_apikey',
		'_dlr_sms_kavenegar_theme',
		'_dlr_display_farapayamak_remain',
		'_dlr_sms_farapayamak_username',
		'_dlr_sms_farapayamak_password',
		'_dlr_sms_farapayamak_sender',
		'_dlr_sms_farapayamak_theme',
		'dlr_farapayamak_test_mobile',
		'_dlr_display_payamito_remain',
		'_dlr_sms_payamito_username',
		'_dlr_sms_payamito_password',
		'_dlr_sms_payamito_sender',
		'_dlr_sms_payamito_theme',
		'dlr_payamito_test_mobile'
	];

	public function __construct()
	{
		self::controller();
		self::load_template();
	}

	private static function controller()
	{
		if ( isset( $_POST['dlr_submit'] ) ) parent::save_settings( self::$options );
	}

	private static function load_template()
	{
	    $options = parent::admin_options( self::$options );
		$GLOBALS['dlr_options'] = $options;

		if ( $options['_dlr_display_melipayamak_remain'] == 1 ) self::dlr_melipayamak_current_ballance();

		if ( $options['_dlr_display_ippanel_remain'] == 1 ) self::dlr_ippanel_current_ballance();
		
		if ( $options['_dlr_display_smsir_remain'] == 1 ) self::dlr_smsir_current_ballance();

		if ( $options['_dlr_display_farapayamak_remain'] == 1 ) self::dlr_farapayamak_current_ballance();

		if ( $options['_dlr_display_payamito_remain'] == 1 ) self::dlr_payamito_current_ballance();

		parent::template_loader('settings/header.php');
		parent::template_loader('settings/templates/sms.php');
		parent::template_loader('settings/footer.php');
	}

	private static function dlr_melipayamak_current_ballance ()
	{
    	$data = array(
			'username' => get_option( '_dlr_sms_melipayamak_username'), 
			'password' => get_option( '_dlr_sms_melipayamak_password')
		);

		$post_data = http_build_query($data);
		$handle = curl_init('https://rest.payamak-panel.com/api/SendSMS/GetCredit');
		curl_setopt($handle, CURLOPT_HTTPHEADER, array(
			'content-type' => 'application/x-www-form-urlencoded'
		));
		curl_setopt($handle, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($handle, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($handle, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($handle, CURLOPT_POST, true);
		curl_setopt($handle, CURLOPT_POSTFIELDS, $post_data);
		$response = json_decode( curl_exec($handle) );

		set_transient( 'melipayamak_ballance', number_format( ceil( (float) $response->Value ) ) .' '. __('Text message', 'dlr'), 60*5 );
	}

	private static function dlr_farapayamak_current_ballance ()
	{
    	ini_set("soap.wsdl_cache_enabled", "0");
		$sms_client = new SoapClient('http://api.payamak-panel.com/post/Send.asmx?wsdl', array('encoding'=>'UTF-8'));

		$parameters['username'] = get_option( '_dlr_sms_farapayamak_username' );
		$parameters['password'] = get_option( '_dlr_sms_farapayamak_password' );

		$value = $sms_client->GetCredit($parameters)->GetCreditResult;

		$GLOBALS['farapayamak_ballance'] = number_format( ceil( (float) $value ) ) .' '. __('Text message', 'dlr');
	}

	private static function dlr_payamito_current_ballance ()
	{
    	ini_set("soap.wsdl_cache_enabled", "0");
		$sms_client = new SoapClient('http://api.payamak-panel.com/post/Send.asmx?wsdl', array('encoding'=>'UTF-8'));

		$parameters['username'] = get_option( '_dlr_sms_payamito_username' );
		$parameters['password'] = get_option( '_dlr_sms_payamito_password' );

		$value = $sms_client->GetCredit($parameters)->GetCreditResult;

		$GLOBALS['payamito_ballance'] = number_format( ceil( (float) $value ) ) .' '. __('Text message', 'dlr');
	}

	private static function dlr_ippanel_current_ballance ()
	{
		$param = array ( 
			'uname'		=> get_option( '_dlr_sms_ippanel_username' ),
			'pass'		=> get_option( '_dlr_sms_ippanel_password' ),
			'op'		=> 'credit'
		);
		$url = "https://ippanel.com/services.jspd";
 
        $handler = curl_init($url);             
        curl_setopt($handler, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($handler, CURLOPT_POSTFIELDS, $param);                       
        curl_setopt($handler, CURLOPT_RETURNTRANSFER, true);
        $response2 = curl_exec($handler);
 
        $response2 = json_decode($response2);
        $res_code = $response2[0];
        $res_data = $response2[1];
 
		set_transient( 'ippanel_ballance', number_format( ceil( (float) $res_data ) ), 60*5 );
	}
	
	private static function dlr_smsir_current_ballance ()
	{
		$curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL             => 'https://api.sms.ir/v1/credit',
            CURLOPT_RETURNTRANSFER  => true,
            CURLOPT_ENCODING        => '',
            CURLOPT_MAXREDIRS       => 10,
            CURLOPT_TIMEOUT         => 0,
            CURLOPT_FOLLOWLOCATION  => true,
            CURLOPT_HTTP_VERSION    => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST   => 'GET',
            CURLOPT_HTTPHEADER      => array(
                'X-API-KEY: '.get_option("_dlr_sms_smsir_secretKey")
            ),
        ));
        
        $response = json_decode(curl_exec($curl));
        
        curl_close($curl);

		$ballance = $response == null ? __('Dont recieve','dlr') : number_format( ceil( (float) $response->data) ) . ' ' . __("Sms text", "dlr");
		set_transient( 'smsir_ballance', $ballance, 60*5 );
	}
}

new Dlr_Settings_Sms();