<?php 

defined( 'ABSPATH' ) || exit;

class Dlr_Settings_Woocommerce extends Dlr_Settings
{
	private static $options;

	public function __construct()
	{

		if ( !isset( $_GET['section'] ) || $_GET['section'] == 'general' ) 
		{
			self::$options = [
				'_dlr_redirect_my_account',
				'_dlr_redirect_checkout',
				'_dlr_save_mobile_in_woocommerce',
				'_dlr_save_name_in_woocommerce',
				'_dlr_save_family_in_woocommerce',
				'_dlr_checkout_notif',
				'_dlr_review_author',
				'_dlr_checkout_billing_email_optional'
			];
		}
		else if ( $_GET['section'] == 'customer-sms' ) 
		{
			self::$options = [
				'_dlr_woocommerce_webservice',
			];

			foreach ( WOO_STATUSES as $key=>$status ) 
			{
				self::$options[] = '_dlr_customer_'.$key.'_sms_status';
				self::$options[] = '_dlr_customer_'.$key.'_sms_body';
				self::$options[] = '_dlr_'.$key.'_template_code';
				self::$options[] = '_dlr_'.$key.'_sms_type';
				self::$options[] = '_dlr_'.$key.'_template_variables';
			}
		}

		else if ( $_GET['section'] == 'admin-sms' ) 
		{
			self::$options = [
				'_dlr_woocommerce_admin_webservice',
				'_dlr_admin_order_send_sms'
			];

			foreach ( WOO_STATUSES as $key=>$status ) 
			{
				self::$options[] = '_dlr_admin_'.$key.'_sms_status';
				self::$options[] = '_dlr_admin_'.$key.'_sms_body';
				self::$options[] = '_dlr_admin_'.$key.'_template_code';
				self::$options[] = '_dlr_admin_'.$key.'_sms_type';
				self::$options[] = '_dlr_admin_'.$key.'_template_variables';
				self::$options[] = '_dlr_admin_'.$key.'_managers';
			}
		}

		self::controller();
		self::load_template();
	}

	private static function controller()
	{
		if ( isset( $_POST['dlr_submit'] ) ) parent::save_settings( self::$options );

		if ( isset( $_GET['section'] ) && $_GET['section'] == 'admin-sms' )
			$GLOBALS['dlr_woo_admins'] = self::dlr_woo_admins();
	}

	private static function load_template()
	{
		$GLOBALS['dlr_options'] = parent::admin_options( self::$options );

		parent::template_loader('settings/header.php');
		parent::template_loader('settings/templates/woocommerce.php');
		parent::template_loader('settings/footer.php');
	}

	private static function dlr_woo_admins ()
	{
		$users = get_users( [ 'role__in' => [ 'administrator', 'shop_manager' ] ] );
		
		$admins = [];

		foreach ( WOO_STATUSES as $key=>$status ) 
		{
			$selecteds = get_option('_dlr_admin_'.$key.'_managers', []);
			if ( $selecteds == '' ) $selecteds = [];

			$output = '';
			foreach ( $users as $user )
			{
				if ( ! self::dlr_check_validation($user->user_login) ) continue;

				$u = get_user_by('id', $user->ID);

				$selected = in_array( $user->user_login, $selecteds ) ? 'selected="selected"' : '';

				$output .= '<option '.$selected.' value="'.$user->user_login.'">'.$user->user_login;
					if ( $u->first_name != '' ) $output .= ' - '.$u->first_name . ' ' . $u->last_name;
				$output .= '</option>';
			}

			$admins[$key] = $output;
		}

		return $admins;
	}

	protected static function dlr_check_validation($mobile)
	{
		$check_mobile = preg_match("/^09[0-9]{9}$/", $mobile);
		
		return $check_mobile;
	}
}

new Dlr_Settings_Woocommerce();