<?php 
if ( get_option('mobits10', true) ): ?>
<div class="dlr_mobits_new_version" style="background: url(<?php echo DLR_BASE_URL . 'admin/images/new_mobits_version2.jpg'; ?>)">
	<h1><?php echo __('Welcome to mobits', 'dlr'); ?></h1>
	<p><a target="_blank" href="https://biawp.ir/mobits10"><?php echo __('Learn more about version ', 'dlr'); ?> <span>></span></a></p>
	<span class="dlr_mobits_new_version_close"> <span>X</span> <?php echo __('Close', 'dlr'); ?></span>
</div>
<?php endif; update_option('mobits10', 0); ?>

<div class="wrap dlr_setting">

	<h1><?php echo __('Mobits', 'dlr'); ?>
	<bdi class="version" onclick="window.open('https://biawp.ir/mobits10', '_blank')">V<?php echo DLR_VERSION; ?></bdi>
	<label class="dlr_light_dark">
		<input type="checkbox" id="dlr_change_dark_light">
		<span class="slider round"></span>
	</label>
    	<span>
		<?php echo __('Designed with', 'dlr'); ?> <span class="dashicons dashicons-heart"></span> <?php echo __('By', 'dlr'); ?> 
    	<a target="_blank" href="https://biawp.ir"><?php echo __('Biawp.ir', 'dlr'); ?></a>
    	<br>
    	</span>

		<p class="dlr_gift">
		<?php echo __('If you have seen an error in Mobits, download the latest version from the site. If the error is not fixed, report it to us.', 'dlr'); ?>
		  <a href="tel:09371425379">09371425379</a> (8 تا 14 و 17 تا 22) </p>
	</h1>
	<?php
	
	$tabs = array( 
	    'general'    	=> __('General', 'dlr'),
		'login'    		=> __('Login', 'dlr'), 
		'register'    	=> __('Register', 'dlr'), 
		'redirect'    	=> __('Redirect', 'dlr'), 
	    'design'        => __('Design', 'dlr'),
	    'sms'           => __('Webservice', 'dlr'),
		'others'  		=> __('Other plugins', 'dlr'),
	    'captcha'       => __('Google Captcha', 'dlr')
	);
	
	if( get_option('_dlr_support_woocommerce', 0) == 1 )
	    $tabs['woocommerce'] = __('Woocommerce', 'dlr');
	
	$tabs['import-export'] 	= __('Import/Export', 'dlr');

	$tabs['reports'] = __('Reports', 'dlr');

	$tabs['roadmap'] 		= __('Roadmap', 'dlr');

	echo '<form method="post" enctype="multipart/form-data" action="" id="dlr_setting_wrapper">';
	
    echo '<nav class="nav-tab-wrapper">';
    foreach( $tabs as $tab => $name ){
        $class = ( isset($_GET['dlr_tab']) && $tab == $_GET['dlr_tab'] ) || ( !isset($_GET['dlr_tab']) && $tab=='general' ) ? ' nav-tab-active' : '';
        echo "<a class='nav-tab $class nav-tab' href='?page=dlr-settings&dlr_tab=$tab'>$name</a>";
    }
	?>
	
    </nav>

	<?php 
	if ( defined('DISABLE_WP_CRON') && DISABLE_WP_CRON == true ) 
	{
		echo '<div class="dlr_cron_disabled">'. __("Warning: Your site's cron is disabled. This makes features such as WooCommerce SMS, welcome SMS, timing of automatic removal of verification codes, etc. unavailable.", 'dlr') .' <a target="_blank" href="https://biawp.ir/enable-wp-cron-in-wp-to-send-woocommerce-sms">'.__('How to activate Cron', 'dlr').'</a></div>';
	}
	?>

	<div class="dlr_table">

	<div class="sideShape">
		<div class="sideShapeElement">
			<div class="sideShapeItem1"></div>
			<div class="sideShapeItem2"></div>
		</div>
	</div>
	
	<?php $page = isset($_GET['dlr_tab']) ? $_GET['dlr_tab'] : 'general'; ?>

    <table class="form-table <?php echo $page; ?>">
        
        <tbody>