<?php $options = $GLOBALS['dlr_options']; ?>

<tr>
    <th>
        <?php echo __('Use Mobits font for the whole panel', 'dlr'); ?>
    </th>
    
    <td>
		<label class="switch">
			<input name="_dlr_font_global" id="_dlr_font_global" type="checkbox" <?php checked( esc_attr($options['_dlr_font_global']), 1); ?> value="1">
			<span class="slider round"></span>
		</label>
        <p><?php echo __('With this option enabled, the font used in Mobits is applied to the entire panel. <strong>Note:</strong> To apply the font, it is necessary to refresh the page once after saving the settings.', 'dlr'); ?> </p>
    </td>
</tr>

<tr>
	<th class="dlr_field_base"><?php echo __('Public font', 'dlr'); ?></th>

	<td>
		<fieldset>
			<select id="dlr_public_font" name="_dlr_public_font">
				<option value="iranyekan" <?php selected( esc_attr($options['_dlr_public_font']) , 'iranyekan' ); ?>><?php echo __('Iran yekan', 'dlr'); ?></option>
				<option value="iransans" <?php selected( esc_attr($options['_dlr_public_font']) , 'iransans' ); ?>><?php echo __('Iran sans', 'dlr'); ?></option>
			</select>
		</fieldset>
		<p><?php echo __('Iran sans font is a commercial font. If you have a commercial site such as a store, you need to purchase its license for your site (fontiran.com). It should be noted that you are responsible for using this font without a license.', 'dlr'); ?> </p>
	</td>
</tr>

<tr>
	<th class="dlr_field_base"><?php echo __('Admin font', 'dlr'); ?></th>

	<td>
		<fieldset>
			<select id="dlr_admin_font" name="_dlr_admin_font">
				<option value="iranyekan" <?php selected( esc_attr($options['_dlr_admin_font']) , 'iranyekan' ); ?>><?php echo __('Iran yekan', 'dlr'); ?></option>
				<option value="iransans" <?php selected( esc_attr($options['_dlr_admin_font']) , 'iransans' ); ?>><?php echo __('Iran sans', 'dlr'); ?></option>
			</select>
		</fieldset>
		<p><?php echo __('The font determines the management panel of mobits. <strong>Note:</strong> To apply the font, it is necessary to refresh the page once after saving the settings.', 'dlr'); ?> </p>
	</td>
</tr>

<script>
jQuery(document).ready(function($){
	$('#dlr_public_font').select2({minimumResultsForSearch: -1});
	$('#dlr_admin_font').select2({minimumResultsForSearch: -1});
	$('#display_mobits_menu').select2({minimumResultsForSearch: -1});
	$('#dlr_delete_extra_code_time').select2({minimumResultsForSearch: -1});
})
</script>