<?php $options = $GLOBALS['dlr_options']; ?>

<tr>
    <th class="dlr_field_base">
        <?php echo __('Login/Register page slug', 'dlr'); ?>
    </th>
    
    <td>
        <fieldset>
            <div class="dlr_slug">
                <input name="_dlr_page_slug" type="" class="_dlr_page_slug regular-text text-left" placeholder="" value="<?php echo get_option('_dlr_page_slug', 'dlr-login-register'); ?>">
                /<?php echo home_url(); ?>
            </div>
            <p class="description" id="tagline-description">
                
                   <?php echo __('<strong>Important Note:</strong> Permalink structure should not be simple. To change it, go to the settings menu and the unique links submenu and change the simple option. Your current login page link ', 'dlr'); ?>
                
                    <a target="_blank" href="<?php echo home_url() . '/' . esc_attr($options['_dlr_page_slug']); ?>">
                        <?php echo home_url() . '/' . esc_attr($options['_dlr_page_slug']); ?>
                        </a>
                <?php echo __('Note that while logging in, you will not be able to view the Mobits form. The name of the login page should be unique and not similar to any post or tab on the site. ', 'dlr'); ?>
				<a title="<?php echo __('Video tutorial', 'dlr'); ?>" target="_blank" href="https://aparat.com/v/BCSm3" class="dlr-what">
					<span class="dashicons dashicons-format-video"></span> 
				</a>
            </p>
        </fieldset>
    </td>
</tr>

<tr>
    <th class="dlr_field_base"><?php echo __('Resend code time (Seconds)', 'dlr'); ?>
    </th>
    
    <td>
        <fieldset>
            <input type="number" value="<?php echo esc_attr($options['_dlr_resend_code_time']); ?>" placeholder="120" name="_dlr_resend_code_time" class="regular-text text-left dlr_resend_code">
            <p class="description" id="tagline-description">
                <?php echo __('Specifies the resend time of the verification code in seconds.', 'dlr'); ?>
				<a title="<?php echo __('Video tutorial', 'dlr'); ?>" target="_blank" href="https://www.aparat.com/v/0fvVn" class="dlr-what">
					<span class="dashicons dashicons-format-video"></span> 
				</a>	
            </p>
        </fieldset>
    </td>
</tr>

<tr>
    <th class="dlr_field_base"><?php echo __('Number of digits of code', 'dlr'); ?>
    </th>
    
    <td>
        <fieldset>
            <input type="number" value="<?php echo esc_attr($options['_dlr_number_of_codes']); ?>" placeholder="" name="_dlr_number_of_codes" class="regular-text text-left dlr_resend_code">
            <p class="description" id="tagline-description">
                <?php echo __('You specify how many digits the confirmation code sent to the user should be.', 'dlr'); ?>
            </p>
        </fieldset>
    </td>
</tr>

<tr>
    <th class="dlr_field_base"><?php echo __('Number of wrong code allowed for user block', 'dlr'); ?>
    </th>
    
    <td>
        <fieldset>
            <input type="number" value="<?php echo esc_attr($options['_dlr_limit_wrong_code']); ?>" placeholder="" name="_dlr_limit_wrong_code" class="regular-text text-left dlr_resend_code">
            <p class="description" id="tagline-description">
                <?php echo __('You specify how many times a user is allowed to enter the wrong verification code during one minute. After that, the user will be blocked and access to the site will be blocked for that user. Pay attention that if you put a value of zero, it means that there is no limit and the user can enter the wrong code as many times as he wants (not recommended).', 'dlr'); ?>
            </p>
        </fieldset>
    </td>
</tr>

<tr>
    <th>
        <?php echo __('Email or username recovery', 'dlr'); ?>
    </th>
    
    <td>
		<label class="switch">
			<input name="_dlr_recovery_status" id="_dlr_recovery_status" type="checkbox" <?php checked( esc_attr($options['_dlr_recovery_status']), 1); ?> value="1">
			<span class="slider round"></span>
		</label>
        <p><?php echo __('By enabling this option, you will allow your old users who have registered with a username to have their mobile number replaced with a username, and from now on they can log in with a mobile number.', 'dlr'); ?> 
		<a title="<?php echo __('Video tutorial', 'dlr'); ?>" target="_blank" href="https://aparat.com/v/LmPCr" class="dlr-what">
			<span class="dashicons dashicons-format-video"></span> 
		</a>
		</p>
    </td>
</tr>

<tr>
    <th>
        <?php echo __('Update notice in admin bar', 'dlr'); ?>
    </th>
    
    <td>
		<label class="switch">
			<input name="_dlr_update_notice_in_admin_bar" id="_dlr_update_notice_in_admin_bar" type="checkbox" <?php checked( esc_attr($options['_dlr_update_notice_in_admin_bar']), 1); ?> value="1">
			<span class="slider round"></span>
		</label>
        <p><?php echo __('With this option enabled, when a new Mobits update is released, a notification message will appear in the admin bar..', 'dlr'); ?></p>
    </td>
</tr>

<tr>
    <th class="dlr_field_base">
        <?php echo __('mobile number meta key', 'dlr'); ?>
    </th>
    
    <td>
        <fieldset>
            <input value='mobits_mobile_number' readonly class="regular-text text-left">
        </fieldset>
		<p><?php echo __('Using this key, you can use plugins such as SMS marketing.', 'dlr'); ?></p>
    </td>
</tr>

<tr>
    <th>
        <?php echo __('Display header in mobits forms', 'dlr'); ?>
    </th>
    
    <td>
		<label class="switch">
			<input name="_dlr_display_header" id="_dlr_display_header" type="checkbox" <?php checked( esc_attr($options['_dlr_display_header']), 1); ?> value="1">
			<span class="slider round"></span>
		</label>
        <p><?php echo __('Display header of your template in mobits forms.', 'dlr'); ?> </p>
    </td>
</tr>

<tr>
    <th>
        <?php echo __('Display footer in mobits forms', 'dlr'); ?>
    </th>
    
    <td>
		<label class="switch">
			<input name="_dlr_display_footer" id="_dlr_display_footer" type="checkbox" <?php checked( esc_attr($options['_dlr_display_footer']), 1); ?> value="1">
			<span class="slider round"></span>
		</label>
        <p><?php echo __('Display footer of your template in mobits forms.', 'dlr'); ?> </p>
    </td>
</tr>