<?php $options = $GLOBALS['dlr_options']; ?>

<tr>
	<th colspan="2" class="dlr_sms_note_td">
		<div class="dlr_sms_note" style="margin-top: 0px;"><?php echo __('To change the settings of the button from this section, remove the parameters in the shortcode and only use the shortcode [mobits_button].', 'dlr'); ?></div>
	</th>
	<td></td>
</tr>

<tr>
    <th class="dlr_field_base">
        <?php echo __('Mobits login-register button shortcode', 'dlr'); ?>
    </th>
    
    <td>
        <fieldset>
            <input value='[mobits_button]' readonly class="regular-text text-left">
        </fieldset>
		<p><?php echo __('This shortcode creates a login and registration button for you. Just place it where you want the button to appear.', 'dlr'); ?> </p>
    </td>
</tr>

<tr>
    <th>
        <?php echo __('Submenu display', 'dlr'); ?>
    </th>
    
    <td>
		<label class="switch">
			<input name="mobits_button_submenu" id="mobits_button_submenu" type="checkbox" <?php checked( esc_attr($options['mobits_button_submenu']), 1); ?> value="1">
			<span class="slider round"></span>
		</label>
        <p><?php echo __('If you have a WooCommerce site, activate this option so that it is displayed under the WooCommerce menu.', 'dlr'); ?> 
		</p>
    </td>
</tr>

<tr>
	<th class="dlr_field_base"><?php echo __('To display the submenu', 'dlr'); ?></th>

	<td>
		<fieldset>
			<select id="mobits_button_submenu_align" name="mobits_button_submenu_align">
				<option value="left" <?php selected( esc_attr($options['mobits_button_submenu_align']) , 'left' ); ?>><?php echo __('Left', 'dlr'); ?></option>
				<option value="right" <?php selected( esc_attr($options['mobits_button_submenu_align']) , 'right' ); ?>><?php echo __('Right', 'dlr'); ?></option>
			</select>
		</fieldset>
		<p><?php echo __('You specify whether the sub-menu should be shown on the right side of the button or on its left side.', 'dlr'); ?> </p>
	</td>
</tr>

<script>
jQuery(document).ready(function($){
	$('#mobits_button_submenu_align').select2({minimumResultsForSearch: -1});
})
</script>

<tr>
    <th class="dlr_field_base">
        <?php echo __('Panel link', 'dlr'); ?>
    </th>
    
    <td>
        <fieldset>
            <input value="<?php echo $options['mobits_button_panel_link']; ?>" name="mobits_button_panel_link" class="regular-text text-left">
        </fieldset>
		<p><?php echo __('Specifies the link to the user panel', 'dlr'); ?> </p>
    </td>
</tr>

<tr>
    <th class="dlr_field_base">
        <?php echo __('Mobits button text when logined', 'dlr'); ?>
    </th>
    
    <td>
        <fieldset>
            <input value="<?php echo $options['mobits_button_logined_text']; ?>" name="mobits_button_logined_text" class="regular-text">
        </fieldset>
		<p><?php echo __('This text will be displayed on the button when you are logged in.', 'dlr'); ?> </p>
    </td>
</tr>

<tr>
    <th class="dlr_field_base">
        <?php echo __('Mobits button text when logged out', 'dlr'); ?>
    </th>
    
    <td>
        <fieldset>
            <input value="<?php echo $options['mobits_button_logout_text']; ?>" name="mobits_button_logout_text"  class="regular-text">
        </fieldset>
		<p><?php echo __('This text will be displayed on the button when you are logged out.', 'dlr'); ?> </p>
    </td>
</tr>

<tr>
    <th class="dlr_field_base">
        <?php echo __('Button text color', 'dlr'); ?>
    </th>
    
    <td>
        <fieldset>
            <input value="<?php echo $options['mobits_button_color']; ?>" name="mobits_button_color" class="regular-text text-left">
        </fieldset>
		<p><?php echo __('The text specifies the color of the button', 'dlr'); ?> </p>
    </td>
</tr>

<tr>
    <th class="dlr_field_base">
        <?php echo __('Button border', 'dlr'); ?>
    </th>
    
    <td>
        <fieldset>
            <input value="<?php echo $options['mobits_button_border']; ?>" name="mobits_button_border" class="regular-text text-left">
        </fieldset>
		<p><?php echo __('The text specifies the border of the button', 'dlr'); ?> </p>
    </td>
</tr>

<tr>
    <th class="dlr_field_base">
        <?php echo __('Background color', 'dlr'); ?>
    </th>
    
    <td>
        <fieldset>
            <input value="<?php echo $options['mobits_button_background']; ?>" name="mobits_button_background" class="regular-text text-left">
        </fieldset>
		<p><?php echo __('Specifies the background color of the button. You can use gradient or normal color.', 'dlr'); ?> </p>
    </td>
</tr>

<tr>
    <th class="dlr_field_base">
        <?php echo __('Font size', 'dlr'); ?>
    </th>
    
    <td>
        <fieldset>
            <input value="<?php echo $options['mobits_button_fontsize']; ?>" name="mobits_button_fontsize" class="regular-text text-left">
        </fieldset>
		<p><?php echo __('Specifies the font size of the button.', 'dlr'); ?> </p>
    </td>
</tr>

<tr>
    <th class="dlr_field_base">
        <?php echo __('Padding', 'dlr'); ?>
    </th>
    
    <td>
        <fieldset>
            <input value="<?php echo $options['mobits_button_padding']; ?>" name="mobits_button_padding" class="regular-text text-left">
        </fieldset>
		<p><?php echo __('Specifies the padding of the button.', 'dlr'); ?> </p>
    </td>
</tr>