<?php $options = $GLOBALS['dlr_options']; ?>

<tr>
    <th>
        <?php echo __('Database optimization', 'dlr'); ?>
    </th>
    
    <td>
		<form type="post"><input class="dlr_optimize_btn" type="submit" name="dlr_optimize" value="<?php echo __('Optimize it', 'dlr'); ?>" /></form>
		<span class="dlr_founded_unused_code">
		<?php echo $GLOBALS['dlr_unused_code']; ?>
		</span>
        <p><?php echo __('By using the optimization button, you can delete the redundant codes that are not used in the database so that the volume of your database is smaller and its performance is more optimized. <strong>Note:</strong> Be careful to do this when you are sure that no user is logging in. (during quiet hours of site traffic)', 'dlr'); ?></p>
    </td>
</tr>

<tr>
    <th>
        <?php echo __('Schedule removal of additional verification codes', 'dlr'); ?>
    </th>
    
    <td>
		<fieldset>
            <select name="dlr_delete_extra_code_time" id="dlr_delete_extra_code_time">
			<option value="-1" <?php selected( esc_attr($options['dlr_delete_extra_code_time'] ), '-1' ); ?>><?php echo __("Disable", "dlr"); ?></option>
				<?php 
					for ($i=0; $i<24; $i++) 
					{
						$i = $i<10 ? '0'.$i : $i;
						$selected = $i.':00' == $options['dlr_delete_extra_code_time'] ? 'selected="selected"' : ''; 
						echo '<option '.$selected.' value="'.$i.':00">'.$i.':00</option>';
					}
				?>
			</select>
            <p class="description" id="tagline-description">
                <?php echo __('If you want additional verification codes to be deleted from the database automatically at a certain time every day, use this setting. It is better to perform this operation during quiet hours of the site (for example, 3 in the morning).', 'dlr'); ?>
                <a title="<?php echo __('Video tutorial', 'dlr'); ?>" target="_blank" href="https://www.aparat.com/v/Fhm7l" class="dlr-what">
        			<span class="dashicons dashicons-format-video"></span> 
        		</a>
            </p>
        </fieldset>
    </td>
</tr>

<script>
jQuery(document).ready(function($){
	$('#dlr_delete_extra_code_time').select2({minimumResultsForSearch: -1});
})
</script>

<tr>
    <th>
        <?php echo __('Deleting Mobits data after deleting the plugin', 'dlr'); ?>
    </th>
    
    <td>
		<label class="switch">
			<input name="_dlr_delete_mobits_data" id="_dlr_delete_mobits_data" type="checkbox" <?php checked( esc_attr($options['_dlr_delete_mobits_data']), 1); ?> value="1">
			<span class="slider round"></span>
		</label>
        <p><?php echo __('After removing Mobits plugin, all data and database tables related to Mobits will be deleted.', 'dlr'); ?> </p>
    </td>
</tr>