<?php $options = $GLOBALS['dlr_options']; ?>
<tr>
    <th><?php echo __('CSV export numbers', 'dlr'); ?>
    
    </th>
    
    <td>
		<label class="switch">
			<input name="_dlr_export_csv" id="_dlr_export_csv" type="checkbox" <?php checked( esc_attr($options['_dlr_export_csv']), 1); ?> value="1">
			<span class="slider round"></span>
		</label>
        <p><?php echo __('With this option enabled, it is possible to output Excel from users mobile numbers on the page of all users in the admin panel.', 'dlr'); ?>
		<a title="<?php echo __('Video tutorial', 'dlr'); ?>" target="_blank" href="https://www.aparat.com/v/COaBY" class="dlr-what">
			<span class="dashicons dashicons-format-video"></span> 
		</a>
		</p>
    </td>
</tr>

<tr>
    <th><?php echo __('Import user numbers', 'dlr'); ?>
    </th>
    
    <td>
		<div class="dlr_quick_user_create">
			<fieldset>
				<input accept=".csv, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet, application/vnd.ms-excel" name="_dlr_import_csv" id="_dlr_import_csv" type="file">
			</fieldset>
			<input type="submit" name="dlr_import" id="submit" class="button button-primary dlr_import_btn" value="<?php echo __('Import', 'dlr'); ?>">

			<?php 
if( isset($_POST['dlr_import']) ) echo '<div class="dlr_imported">' . $GLOBALS["dlr_imported_count"] . ' ' .  __(' users were added.', 'dlr') . '</div>';
?>

		</div>
        <p><?php echo __('Choose an CSV file containing the mobile numbers of your users. Make sure that this file is exactly the same as the sample file. <a href="https://biawp.ir/sample-file.csv">Sample file</a>. The first column for mobile numbers and the second column for user names. also name column is optional. To specify users role, go to Settings>General and change the default role.', 'dlr'); ?></p>
    </td>
</tr>

<tr>
    <th class="dlr_field_base"><?php echo __('Quick user creation', 'dlr'); ?></th>
    
    <td>
		<div class="dlr_quick_user_create">
			<div><input type="search" name="dlr_first_name" placeholder="<?php echo __('First name', 'dlr'); ?>" /></div>
			<div><input class="regular-text" type="search" name="dlr_last_name" placeholder="<?php echo __('Family', 'dlr'); ?>" /></div>
			<div><input type="search" name="dlr_mobile" class="dlr_q_mobile" placeholder="* <?php echo __('Mobile', 'dlr'); ?>" /></div>
			<div><input type="checkbox" name="dlr_q_woocommerce" value="1" id="dlr_q_woocommerce" /><label for="dlr_q_woocommerce"><?php echo __('Add to woocommerce', 'dlr'); ?></label></div>
			<input id="submit" class="button button-primary" type="submit" name="quick_user_create" value="<?php echo __('Create it', 'dlr'); ?>" />
			<?php 
			if( isset($_POST['quick_user_create']) ) {
				$class = $GLOBALS['dlr_quick_user_class'];
				echo '<div class="'.$class.'">'.$GLOBALS["dlr_quick_user"].'</div>'; 
			}
				
			?>
		</div>
        <p><?php echo __('Create a new user lightning fast. The name is not necessary.', 'dlr'); ?></p>
    </td>
</tr>

<tr>
    <th><?php echo __('Export mobits settings', 'dlr'); ?>
    </th>
    
    <td>
		<input id="submit" class="button button-primary" type="submit" name="get_settings_export" value="<?php echo __('get export', 'dlr'); ?>" />
        <p><?php echo __('You will receive a csv file containing mobits settings. Go to the destination site and import the settings from the Mobits settings import section in the import/export tab.', 'dlr'); ?></p>
    </td>
</tr>

<tr>
    <th><?php echo __('Import mobits settings', 'dlr'); ?>
    </th>
    
    <td>
		<div class="dlr_quick_user_create">
			<fieldset>
				<input accept=".csv, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet, application/vnd.ms-excel" name="_dlr_import_settings" id="_dlr_import_settings" type="file">
			</fieldset>
			<input type="submit" name="dlr_import_settings" id="submit" class="button button-primary dlr_import_btn" value="<?php echo __('Import', 'dlr'); ?>">

			<?php 
if( isset($_POST['dlr_import_settings']) ) echo '<div class="dlr_imported">' . $GLOBALS["dlr_imported_settings_count"] . ' ' .  __(' settings were added or update.', 'dlr') . '</div>';
?>

		</div>
        <p><?php echo __('If you have received a csv file containing Mobits settings from another site and you intend to transfer those settings to this site, upload it here and click on the import button. The settings you set on another site will also be set on this site.', 'dlr'); ?></p>
    </td>
</tr>