<?php $options = $GLOBALS['dlr_options']; ?>
<tr>
    <th class="dlr_field_base_switch">
        <?php echo __('Login Form', 'dlr'); ?>
    </th>
    
    <td>
		<label class="switch">
			<input name="_dlr_login_status" id="dlr_login_status" type="checkbox" <?php checked( esc_attr($options['_dlr_login_status']), 1); ?> value="1">
			<span class="slider round"></span>
		</label>
        <p>
		<?php echo __('By enabling this option, login tab and form will be displayed.', 'dlr'); ?>
		<a title="<?php echo __('Video tutorial', 'dlr'); ?>" target="_blank" href="https://aparat.com/v/OG3oK" class="dlr-what">
			<span class="dashicons dashicons-format-video"></span>
		</a>
		</p>
    </td>
</tr>

<tr>
    <th><?php echo __('Login priority', 'dlr'); ?></th>
    
    <td>
        <fieldset>
            <p>
                <input name="_dlr_login_priority" id="_dlr_login_priority_mobile" type="radio" <?php checked( esc_attr($options['_dlr_login_priority']), 'mobile'); ?> value="mobile">
                <label for="_dlr_login_priority_mobile"><?php echo __('Login with mobile and confirm code', 'dlr'); ?></label>
            </p>
            <p>
                <input name="_dlr_login_priority" id="_dlr_login_priority_password" type="radio" <?php checked( esc_attr($options['_dlr_login_priority']), 'password'); ?> value="password">
                <label for="_dlr_login_priority_password"><?php echo __('login with password', 'dlr'); ?></label>
            </p>
        </fieldset>
        <p>
           <?php echo __('By using this setting, you specify on the login page that the priority is to log in with a confirmation code or log in with a mobile number/email and password.', 'dlr'); ?> 
        </p>
    </td>
</tr>

<tr>
    <th class="dlr_field_base_switch">
        <?php echo __('Login with mobile', 'dlr'); ?>
    </th>
    
    <td>
		<label class="switch">
			<input name="_dlr_login_with_mobile" id="_dlr_login_with_mobile" type="checkbox" <?php checked( esc_attr($options['_dlr_login_with_mobile']), 1); ?> value="1">
			<span class="slider round"></span>
		</label>
        <p><?php echo __('With this option enabled, the user can log in using their mobile number and SMS verification code.', 'dlr'); ?></p>
    </td>
</tr>

<tr>
    <th class="dlr_field_base_switch">
        <?php echo __('Login with email', 'dlr'); ?>
    </th>
    
    <td>
		<label class="switch">
			<input name="_dlr_login_with_email" id="_dlr_login_with_email" type="checkbox" <?php checked( esc_attr($options['_dlr_login_with_email']), 1); ?> value="1">
			<span class="slider round"></span>
		</label>
        <p><?php echo __('With this option enabled, the user can login using email and password. To log in by email, login with a password must be enabled (option below)', 'dlr'); ?></p>
    </td>
</tr>

<tr>
    <th class="dlr_field_base_switch">
        <?php echo __('Login with password', 'dlr'); ?>
    </th>
    
    <td>
		<label class="switch">
			<input name="_dlr_login_with_password_status" id="_dlr_login_with_password_status" type="checkbox" <?php checked( esc_attr($options['_dlr_login_with_password_status']), 1); ?> value="1">
			<span class="slider round"></span>
		</label>
        <p><?php echo __('With this option enabled, the user can login using email and password. note: Considering that login by e-mail is done using a password. Therefore, if you disable this option, i.e. password login, email login will also be disabled.', 'dlr'); ?></p>
    </td>
</tr>

<tr>
    <th class="dlr_field_base_switch">
        <?php echo __('Forget password (mobile number)', 'dlr'); ?>
    </th>
    
    <td>
		<label class="switch">
			<input name="_dlr_forget_password" id="_dlr_forget_password" type="checkbox" <?php checked( esc_attr($options['_dlr_forget_password']), 1); ?> value="1">
			<span class="slider round"></span>
		</label>
        <p><?php echo __('With this option enabled, users can create a new password for their account. The validation method for forgetting the password by mobile phone is the confirmation code.', 'dlr'); ?></p>
    </td>
</tr>

<tr>
    <th class="dlr_field_base_switch">
        <?php echo __('Forget password (email)', 'dlr'); ?>
    </th>
    
    <td>
		<label class="switch">
			<input name="_dlr_forget_password_email" id="_dlr_forget_password_email" type="checkbox" <?php checked( esc_attr($options['_dlr_forget_password_email']), 1); ?> value="1">
			<span class="slider round"></span>
		</label>
        <p><?php echo __('With this option enabled, users can create a new password for their account. The validation method for forgetting the password by email, sending a link to the email and returning to Mobits..', 'dlr'); ?></p>
    </td>
</tr>

<tr>
    <th class="dlr_field_base_switch">
        <?php echo __('Register user in login form', 'dlr'); ?>
    </th>
    
    <td>
		<label class="switch">
			<input name="_dlr_register_in_login_form" id="_dlr_register_in_login_form" type="checkbox" <?php checked( esc_attr($options['_dlr_register_in_login_form']), 1); ?> value="1">
			<span class="slider round"></span>
		</label>
		<p class="description" id="tagline-description">
			<?php echo __('By activating this option, the Mobits login form registers new users. Note that in this case, the user will not have a first and last name. ', 'dlr'); ?>
			<a title="<?php echo __('Video tutorial', 'dlr'); ?>" target="_blank" href="https://aparat.com/v/a0uc5" class="dlr-what">
				<span class="dashicons dashicons-format-video"></span>
			</a>
		</p>
    </td>
</tr>

<tr>
    <th class="dlr_field_base_switch">
        <?php echo __('Display last login', 'dlr'); ?>
    </th>
    
    <td>
		<label class="switch">
			<input name="_dlr_last_login" id="_dlr_last_login" type="checkbox" <?php checked( esc_attr($options['_dlr_last_login']), 1); ?> value="1">
			<span class="slider round"></span>
		</label>
        <p><?php echo __('By enabling this option, the last login of users from Mobits will be shown on the page of all users.', 'dlr'); ?></p>
    </td>
</tr>
