<?php $options = $GLOBALS['dlr_options']; ?>
<tr>
    <th class="dlr_field_base_switch">
        <?php echo __('Refer to the previous page after login in', 'dlr'); ?>
    </th>
    
    <td>
		<label class="switch">
			<input name="_dlr_redirect_previous_page" id="_dlr_redirect_previous_page" type="checkbox" <?php checked( esc_attr($options['_dlr_redirect_previous_page']), 1); ?> value="1">
			<span class="slider round"></span>
		</label>
        <p>
            <?php echo __('With this option enabled, the user will be redirected to the page from which he/she came after logging in or registering.', 'dlr'); ?>
			<a title="<?php echo __('Video tutorial', 'dlr'); ?>" target="_blank" href="https://aparat.com/v/eI8KZ" class="dlr-what">
				<span class="dashicons dashicons-format-video"></span> 			
			</a>
        </p>
    </td>
</tr>

<tr>
    <th class="dlr_field_base_switch">
        <?php echo __('Redirect the new user from the login form to the registration form', 'dlr'); ?>
    </th>
    
    <td>
		<label class="switch">
			<input name="_dlr_redirect_new_user_to_register_form" id="_dlr_redirect_new_user_to_register_form" type="checkbox" <?php checked( esc_attr($options['_dlr_redirect_new_user_to_register_form']), 1); ?> value="1">
			<span class="slider round"></span>
		</label>
        <p>
            <?php echo __('When this option is enabled, new users will be redirected from the login form to the registration form to be required to enter their name as well.', 'dlr'); ?>
        </p>
    </td>
</tr>

<tr>
    <th class="dlr_field_base"><?php echo __('Page link after login', 'dlr'); ?> 
    </th>
    
    <td>
        <fieldset>
            <input value="<?php echo esc_attr($options['_dlr_redirect_url']); ?>" placeholder="<?php echo home_url(); ?>" name="_dlr_redirect_url" class="regular-text text-left">
            <p class="description" id="tagline-description">
                <?php echo __('The user will be redirected to this page after successful login.', 'dlr'); ?>
				<a title="<?php echo __('Video tutorial', 'dlr'); ?>" target="_blank" href="https://www.aparat.com/v/7pbJh" class="dlr-what">
				<span class="dashicons dashicons-format-video"></span> 
				</a>
            </p>
        </fieldset>
    </td>
</tr>

<tr>
    <th class=""><?php echo __('Page link after login based on user role', 'dlr'); ?> 
    </th>
    
    <td>
        <fieldset>
			<div class="dlr_redirects">
				<?php 
				echo $GLOBALS['redirect_roles_method'];
				?>
			</div>
            <button class="redirect_by_role" id="submit" type="button"><?php echo __('Add', 'dlr'); ?></button>
            <p class="description" id="tagline-description">
                <?php echo __('You specify which page your desired user role will be redirected to after login.', 'dlr'); ?>
            </p>
        </fieldset>
    </td>
</tr>

<tr>
    <th class="dlr_field_base"><?php echo __('Page link after logout', 'dlr'); ?>
    </th>
    
    <td>
        <fieldset>
            <input value="<?php echo esc_attr($options['_dlr_redirect_logout']); ?>" placeholder="<?php echo home_url(); ?>" name="_dlr_redirect_logout" class="regular-text text-left">
            <p class="description" id="tagline-description">
               <?php echo __('The user will be redirected to this page after logout.', 'dlr'); ?>
			   <a title="<?php echo __('Video tutorial', 'dlr'); ?>" target="_blank" href="https://www.aparat.com/v/wPrBU" class="dlr-what">
			   <span class="dashicons dashicons-format-video"></span> 
			   </a>
            </p>
        </fieldset>
    </td>
</tr>

<tr>
    <th class="dlr_field_base_switch">
        <?php echo __('Auto redirect after code entered ', 'dlr'); ?>
    </th>
    
    <td>
		<label class="switch">
			<input name="_dlr_auto_confirm" id="_dlr_auto_confirm" type="checkbox" <?php checked( esc_attr($options['_dlr_auto_confirm']), 1); ?> value="1">
			<span class="slider round"></span>
		</label>
        <p>
            <?php echo __('By enabling this option, the user, after entering 4 digits of the code, will be automatically transferred to the next step without pressing a button.', 'dlr'); ?>
			<a title="<?php echo __('Video tutorial', 'dlr'); ?>" target="_blank" href="https://aparat.com/v/y98CF" class="dlr-what">
				<span class="dashicons dashicons-format-video"></span> 
			</a>
        </p>
    </td>
</tr>

<tr>
    <th class="dlr_field_base_switch">
        <?php echo __('Require login to view the site ', 'dlr'); ?>
    </th>
    
    <td>
		<label class="switch">
			<input name="_dlr_login_force_all" id="_dlr_login_force_all" type="checkbox" <?php checked( esc_attr($options['_dlr_login_force_all']), 1); ?> value="1">
			<span class="slider round"></span>
		</label>
        <p><?php echo __('By enabling this option, you will need to log in to view all sections of the site, and the user will be taken to the Mobits login page.', 'dlr'); ?>
		<a title="<?php echo __('Video tutorial', 'dlr'); ?>" target="_blank" href="https://www.aparat.com/v/suU1G" class="dlr-what">
			<span class="dashicons dashicons-format-video"></span> 
		</a>
		</p>
    </td>
</tr>

<tr>
    <th class="dlr_field_base_switch">
        <?php echo __('Redirect admin login to mobits', 'dlr'); ?>
        
    </th>
    
    <td>
		<label class="switch">
			<input name="_dlr_admin_login_redirect" id="_dlr_admin_login_redirect" type="checkbox" <?php checked( esc_attr($options['_dlr_admin_login_redirect']), 1); ?> value="1">
			<span class="slider round"></span>
		</label>
        <p><?php echo __('With this option enabled, the user will be redirected from the WordPress admin login page (wp-admin or wp-login.php) to the Mobits form. <strong>Important Note:</strong> Before activating this option, make sure that there is an admin user with Mobits and a mobile number in the panel. ', 'dlr'); ?>
		<a title="<?php echo __('Video tutorial', 'dlr'); ?>" target="_blank" href="https://www.aparat.com/v/rY21z" class="dlr-what">
			<span class="dashicons dashicons-format-video"></span> 
		</a>
		</p>
    </td>
</tr>

<tr>
    <th class="dlr_field_base">
        <?php echo __('Redirect a page to mobits', 'dlr'); ?>
    </th>
    
    <td>
        <fieldset>
            <input value='[go_mobits back="pageUrl"]' readonly class="regular-text text-left">
        </fieldset>
        <p><?php echo __('If you want to redirect a non-logged in user to a mobits form, use this shortcode on that page. The back parameter specifies the return page address of Mobits after login or register. If you do not use this parameter, the user will return to the page where the shortcode is placed (current page). ', 'dlr'); ?>
		<a title="<?php echo __('Video tutorial', 'dlr'); ?>" target="_blank" href="https://aparat.com/v/pRPDO" class="dlr-what">
			<span class="dashicons dashicons-format-video"></span> 
		</a>
		</p>
    </td>
</tr>

<tr>
    <th class="dlr_field_base_switch">
        <?php echo __('Display return to back button', 'dlr'); ?>
    </th>
    
    <td>
		<label class="switch">
			<input name="_dlr_display_return_back_btn" id="_dlr_display_return_back_btn" type="checkbox" <?php checked( esc_attr($options['_dlr_display_return_back_btn']), 1); ?> value="1">
			<span class="slider round"></span>
		</label>
        <p><?php echo __('The back button is displayed at the top of Mobitz pages.', 'dlr'); ?></p>
    </td>
</tr>

<tr>
    <th class="dlr_field_base">
        <?php echo __('return to back button text', 'dlr'); ?>
    </th>
    
    <td>
        <fieldset>
            <input value="<?php echo esc_attr($options['_dlr_return_back_btn_text']); ?>" name="_dlr_return_back_btn_text" class="regular-text">
        </fieldset>
        <p><?php echo __('Specifies what text to display on the back button.', 'dlr'); ?></p>
    </td>
</tr>