<?php $options = $GLOBALS['dlr_options']; ?>

<tr>
    <th class="dlr_field_base_switch">
        <?php echo __('Welcome sms', 'dlr'); ?>
    </th>
    
    <td>
		<label class="switch">
			<input name="_dlr_welcome_sms_status" id="_dlr_welcome_sms_status" type="checkbox" <?php checked( esc_attr($options['_dlr_welcome_sms_status']), 1); ?> value="1">
			<span class="slider round"></span>
		</label>
        <p><?php echo __('New users will be sent a welcome SMS (or notification) after registration.', 'dlr'); ?></p>
    </td>
</tr>

<tr>
    <th class="dlr_field_base_switch center cs-label2">
        <?php echo __("sms type", "dlr"); ?>
    </th>
    
    <td>
		<select name="_dlr_welcome_sms_type" class="_dlr_welcome_sms_type">
			<option value="template" <?php selected( esc_attr($options['_dlr_welcome_sms_type']) , 'template' ); ?>><?php echo __('templatable', 'dlr'); ?></option>
			<option value="text" <?php selected( esc_attr($options['_dlr_welcome_sms_type']) , 'text' ); ?>><?php echo __('Textable', 'dlr'); ?></option>
		</select>

		<p>
		<?php echo __("The SMS template type means that you should create a SMS template in your SMS panel and use one of the variables in it. The text message type means that you create your own text. The type of SMS format is sent to administrators faster and passes the blacklist.", "dlr"); ?>
		</p>
    </td>
</tr>

<tr class="welcome_sms_type_template">
    <th class="dlr_field_base_switch">
        <?php echo __("Template creation learning", "dlr"); ?>
    </th>
    
    <td>
		<div class="cs-second dlr_template_learning">
			<a href="https://www.aparat.com/v/AZ4FJ" target="_blank"><?php echo __('Ippanel', 'dlr'); ?></a>
			<a href="https://www.aparat.com/v/YtKWT" target="_blank"><?php echo __('melipayamak', 'dlr'); ?></a>
			<a href="https://www.aparat.com/v/0sdw3" target="_blank"><?php echo __('Sms.ir', 'dlr'); ?></a>
			<a href="https://www.aparat.com/v/EZoL1" target="_blank"><?php echo __('payamresan', 'dlr'); ?></a>
			<a href="https://www.aparat.com/v/ocqhn" target="_blank"><?php echo __('kavenegar', 'dlr'); ?></a>
			<a href="https://www.aparat.com/v/hxFne" target="_blank"><?php echo __('farapayamak', 'dlr'); ?></a>
			<a href="https://www.aparat.com/v/zXy1J" target="_blank"><?php echo __('payamito (payamito.com)', 'dlr'); ?></a>
		</div>
    </td>
</tr>

<tr class="welcome_sms_type_template">
    <th class="dlr_field_base_switch cs-label2 center">
        <?php echo __("Template code", "dlr"); ?>
    </th>
    
    <td>
		<input class="text-left" type="text" id="_dlr_welcome_sms_template_code" name="_dlr_welcome_sms_template_code" value="<?php echo esc_attr($options['_dlr_welcome_sms_template_code']); ?>" placeholder=""/>
		<p>
		<?php echo __("Enter the ID of the SMS template you created in your SMS panel.", "dlr"); ?>
		</p>
    </td>
</tr>

<tr class="welcome_sms_type_template">
    <th class="dlr_field_base_switch cs-label2 center">
        <?php echo __("Template variables", "dlr"); ?>
    </th>
    
    <td>
		<input class="text-left" placeholder="name,mobile,email,password" type="text" id="_dlr_welcome_sms_template_variables" name="_dlr_welcome_sms_template_variables" value="<?php echo esc_attr($options['_dlr_welcome_sms_template_variables']); ?>" placeholder=""/>
		<p>
		<?php echo __("Enter the variables you have used in this format in the above box. Use a comma (,) after each variable. Do not use a hyphen.", "dlr"); ?>
		</p>
    </td>
</tr>

<tr class="welcome_sms_type_template">
    <th class="dlr_field_base_switch cs-label2 center">
        <?php echo __("Replace user name", "dlr"); ?>
    </th>
    
    <td>
		<input placeholder="مشتری، کاربر ..." type="text" id="_dlr_welcome_sms_template_name_replace" name="_dlr_welcome_sms_template_name_replace" value="<?php echo esc_attr($options['_dlr_welcome_sms_template_name_replace']); ?>" placeholder=""/>
		<p>
		<?php echo __("If you want to use the name variable, but some of your users don't have a name, you specify what to display instead.", "dlr"); ?>
		</p>
    </td>
</tr>

<tr class="welcome_sms_type_text">
    <th class="dlr_field_base_switch cs-label2 center">
        <?php echo __('Welcome sms body', 'dlr'); ?>
    </th>
    
    <td>
		<fieldset>
            <textarea class="dlr_extra_style dlr_welcome_sms_body" rows="6" name="_dlr_welcome_sms_body"><?php echo esc_attr($options['_dlr_welcome_sms_body']); ?></textarea>
        </fieldset>
        <p><?php echo __('You specify what text should be sent to the customer for the welcome SMS (notification).', 'dlr'); ?></p>
    </td>
</tr>

<script>
jQuery(document).ready(function($)
{
	$('._dlr_welcome_sms_type').select2({minimumResultsForSearch: -1});

	var type = '<?php echo $options['_dlr_welcome_sms_type']; ?>';

	$('.welcome_sms_type_'+type).fadeIn();

	$(document).on('change', '._dlr_welcome_sms_type', function()
	{
		var type = $(this).find(":selected").val();
		$('.welcome_sms_type_text, .welcome_sms_type_template').fadeOut();

		$('.welcome_sms_type_'+type).fadeIn();
	});
});
</script>