<?php $options = $GLOBALS['dlr_options']; ?>
<tr>
    <th>
        <?php echo __('Webservice reports', 'dlr'); ?>
    </th>
    
    <td>
		<label class="switch">
			<input name="_dlr_webservice_reports" id="_dlr_webservice_reports" type="checkbox" <?php checked( esc_attr($options['_dlr_webservice_reports']), 1); ?> value="1">
			<span class="slider round"></span>
		</label>
        <p><?php echo __('The SMS sending status is saved. Also, a new tab with the title of reports is added and the list of all SMS sent to users is displayed.', 'dlr'); ?> </p>
    </td>
</tr>

<tr>
    <th>
        <?php echo __('Wrong code reports', 'dlr'); ?>
    </th>
    
    <td>
		<label class="switch">
			<input name="_dlr_wrong_code_reports" id="_dlr_wrong_code_reports" type="checkbox" <?php checked( esc_attr($options['_dlr_wrong_code_reports']), 1); ?> value="1">
			<span class="slider round"></span>
		</label>
        <p><?php echo __("Users' wrong codes are saved and a list of all of them is displayed in the wrong codes report menu. This item is useful for identifying malicious users or customers who fail to log in", 'dlr'); ?> </p>
    </td>
</tr>

<tr>
    <th>
        <?php echo __('Timing to delete the report of sent SMS.', 'dlr'); ?>
    </th>
    
    <td>
		<fieldset>
            <select name="dlr_delete_sendsms_report" id="dlr_delete_sendsms_report">
    			<option value="-1" <?php selected( esc_attr($options['dlr_delete_sendsms_report'] ), '-1' ); ?>><?php echo __("Disable", "dlr"); ?></option>
    			<option value="1" <?php selected( esc_attr($options['dlr_delete_sendsms_report'] ), '1' ); ?>><?php echo __("Daily", "dlr"); ?></option>
    			<option value="2" <?php selected( esc_attr($options['dlr_delete_sendsms_report'] ), '2' ); ?>><?php echo __("2 Days", "dlr"); ?></option>
    			<option value="3" <?php selected( esc_attr($options['dlr_delete_sendsms_report'] ), '3' ); ?>><?php echo __("3 Days", "dlr"); ?></option>
    			<option value="5" <?php selected( esc_attr($options['dlr_delete_sendsms_report'] ), '5' ); ?>><?php echo __("5 Days", "dlr"); ?></option>
    			<option value="10" <?php selected( esc_attr($options['dlr_delete_sendsms_report'] ), '10' ); ?>><?php echo __("10 Days", "dlr"); ?></option>
    			<option value="15" <?php selected( esc_attr($options['dlr_delete_sendsms_report'] ), '15' ); ?>><?php echo __("15 Days", "dlr"); ?></option>
    			<option value="30" <?php selected( esc_attr($options['dlr_delete_sendsms_report'] ), '30' ); ?>><?php echo __("Monthly", "dlr"); ?></option>
			</select>
            <p class="description" id="tagline-description">
                <?php echo __('If you want the report of sent SMS to be automatically deleted from the database every day at a specified time, use this setting.', 'dlr'); ?>
            </p>
        </fieldset>
    </td>
</tr>

<tr>
    <th>
        <?php echo __('Timing to delete the wrong codes.', 'dlr'); ?>
    </th>
    
    <td>
		<fieldset>
            <select name="dlr_delete_wrongcodes_report" id="dlr_delete_wrongcodes_report">
			    <option value="-1" <?php selected( esc_attr($options['dlr_delete_wrongcodes_report'] ), '-1' ); ?>><?php echo __("Disable", "dlr"); ?></option>
    			<option value="1" <?php selected( esc_attr($options['dlr_delete_wrongcodes_report'] ), '1' ); ?>><?php echo __("Daily", "dlr"); ?></option>
    			<option value="2" <?php selected( esc_attr($options['dlr_delete_wrongcodes_report'] ), '2' ); ?>><?php echo __("2 Days", "dlr"); ?></option>
    			<option value="3" <?php selected( esc_attr($options['dlr_delete_wrongcodes_report'] ), '3' ); ?>><?php echo __("3 Days", "dlr"); ?></option>
    			<option value="5" <?php selected( esc_attr($options['dlr_delete_wrongcodes_report'] ), '5' ); ?>><?php echo __("5 Days", "dlr"); ?></option>
    			<option value="10" <?php selected( esc_attr($options['dlr_delete_wrongcodes_report'] ), '10' ); ?>><?php echo __("10 Days", "dlr"); ?></option>
    			<option value="15" <?php selected( esc_attr($options['dlr_delete_wrongcodes_report'] ), '15' ); ?>><?php echo __("15 Days", "dlr"); ?></option>
    			<option value="30" <?php selected( esc_attr($options['dlr_delete_wrongcodes_report'] ), '30' ); ?>><?php echo __("Monthly", "dlr"); ?></option>
			</select>
            <p class="description" id="tagline-description">
                <?php echo __('If you want the wrong codes to be automatically deleted from the database every day at a specified time, use this setting.', 'dlr'); ?>
            </p>
        </fieldset>
    </td>
</tr>

<tr>
	<th>
        <input type="submit" name="dlr_submit" id="submit" class="button button-primary" value="<?php echo __('Save changes', 'dlr'); ?>">
	</th>
</tr>

<script>
jQuery(document).ready(function($){
	$('#dlr_delete_sendsms_report').select2({minimumResultsForSearch: -1});
	$('#dlr_delete_wrongcodes_report').select2({minimumResultsForSearch: -1});
})
</script>