<?php $wrong_codes = $GLOBALS['dlr_wrong_codes']; ?>

<div>
	<div class="dlr_reports_sendsms_blocks">
		<div>
			<?php echo __("All wrong codes count", "dlr"); ?>
			<span><?php echo $wrong_codes['total']; ?></span>
		</div>

		<div>
			<?php echo __("Today wrong codes", "dlr"); ?>
			<span><?php echo $wrong_codes['today']; ?></span>
		</div>
		
		<div>
			<?php echo __("Most user wrong codes", "dlr"); ?>
			<span><?php echo $wrong_codes['user']; ?></span>
		</div>
	</div>

	<h4>
	<span class="dashicons dashicons-admin-comments"></span>
	<?php echo __("User's wrong codes", "dlr"); ?>

	<input name="dlr_truncate_wrongcodes" type="submit" value="<?php echo __('Delete all', 'dlr'); ?>" />

	&nbsp;

	<select class="dlr_wrongcodes_date_filter">
		<?php $date = isset($_GET['date']) ? $_GET['date'] : ''; ?>
		<option value="all" <?php selected($date, "all"); ?>><?php echo __("All date", "dlr"); ?></option>
		<option value="today" <?php selected($date, "today"); ?>><?php echo __("Today", "dlr"); ?></option>
		<option value="yesterday" <?php selected($date, "yesterday"); ?>><?php echo __("Yesterday", "dlr"); ?></option>
		<option value="week" <?php selected($date, "week"); ?>><?php echo __("Last week", "dlr"); ?></option>
		<option value="month" <?php selected($date, "month"); ?>><?php echo __("Last month", "dlr"); ?></option>
	</select>

	&nbsp;

	<script>
	jQuery(document).ready(function($){
		$('.dlr_wrongcodes_date_filter').select2({ minimumResultsForSearch: -1, dropdownCssClass: "dlr_reports_dropdown" });
	})
	</script>

	<?php echo $GLOBALS['dlr_wrong_codes_pagination']; ?>
	</h4>
</div>

<div class="dlr_reports_table">

	<div class="dlr_rt_head">
		<div>#</div>
		<div><?php echo __('Webservice', 'dlr'); ?></div>
		<div><?php echo __('Template code / sms text', 'dlr'); ?></div>
		<div><?php echo __('Reciever', 'dlr'); ?></div>
		<div><?php echo __('Time', 'dlr'); ?></div>
	</div>

	<div class="dlr_rt_body">

	<?php 
	foreach( $wrong_codes['wrong_codes'] as $wrong_code ):

		echo '<div class="dlr_rt_row">';
			echo '<div>'.$wrong_code["number"].'</div>';
			echo '<div>'.$wrong_code["webservice"].'</div>';
			echo '<div>'.$wrong_code["template"].'</div>';
			echo '<div>'.$wrong_code["receiver"].'</div>';
			echo '<div>'.$wrong_code["time"].'</div>';
		echo '</div>';

	endforeach; ?>

	</div>

</div>

<div class="dlr_reports_pagination_bottom"><?php echo $GLOBALS['dlr_wrong_codes_pagination']; ?><br/><br/><br/></div>