<article id="<?php echo $key; ?>">
	<h2><?php echo __("Status", "dlr").' ' .$status; ?></h2>

		<div class="flex">
			<div class="cs-label"><label><?php echo __("send SMS", "dlr"); ?></label></div>
			<div class="cs-second">
				<label class="switch">
					<input name="_dlr_admin_<?php echo $key; ?>_sms_status" id="_dlr_admin_<?php echo $key; ?>_sms_status" type="checkbox" <?php checked( esc_attr($options['_dlr_admin_'.$key.'_sms_status']), 1); ?> value="1">
					<span class="slider round"></span>
				</label>

				<p>
				<?php echo __("You specify whether to send an SMS to the admin when the order is this", "dlr"); ?>
				</p>
			</div>
		</div>

		<div class="flex">
			<div class="cs-label center"><label><?php echo __("Select managers", "dlr"); ?></label></div>
			<div class="cs-second cs-multiple">
				<select multiple id="_dlr_admin_<?php echo $key; ?>_managers" name="_dlr_admin_<?php echo $key; ?>_managers[]">
					<?php echo $GLOBALS['dlr_woo_admins'][$key]; ?>
				</select>

				<p>
				<?php echo __("Select the administrators to whom you want to send SMS in this situation. Only managers with the roles of general manager and store manager can be selected. Pay attention that the mobile number of your managers must be saved as a username to send SMS.", "dlr"); ?>
				</p>
			</div>
		</div>

		<div class="flex">
			<div class="cs-label center"><label><?php echo __("sms type", "dlr"); ?></label></div>
			<div class="cs-second">
				<select name="_dlr_admin_<?php echo $key; ?>_sms_type" data-id="<?php echo $key; ?>" class="dlr_sms_type_select">
					<option value="template" <?php selected( esc_attr($options['_dlr_admin_'.$key.'_sms_type']) , 'template' ); ?>><?php echo __('templatable', 'dlr'); ?></option>
					<option value="text" <?php selected( esc_attr($options['_dlr_admin_'.$key.'_sms_type']) , 'text' ); ?>><?php echo __('Textable', 'dlr'); ?></option>
				</select>

				<p>
				<?php echo __("The SMS template type means that you should create a SMS template in your SMS panel and use the following variables in it. The type of text message means that you create your own desired text using the following variables. The type of SMS format is sent to admins faster and bypasses the blacklist.", "dlr"); ?>
				</p>

			</div>
		</div>

		<div class="flex <?php echo $key; ?>_template">

			<div class="cs-label top">
				<label for="_dlr_admin_<?php echo $key; ?>_template_code">
				<?php echo __("Template creation learning", "dlr"); ?>
				</label> 
			</div>

			<div class="cs-second dlr_template_learning">
				<a href="https://www.aparat.com/v/AZ4FJ" target="_blank"><?php echo __('Ippanel', 'dlr'); ?></a>
				<a href="https://www.aparat.com/v/YtKWT" target="_blank"><?php echo __('melipayamak', 'dlr'); ?></a>
				<a href="https://www.aparat.com/v/0sdw3" target="_blank"><?php echo __('Sms.ir', 'dlr'); ?></a>
				<a href="https://www.aparat.com/v/EZoL1" target="_blank"><?php echo __('payamresan', 'dlr'); ?></a>
				<a href="https://www.aparat.com/v/ocqhn" target="_blank"><?php echo __('kavenegar', 'dlr'); ?></a>
				<a href="https://www.aparat.com/v/hxFne" target="_blank"><?php echo __('farapayamak', 'dlr'); ?></a>
				<a href="https://www.aparat.com/v/zXy1J" target="_blank"><?php echo __('payamito (payamito.com)', 'dlr'); ?></a>
			</div>

		</div>

		<div class="flex <?php echo $key; ?>_template">
			<div class="cs-label center"><label for="_dlr_admin_<?php echo $key; ?>_template_code"><?php echo __("Template code", "dlr"); ?></label>  &nbsp;<span class="dlr_required_star">*</span></div>
			<div class="cs-second">
				<input class="text-left" type="text" id="_dlr_<?php echo $key; ?>_template_code" name="_dlr_admin_<?php echo $key; ?>_template_code" value="<?php echo esc_attr($options['_dlr_admin_'.$key.'_template_code']); ?>" placeholder=""/>
				<p>
				<?php echo __("Enter the ID of the SMS format that you created for the pending payment status in your SMS panel.", "dlr"); ?>
				</p>
			</div>
		</div>

		<div class="flex <?php echo $key; ?>_template">
			<div class="cs-label center"><label for="_dlr_admin_<?php echo $key; ?>_template_variables"><?php echo __("Template variables", "dlr"); ?></label> &nbsp;<span class="dlr_required_star">*</span></div>
			<div class="cs-second">
				<input class="text-left" placeholder="order_id,status,price" type="text" id="_dlr_admin_<?php echo $key; ?>_template_variables" name="_dlr_admin_<?php echo $key; ?>_template_variables" value="<?php echo esc_attr($options['_dlr_admin_'.$key.'_template_variables']); ?>" placeholder=""/>
				<p>
				<?php echo __("Enter the variables you have used in this format in the above box. Use a comma (,) after each variable. Do not use a hyphen.", "dlr"); ?>
				</p>
			</div>
		</div>

		<div class="flex mt-8 <?php echo $key; ?>_text">
			<div class="cs-label center"><label for="_dlr_admin_<?php echo $key; ?>_sms_body"><?php echo __("Sms body", "dlr"); ?>  &nbsp;<span class="dlr_required_star">*</span></label></div>
			<div class="cs-second">
				<textarea name="_dlr_admin_<?php echo $key; ?>_sms_body" id="_dlr_admin_<?php echo $key; ?>_sms_body" rows="7"><?php echo $options['_dlr_admin_'.$key.'_sms_body']; ?></textarea>

				<p>
				<?php echo __("You determine the text of the SMS that is sent to the admin in the status of this.", "dlr"); ?>
				</p>

			</div>
		</div>

		<p class="submit">
			<input type="submit" name="dlr_submit" id="submit" class="button button-primary" value="<?php echo __('Save changes', 'dlr'); ?>">
		</p>
</article>

<script>
jQuery(document).ready(function($)
{
	var key = '<?php echo $key; ?>';
	var current = '<?php echo esc_attr( $options['_dlr_admin_'.$key.'_sms_type'] ); ?>';
	$('.'+key+'_'+current).css('display', 'flex');
});
</script>