<?php $options = $GLOBALS['dlr_options']; ?>
<tr>
    <th>
        <?php echo __('Redirect from my-account', 'dlr'); ?>
    </th>
    
    <td>
		<label class="switch">
			<input name="_dlr_redirect_my_account" id="_dlr_redirect_my_account" type="checkbox" <?php checked( esc_attr($options['_dlr_redirect_my_account']), 1); ?> value="1">
			<span class="slider round"></span>
		</label>
        <p><?php echo __('With this option enabled, when the user goes to the WooCommerce login and registration page with the name my-account and is not logged in, it will be redirected to the Mobits login form.', 'dlr'); ?>
		<a title="<?php echo __('Video tutorial', 'dlr'); ?>" target="_blank" href="https://aparat.com/v/NDIvf" class="dlr-what">
			<span class="dashicons dashicons-format-video"></span> 
		</a>
		</p>
    </td>
</tr>

<tr>
    <th>
        <?php echo __('Redirect from checkout', 'dlr'); ?>
    </th>
    
    <td>
		<label class="switch">
			<input name="_dlr_redirect_checkout" id="_dlr_redirect_checkout" type="checkbox" <?php checked( esc_attr($options['_dlr_redirect_checkout']), 1); ?> value="1">
			<span class="slider round"></span>
		</label>
        <p><?php echo __('With this option enabled, when the customer goes to the checkout page and is not logged in, it will be redirected to the Mobits login form. ', 'dlr'); ?>
		<a title="<?php echo __('Video tutorial', 'dlr'); ?>" target="_blank" href="https://aparat.com/v/mcvY5" class="dlr-what">
			<span class="dashicons dashicons-format-video"></span> 
		</a>
		</p>
    </td>
</tr>

<tr>
    <th>
        <?php echo __('Must login warning', 'dlr'); ?>
        
    </th>
    
    <td>
		<label class="switch">
			<input name="_dlr_checkout_notif" id="_dlr_checkout_notif" type="checkbox" <?php checked( esc_attr($options['_dlr_checkout_notif']), 1); ?> value="1">
			<span class="slider round"></span>
		</label>
        <p><?php echo __('With this option enabled, when the user is redirected from the checkout page to the Mobits login form, a warning is displayed at the top of the form with the title You must login or register to continue the order.', 'dlr'); ?>
		<a title="<?php echo __('Video tutorial', 'dlr'); ?>" target="_blank" href="https://aparat.com/v/rn5ZI" class="dlr-what">
			<span class="dashicons dashicons-format-video"></span> 
		</a>
		</p>
    </td>
</tr>

<tr>
    <th>
        <?php echo __("Save user's mobile in woocommerce", 'dlr'); ?>
    </th>
    
    <td>
		<label class="switch">
			<input name="_dlr_save_mobile_in_woocommerce" id="_dlr_save_mobile_in_woocommerce" type="checkbox" <?php checked( esc_attr($options['_dlr_save_mobile_in_woocommerce']), 1); ?> value="1">
			<span class="slider round"></span>
		</label>
        <p><?php echo __("By activating this option, the user's mobile number is stored in the default billing and shipping address of the customer.", 'dlr'); ?>
		<a title="<?php echo __('Video tutorial', 'dlr'); ?>" target="_blank" href="https://aparat.com/v/wQiGD" class="dlr-what">
			<span class="dashicons dashicons-format-video"></span> 
		</a>
		</p>
    </td>
</tr>

<tr>
    <th>
        <?php echo __("Save user's name in woocommerce", 'dlr'); ?>
    </th>
    
    <td>
		<label class="switch">
			<input name="_dlr_save_name_in_woocommerce" id="_dlr_save_name_in_woocommerce" type="checkbox" <?php checked( esc_attr($options['_dlr_save_name_in_woocommerce']), 1); ?> value="1">
			<span class="slider round"></span>
		</label>
        <p><?php echo __("By activating this option, the user's name is stored in the default billing and shipping name field of the customer.", 'dlr'); ?>
		<a title="<?php echo __('Video tutorial', 'dlr'); ?>" target="_blank" href="https://aparat.com/v/2187l" class="dlr-what">
			<span class="dashicons dashicons-format-video"></span> 
		</a>
		</p>
    </td>
</tr>

<tr>
    <th>
        <?php echo __("Save user's family in woocommerce", 'dlr'); ?>
    </th>
    
    <td>
		<label class="switch">
			<input name="_dlr_save_family_in_woocommerce" id="_dlr_save_family_in_woocommerce" type="checkbox" <?php checked( esc_attr($options['_dlr_save_family_in_woocommerce']), 1); ?> value="1">
			<span class="slider round"></span>
		</label>
        <p><?php echo __("By activating this option, the user's family is stored in the default billing and shipping family field of the customer.", 'dlr'); ?></p>
    </td>
</tr>

<tr>
	<th class="dlr_field_base"><?php echo __("The commenter's name in the product comments section", "dlr"); ?></th>

	<td>
		<fieldset>
			<select id="_dlr_review_author" name="_dlr_review_author">
				<option value="empty" <?php selected( esc_attr($options['_dlr_review_author']) , 'empty' ); ?>><?php echo __('Empty', 'dlr'); ?></option>
				<option value="user_login" <?php selected( esc_attr($options['_dlr_review_author']) , 'user_login' ); ?>><?php echo __('Username (Mobile)', 'dlr'); ?></option>
				<option value="name_family" <?php selected( esc_attr($options['_dlr_review_author']) , 'name_family' ); ?>><?php echo __('Name-family', 'dlr'); ?></option>
				<option value="user" <?php selected( esc_attr($options['_dlr_review_author']) , 'user' ); ?>><?php echo __('site user', 'dlr'); ?></option>
				<option value="customer" <?php selected( esc_attr($options['_dlr_review_author']) , 'customer' ); ?>><?php echo __('customer', 'dlr'); ?></option>
			</select>
		</fieldset>
		<p><?php echo __("The fOn the WooCommerce product page and the customer comments section, if a user is logged in and posts a comment, the user's username or mobile number will be displayed. You can change this using this option.", 'dlr'); ?> </p>
	</td>
</tr>

<script>
jQuery(document).ready(function($){
	$('#_dlr_review_author').select2({minimumResultsForSearch: -1});
})
</script>

<tr>
    <th>
        <?php echo __("Make email optional in the billing address", 'dlr'); ?>
    </th>
    
    <td>
		<label class="switch">
			<input name="_dlr_checkout_billing_email_optional" id="_dlr_checkout_billing_email_optional" type="checkbox" <?php checked( esc_attr($options['_dlr_checkout_billing_email_optional']), 1); ?> value="1">
			<span class="slider round"></span>
		</label>
        <p><?php echo __("Make email optional in the billing address
The email field in the billing address on the WooCommerce checkout page becomes optional.", 'dlr'); ?>
		</p>
    </td>
</tr>
