<?php
defined('ABSPATH') || die;

class Dlr_action_scheduler extends Mobits
{
	public function __construct ()
	{
		add_action( 'dlr_send_message', ['Dlr_Sms', 'send_sms'], 10, 2);
		add_action( 'dlr_send_message_template', ['Dlr_Sms', 'send_sms_template'], 10, 6);
		add_filter( 'cron_schedules', [$this, 'cron_schedules'] );
		add_action( 'dlr_delete_extra_code', [$this, 'dlr_delete_extra_code']);
		add_action( 'dlr_delete_sendsms_report', [$this, 'dlr_delete_sendsms_report']);
		add_action( 'dlr_delete_wrongcodes_report', [$this, 'dlr_delete_wrongcodes_report']);

		$this->run();
	}

	public function cron_schedules( $schedules ) 
	{
		$schedules[ 'dlr_delete_extra_code_interval' ] = array(
			'interval' => 86400,
			'display'  => __( 'Delete extra code every 24 hours', 'dlr' ),
		);
		
		$ssr = isset( $_POST['dlr_delete_sendsms_report'] ) ? $_POST['dlr_delete_sendsms_report'] : (int) get_option('dlr_delete_sendsms_report', -1);
        $schedules[ 'dlr_delete_sendsms_report_interval' ] = array(
			'interval' => $ssr * 60 * 60,
			'display'  => __( 'Delete extra send sms every 24 hours', 'dlr' ),
		);
	    
		$wcr = isset( $_POST['dlr_delete_wrongcodes_report'] ) ? $_POST['dlr_delete_wrongcodes_report'] : (int) get_option('dlr_delete_wrongcodes_report', -1);
		$schedules[ 'dlr_delete_wrongcode_report_interval' ] = array(
			'interval' => $wcr * 60 * 60,
			'display'  => __( 'Delete extra wrong codes every 24 hours', 'dlr' ),
		);
		return $schedules;
	}

	public function dlr_delete_extra_code ()
	{
		parent::$wpdb->query("TRUNCATE TABLE ".parent::$table);
	}

	public function dlr_delete_sendsms_report ()
	{
		$table = parent::$wpdb->prefix . 'dlr_send_sms';
		parent::$wpdb->query( "TRUNCATE TABLE $table" );
	}

	public function dlr_delete_wrongcodes_report ()
	{
		$table = parent::$wpdb->prefix . 'dlr_wrong_codes';
		parent::$wpdb->query( "TRUNCATE TABLE $table" );
	}

	public function run ()
	{
	}
}