<?php

class Dlr_Activator {

	public static function activate() 
	{
	    self::activation();
		self::tables();
        self::options();
		self::upgrade();
        
	    add_rewrite_endpoint( get_option('_dlr_page_slug', 'login-register'), EP_ROOT );
        flush_rewrite_rules();

		add_option('mobits_activate_redirect', true);
	}
	
	static function encrypt_decrypt($action, $string) 
    {
        $output = false;
        $encrypt_method = "AES-256-CBC";
        $secret_key = 'm_sMU?^qS!;3v}k8B<';
        $secret_iv = 'm_sU?^qS!;3vk<';
        $key = hash('sha256', $secret_key);
    
        $iv = substr(hash('sha256', $secret_iv), 0, 16);
        if ( $action == 'encrypt' ) 
        {
            $output = openssl_encrypt($string, $encrypt_method, $key, 0, $iv);
            $output = base64_encode($output);
        } 
        else if( $action == 'decrypt' ) 
        {
            $output = openssl_decrypt(base64_decode($string), $encrypt_method, $key, 0, $iv);
        }
        return $output;
    }
	
	static function activation()
	{
	   $post = [ 
	        'key'           => 'q>K#GSSw43[s^v~f,ZF%', 
	        'domain'        => preg_replace('/^www\./', '', $_SERVER['SERVER_NAME']),
	        'product_id'    => 6240
	    ];
	   
	    $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL,'https://check.li3nce.ir/api/checkDomain');
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post));
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        $result = json_decode($response);
        curl_close($ch);
        
        if( $result == 101 ) 
        {
            update_option('dlr_li3nce', self::encrypt_decrypt('encrypt',  preg_replace('/^www\./', '', $_SERVER['SERVER_NAME']) ) );
            update_option('_dlr_login_status', 1);
            update_option('_dlr_register_status', 1);
            
            if ( get_option('_dlr_resend_code_time', '') == '' )
                update_option( '_dlr_resend_code_time', 120 );
        }
        else {
            die('<div style="text-align: right">شما مجاز به نصب موبیتس نمی باشید. لطفا دامنه خود را در پنل کاربری سایتی که موبیتس را ازآن تهیه کرده اید وارد نمایید</div>');
        }
	}

	static function tables()
	{
		global $wpdb, $charset_collate;
        $table = $wpdb->prefix . "dlr_activation";
		$send_sms_table 		= $wpdb->prefix . "dlr_send_sms";
		$wrong_codes_table 		= $wpdb->prefix . "dlr_wrong_codes";
		$blocked_mobile_numbers_table = $wpdb->prefix . "dlr_blocked_mobile_numbers";
		require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
         
        $query = "CREATE TABLE IF NOT EXISTS $table (
        id int(11) NOT NULL AUTO_INCREMENT,
        code varchar(255) CHARACTER SET utf8 NOT NULL,
        mobile varchar(255) CHARACTER SET utf8 NOT NULL,
        time varchar(255) CHARACTER SET utf8 NOT NULL,
        PRIMARY KEY (id)
        ) $charset_collate;";

        dbDelta( $query );

		$query2 = "CREATE TABLE IF NOT EXISTS $send_sms_table (
        id int(11) NOT NULL AUTO_INCREMENT,
        webservice varchar(255) CHARACTER SET utf8 NOT NULL,
        template varchar(255) CHARACTER SET utf8 NOT NULL,
        time datetime NOT NULL,
		receiver varchar(255) CHARACTER SET utf8 NOT NULL,
		status varchar(255) CHARACTER SET utf8 NOT NULL,
        PRIMARY KEY (id)
        ) $charset_collate;";
		
        dbDelta( $query2 );

		$query3 = "CREATE TABLE IF NOT EXISTS $wrong_codes_table (
        id int(11) NOT NULL AUTO_INCREMENT,
        webservice varchar(255) CHARACTER SET utf8 NOT NULL,
        template varchar(255) CHARACTER SET utf8 NOT NULL,
        time datetime NOT NULL,
		receiver varchar(255) CHARACTER SET utf8 NOT NULL,
        PRIMARY KEY (id)
        ) $charset_collate;";
		
        dbDelta( $query3 );

		$query4 = "CREATE TABLE IF NOT EXISTS $blocked_mobile_numbers_table (
        id bigint(20) NOT NULL AUTO_INCREMENT,
        name varchar(255) CHARACTER SET utf8 NOT NULL,
        family varchar(255) CHARACTER SET utf8 NOT NULL,
		mobile varchar(255) CHARACTER SET utf8 NOT NULL,
        PRIMARY KEY (id)
        ) $charset_collate;";
		
        dbDelta( $query4 );
	}

	static function options()
	{
		$options = array(
            '_dlr_login_status'     => 1,
            '_dlr_register_status'  => 1,
            '_dlr_page_slug'        => 'login-register',
            '_dlr_redirect_url'     => home_url(),
            '_dlr_auto_confirm'     => 1,
            '_dlr_color'            => '#9199e4',
            '_dlr_color_tab'        => '#9199e4',
            '_dlr_sms_service'      => 'ippanel',
            '_dlr_redirect_logout'  => home_url(),
            '_dlr_background_image' => home_url() . '/wp-content/plugins/mobits/public/images/bg.jpg',
            '_dlr_design_type'      => 'modern',
            '_dlr_button_image'     => 1,
			'_dlr_form_width'		=> 380,
            '_dlr_logo'             => home_url() . '/wp-content/plugins/mobits/public/images/mobits.png',
            '_dlr_resend_code_time' => 120,
			'_dlr_update_notice_in_admin_bar' 		=> 1,
			'_dlr_name_field_in_register_status' 	=> 1,
			'_dlr_login_with_mobile'				=> 1,
			'_dlr_support_woocommerce'				=> 1,
			'_dlr_redirect_checkout'				=> 1,
			'_dlr_review_author'                    => 'user_login',
			'_dlr_limit_wrong_code'                 => '0',
			'_dlr_password_rules_required'          => 1,
			'_dlr_password_rules_ten_character'     => 1,
			'_dlr_password_rules_one_letter'        => 1,
			'_dlr_password_rules_one_specials'      => 1,
			'_dlr_number_of_codes'      			=> 4,
			'_dlr_return_back_btn_text'      		=> 'برگشت به سایت',
			'_dlr_login_priority'					=> 'mobile',
			'_dlr_email_field_required_in_register' => 1,
			'_dlr_welcome_sms_type'					=> 'text',
			'_dlr_welcome_sms_template_name_replace'=> 'مشتری'
        );

		foreach ( self::return_woo_statuses() as $key=>$status ) 
		{
			$options['_dlr_'.$key.'_sms_type'] = 'text';
			$options['_dlr_admin_'.$key.'_sms_type'] = 'text';
		}
        
        foreach($options as $key=>$value) 
        {
            if ( get_option($key, 11111) == 11111 ) 
            {
                add_option($key, $value);
            }
        }
	}

	private static function return_woo_statuses ()
	{
		if ( ! is_plugin_active( 'woocommerce/woocommerce.php') ) return [];
		
		$statuses = wc_get_order_statuses();
		
		$arr = [];
		foreach ( $statuses as $key2=>&$status ) 
		{
			if ( $key2 == 'wc-on-hold' ) $key = 'onhold';
			else if ( $key2 == 'wc-checkout-draft' ) $key = 'draft';
			else $key = $key2;

			$key = str_replace("wc-", "", $key);
			$key = str_replace("-", "_", $key);

			$arr[$key] = $status;
		}

		return $arr;
	}

	static function upgrade()
	{
		self::send_sms_table_result_column();
	}

	static function send_sms_table_result_column()
	{
		global $wpdb;
		$send_sms_table = $wpdb->prefix . "dlr_send_sms";

		$result = $wpdb->query("SHOW FULL COLUMNS FROM $send_sms_table;");
		
		$x = 0;
		foreach ( $wpdb->last_result as $result ) 
		{
			if ( $result->Field == 'result' ) $x = 1;
		}

		if ( $x == 0 ) {
			$wpdb->query("ALTER TABLE $send_sms_table ADD result longtext COLLATE utf8_general_ci;");
		}
	}

}
