<?php
class Dlr_Shortcodes extends Mobits
{
	public function __construct()
	{
		$this->init();
	}

	public function init()
	{
		add_shortcode( 'go_mobits', 	[$this, 'dlr_go_mobits_shortcode'] );
		add_shortcode( 'mobits_button', [$this, 'dlr_mobits_button_shortcode'] );
		add_shortcode( 'mobits_user', 	[$this, 'dlr_mobits_user_shortcode'] );

		add_action( 'template_redirect',[$this, 'dlr_template_redirect'] );
	}

	public function dlr_go_mobits_shortcode($atts){}

	public function dlr_template_redirect()
	{
		global $post;
		$regex = get_shortcode_regex();
		if(!isset($post->post_content)) return true;
        preg_match_all('/'.$regex.'/',$post->post_content,$matches);
        
        if( !empty($matches[2]) && in_array('go_mobits', $matches[2]) && !is_user_logged_in() )
        {
            global $wp;
            $key = array_search('go_mobits', $matches[2]);
            $back = $matches[3][$key] !== '' ? '?'.trim($matches[3][$key]) : '?back='.home_url( $wp->request );
            wp_redirect(home_url() .'/'. get_option('_dlr_page_slug', 'dlr-login-register') . $back);
            exit;
        }
	}

	public function dlr_mobits_button_shortcode($atts)
	{
		if( is_admin() ) return;

		ob_start();

		$options = parent::get_options([
			'mobits_button_panel_link',
			'mobits_button_logined_text',
			'mobits_button_logout_text',
			'mobits_button_color',
			'mobits_button_background',
			'mobits_button_fontsize',
			'mobits_button_padding',
			'mobits_button_border',
			'mobits_button_submenu',
			'mobits_button_submenu_align'
		]);

		$login_link = home_url() .'/'. get_option('_dlr_page_slug', 'dlr-login-register');


		/* panel link */
		if ( isset( $atts['panel_link'] ) && $atts['panel_link'] != '' )
		{
			$panel_link = $atts['panel_link'];
		}
		else if ( $options['mobits_button_panel_link'] != '' ) 
		{
			$panel_link = $options['mobits_button_panel_link'];
		}
		else 
		{
			$panel_link = home_url() .'/my-account';
		}

		$link 	= is_user_logged_in() ? $panel_link : $login_link;


		/* logout text */
		if ( isset( $atts['logout_text'] ) && $atts['logout_text'] != '' )
		{
			$logout_text = $atts['logout_text'];
		}
		else if ( $options['mobits_button_logout_text'] != '' ) 
		{
			$logout_text = $options['mobits_button_logout_text'];
		}
		else 
		{
			$logout_text = __('Login/Register', 'dlr');
		}

		/* login text */
		if ( isset( $atts['login_text'] ) && $atts['login_text'] != '' )
		{
			$login_text = $atts['login_text'];
		}
		else if ( $options['mobits_button_logined_text'] != '' ) 
		{
			$login_text = $options['mobits_button_logined_text'];
		}
		else 
		{
			$login_text = __('Dashboard', 'dlr');
		}

		$text = is_user_logged_in() ? $login_text : $logout_text;

		$font_size 	= $options['mobits_button_fontsize'] !='' ? $options['mobits_button_fontsize'] : '16px';
		$border 	= $options['mobits_button_border'] !='' ? $options['mobits_button_border'] : '1px solid #aaa';
		$padding 	= $options['mobits_button_padding'] !='' ? $options['mobits_button_padding'] : '8px 15px';

		/* color */
		if ( isset( $atts['color'] ) && $atts['color'] != '' )
		{
			$color = $atts['color'];
		}
		else if ( $options['mobits_button_color'] != '' ) 
		{
			$color = $options['mobits_button_color'];
		}
		else 
		{
			$color = '#fff';
		}

		/* background */
		if ( isset( $atts['bg_color'] ) && $atts['bg_color'] != '' )
		{
			$bg_color = $atts['bg_color'];
		}
		else if ( $options['mobits_button_background'] != '' ) 
		{
			$bg_color = $options['mobits_button_background'];
		}
		else 
		{
			$bg_color = 'teal';
		}

		if ( $options['mobits_button_submenu'] ) 
		{
			if ( is_user_logged_in() ) 
			{
				$user = get_user_by('id', get_current_user_id() );
				echo '<div class="dlr_lr_button mdlr" onclick="dlrm_hide_show_submenu()"><div class="dlr_lr_button_text mdlr">
				<svg class="mdlr" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="'.$font_size.'" viewBox="0 0 256 256" xml:space="preserve"> <defs class="mdlr"> </defs> <g class="mdlr" fill="#fff" transform="translate(1.4065934065934016 1.4065934065934016) scale(2.81 2.81)" > <path class="mdlr" d="M 83.926 90 H 6.074 v -3 c 0 -21.464 17.462 -38.926 38.926 -38.926 S 83.926 65.536 83.926 87 V 90 z M 12.209 84 H 77.79 C 76.27 67.246 62.144 54.074 45 54.074 S 13.731 67.246 12.209 84 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: '.$color.'; fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round" /> <path class="mdlr" d="M 45 44.134 c -12.168 0 -22.067 -9.899 -22.067 -22.067 S 32.832 0 45 0 c 12.167 0 22.066 9.899 22.066 22.067 S 57.167 44.134 45 44.134 z M 45 6 c -8.859 0 -16.067 7.208 -16.067 16.067 S 36.141 38.134 45 38.134 s 16.066 -7.208 16.066 -16.067 S 53.859 6 45 6 z" style="stroke: none; stroke-width: 1; stroke-dasharray: none; stroke-linecap: butt; stroke-linejoin: miter; stroke-miterlimit: 10; fill: '.$color.'; fill-rule: nonzero; opacity: 1;" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round" /> </g> </svg> <span class="mdlr">'. $login_text .'</span></div>';
				echo '<div class="dlr_lr_button_submenu">
				<ul class="mdlr">
					<li class="mdlr"><a class="mdlr" href="'.$panel_link.'">'.$user->user_login.' </a></li>';

					if ( class_exists( 'WooCommerce' ) ) {
						foreach( wc_get_account_menu_items() as $key=>$item )
						{
							if ( $key != 'dashboard' ) 
							{
								$link = $key == 'customer-logout' ? wp_logout_url() : $panel_link .'/'. $key;
								echo '<li class="mdlr"><a class="mdlr" href="'.$link.'">'.$item.'</a></li>';
							}
								
						}
					}
					else {
						echo '<li><a href="'.wp_logout_url().'">'.__("Log out", "dlr").'</a></li>';
					}
					
				echo '</ul>
				</div>';
				echo '</div>';

			echo 
			'<script>
			
			function dlrm_hide_show_submenu ()
			{
				var el = document.querySelector(".dlr_lr_button_submenu");
				var el2 = document.querySelector(".dlr_lr_button_text");

				if ( el.classList.contains("show") )
				{
					el.classList.remove("show");
					el.classList.add("hide");

				 	el2.classList.remove("active");
				} 
				else 
				{
					el.classList.remove("hide");
					el.classList.add("show");

					el2.classList.add("active");
				}
			}

			document.onclick = function(e) 
			{

				if( e.target.getAttribute("class") != "dlr_lr_button mdlr" && e.target.getAttribute("class") != "mdlr" && e.target.getAttribute("class") != "dlrm_arrow_button mdlr" && e.target.getAttribute("class") != "dlr_lr_button_text mdlr" && e.target.getAttribute("class") != "dlr_lr_button_text mdlr active" && e.target.getAttribute("class") != "mdlr" )
				{
					var el = document.querySelector(".dlr_lr_button_submenu");
					var el2 = document.querySelector(".dlr_lr_button_text");

					el.classList.remove("show");
					el.classList.add("hide");

					el2.classList.remove("active");
				} 
			}
			
			</script>
			
			<style>
			.dlr_lr_button {
				padding: 0 !important;
			}

			.dlr_lr_button .dlr_lr_button_text {
				
			}

			.dlr_lr_button {
				// border: none !important;
			}

			</style>
			
			';

			
			}

			else {
				echo '<a class="dlr_lr_button" href="'.$link.'">'.$text.'</a>';
			}
		}
		else {
			echo '<a class="dlr_lr_button" href="'.$link.'">'.$text.'</a>';
		}

		$align = $options['mobits_button_submenu_align'] == 'left' ? 'left: 0;' : 'right: 0;';

		echo '<style>
		.dlr_lr_button {
			font-weight: bold;
			background: '.$bg_color.';
			color: '.$color.' !important;
			text-decoration: none;
			padding: '.$padding.' !important;
			border: '.$border.';
			font-family: inherit;
			border-radius: 5px;
			font-size: '.$font_size.';
			display: inline-block;
			width: auto !important;
			text-decoration: none !important;
			cursor: pointer;
			position: relative;
		}
		.dlr_lr_button .dlrm_arrow_button {
			font-size: 21px;
			position: absolute;
			transform: rotate(-90deg);
			top: 11px !important;
			margin-right: 10px;
			left: 10px;
		}
		.dlr_lr_button_submenu {
			position: absolute;
			background: #fff;
			box-shadow: 0 1px 1px rgba(0,0,0,.14), 0 4px 8px rgba(0,0,0,.3);
			width: 256px;
			'.$align.'
			border-radius: 5px;
			padding-bottom: 7px;
			display: none;
			top: 42px;
		}
		.dlr_lr_button_submenu.show {
			display: block;
		}
		.dlr_lr_button_submenu ul {
			padding: 0;
			margin: 0;
			margin-top: 10px;
			width: 100%;
			z-index: 999999999999999999999;
            position: relative;
            background: #fff;
		}
		.dlr_lr_button_submenu li {
			list-style: none;
			display: block
		}
		.dlr_lr_button_submenu a {
			text-decoration: none !important;
			color: #3f4064 !important;
			font-size: 16px;
			padding: 10px 15px;
			display: block;
			position: relative;
			transition: .3s;
		}
		.dlr_lr_button_submenu a:hover {
		    color: #3f4064 !important;
		}
		.dlr_lr_button_submenu li:first-child {
			border-bottom: 1px solid #ccc;
			margin-bottom: 5px;
		}

		.dlr_lr_button_submenu li:first-child a span {
			position: absolute;
			left: 15px;
			font-size: 22px;
			top: 7px;
		}
		.dlr_lr_button_submenu a:hover {
			background: #eee;
			transition: .3s;
		}
		.dlrm_arrow_button.type2 {
			transform: none;
			top: 6px;
		}
		.dlr_lr_button_text span {
            font-size: 16px;
            position: relative;
            top: 0px;
            margin-right: 4px;
		}
		.dlr_lr_button_text svg{
		    position: relative;
            top: 4px;
		}
		</style>';
		
		return ob_get_clean();
	}

	public static function dlr_mobits_user_shortcode($atts)
	{
		ob_start();

		$id = isset( $atts['id'] ) && $atts['id'] != "" ? $atts['id'] : get_current_user_id();
		$user = get_user_by( 'id', $id);

		$type = isset( $atts['type'] ) ? $atts['type'] : 'name';
		switch($type)
		{
			case 'name' :
				$name = $user->first_name .' '. $user->last_name;
				if ( trim($name) == '' && isset($atts['noname']) && $atts['noname'] != '' )
					echo $atts['noname'];
				else
					echo $name;
				break;

			case 'email' :
				$email = $user->user_email;
				if ( $email == '' && isset($atts['noemail']) && $atts['noemail'] != '' )
					echo $atts['noemail'];
				else
					echo $email;
				break;

			case 'mobile' :
				$mobile = parent::return_mobile($id);
				if ( $mobile == false && isset($atts['nomobile']) && $atts['nomobile'] != '' )
					echo $atts['nomobile'];
				else
					echo $mobile;
				break;
		}

		return ob_get_clean();
	}
}