<?php
defined('ABSPATH') || die;

class Dlr_Sms
{
	public static function send_sms($mobile, $body, $service='')
	{
		if ( $service == '' ) 
			$service = get_option('_dlr_sms_service', 'ippanel');

		self::{'send_'.$service}($mobile, $body);
	}

	public static function send_sms_template ( $mobile, $template, $service, $type='order', $args = [], $admin = 0 )
	{
		if ( $service == '' ) 
			$service = get_option('_dlr_sms_service', 'ippanel');

		self::{'send_'.$service.'_template'}($mobile, $template, $type, $args, $admin);
	}

	private static function save_report($webservice, $template, $mobile, $status, $result)
	{
		// Stop if option is disabled;
		if ( get_option("_dlr_webservice_reports") != 1 ) return;

		// Save report
		global $wpdb;
		date_default_timezone_set('Asia/Tehran');
		$wpdb->insert( $wpdb->prefix . 'dlr_send_sms' ,
		[
			'webservice' 	=> $webservice,
			'template' 		=> $template,
			'time' 			=> date('Y/m/d H:i:s'),
			'receiver' 		=> $mobile,
			'status' 		=> $status,
			'result' 		=> $result
		]);
	}

	public static function send_smsir($mobile, $body)
	{
		$mobile = is_array( $mobile ) ? $mobile : [$mobile];

		$params = [
			'lineNumber' 	=> get_option( '_dlr_sms_smsir_sender', '30007732008937' ),
			'messageText'	=> $body,
			"mobiles"		=> $mobile,
			"sendDateTime"	=> null
		];

		$curl = curl_init();
		curl_setopt_array($curl, array(
		CURLOPT_URL => 'https://api.sms.ir/v1/send/bulk',
		CURLOPT_RETURNTRANSFER => true,
		CURLOPT_ENCODING => '',
		CURLOPT_MAXREDIRS => 10,
		CURLOPT_TIMEOUT => 0,
		CURLOPT_FOLLOWLOCATION => true,
		CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		CURLOPT_CUSTOMREQUEST => 'POST',
		CURLOPT_POSTFIELDS => json_encode($params),
		CURLOPT_HTTPHEADER => array(
				'X-API-KEY: '.get_option("_dlr_sms_smsir_secretKey"),
				'Content-Type: application/json'
			),
		));

		$response = json_decode( curl_exec( $curl ) );
		$status = $response->status == 1 ? 1 : 0;
		self::save_report( 'smsir', $body, $mobile, $status, $response->message );
		curl_close($curl);
	}

	public static function send_melipayamak ($mobile, $body)
	{
		$mobile = (array) $mobile;
	
		$username = get_option("_dlr_sms_melipayamak_username");
		$password = get_option("_dlr_sms_melipayamak_password");

		foreach ( $mobile as $mob ) 
		{
			$data = array(
				'username' 	=>	$username,
				'password'	=>	$password,
				'to' 		=>	$mob,
				'from' 		=>  get_option("_dlr_sms_melipayamak_sender"),
				'text' 		=>  $body
			);

			$post_data = http_build_query($data);
			$handle = curl_init('https://rest.payamak-panel.com/api/SendSMS/SendSMS');
			curl_setopt($handle, CURLOPT_HTTPHEADER, array(
				'content-type' => 'application/x-www-form-urlencoded'
			));
			curl_setopt($handle, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($handle, CURLOPT_SSL_VERIFYHOST, false);
			curl_setopt($handle, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($handle, CURLOPT_POST, true);
			curl_setopt($handle, CURLOPT_POSTFIELDS, $post_data);

			$server_output = json_decode(curl_exec($handle));

			// Save report
			$status = $server_output->RetStatus == 1 ? 1 : 0;
			$value = $status == 1 ? 1 : $server_output->Value;

			self::save_report( 'melipayamak', $body, $mob, $status, self::melipayamak_status($value) );
		}
	}

	public static function send_farapayamak ($mobile, $body)
	{
		$username = get_option("_dlr_sms_farapayamak_username");
		$password = get_option("_dlr_sms_farapayamak_password");

		$mobile = (array) $mobile;

		foreach( $mobile as $mob ) 
		{
			$data = array(
				'username' 	=>	$username,
				'password'	=>	$password,
				'to' 		=>	$mob,
				'from' 		=>  get_option("_dlr_sms_farapayamak_sender"),
				'text' 		=>  $body
			);

			$post_data = http_build_query($data);
			$handle = curl_init('https://rest.payamak-panel.com/api/SendSMS/SendSMS');
			curl_setopt($handle, CURLOPT_HTTPHEADER, array(
				'content-type' => 'application/x-www-form-urlencoded'
			));
			curl_setopt($handle, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($handle, CURLOPT_SSL_VERIFYHOST, false);
			curl_setopt($handle, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($handle, CURLOPT_POST, true);
			curl_setopt($handle, CURLOPT_POSTFIELDS, $post_data);

			$server_output = json_decode(curl_exec($handle));

			// Save report
			$status = $server_output->RetStatus == 1 ? 1 : 0;
			$value = $status == 1 ? 1 : $server_output->Value;

			self::save_report( 'farapayamak', $body, $mob, $status, self::melipayamak_status($value) );

		}
	}

	public static function send_payamito ($mobile, $body)
	{
		$username = get_option("_dlr_sms_payamito_username");
		$password = get_option("_dlr_sms_payamito_password");

		$mobile = (array) $mobile;

		foreach( $mobile as $mob ) 
		{
			$data = array(
				'username' 	=>	$username,
				'password'	=>	$password,
				'to' 		=>	$mob,
				'from' 		=>  get_option("_dlr_sms_payamito_sender"),
				'text' 		=>  $body
			);

			$post_data = http_build_query($data);
			$handle = curl_init('https://rest.payamak-panel.com/api/SendSMS/SendSMS');
			curl_setopt($handle, CURLOPT_HTTPHEADER, array(
				'content-type' => 'application/x-www-form-urlencoded'
			));
			curl_setopt($handle, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($handle, CURLOPT_SSL_VERIFYHOST, false);
			curl_setopt($handle, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($handle, CURLOPT_POST, true);
			curl_setopt($handle, CURLOPT_POSTFIELDS, $post_data);

			$server_output = json_decode(curl_exec($handle));

			// Save report
			$status = $server_output->RetStatus == 1 ? 1 : 0;
			$value = $status == 1 ? 1 : $server_output->Value;

			self::save_report( 'payamito', $body, $mob, $status, self::melipayamak_status($value) );
		}
	}

	public static function melipayamak_status($value)
	{
		switch($value)
		{
			case "-7":
				return "خطایی در شماره فرستنده رخ داده است با پشتیبانی تماس بگیرید";
				break;
			case "-6":
				return "خطای داخلی رخ داده است با پشتیبانی تماس بگیرید";
				break;
			case "-5":
				return "متن ارسالی باتوجه به متغیرهای مشخص شده در متن پیشفرض همخوانی ندارد";
				break;
			case "-4":
				return "کد متن ارسالی صحیح نمی‌باشد و یا توسط مدیر سامانه تأیید نشده است";
				break;
			case "-3":
				return "خط ارسالی در سیستم تعریف نشده است، با پشتیبانی سامانه تماس بگیرید";
				break;
			case "-2":
				return "محدودیت تعداد شماره، محدودیت هربار ارسال یک شماره موبایل می‌باشد";
				break;
			case "-1":
				return "دسترسی برای استفاده از این وبسرویس غیرفعال است. با پشتیبانی تماس بگیرید";
				break;
			case "0":
				return "نام کاربری یا رمزعبور صحیح نمی‌باشد";
				break;
			case "2":
				return "اعتبار کافی نمی‌باشد";
				break;
			case "6":
				return "سامانه درحال بروزرسانی می‌باشد";
				break;
			case "7":
				return "متن حاوی کلمه فیلتر شده می‌باشد، با واحد اداری تماس بگیرید";
				break;
			case "10":
				return "کاربر موردنظر فعال نمی‌باشد";
				break;
			case "11":
				return "ارسال نشده";
				break;
			case "12":
				return "مدارک کاربر کامل نمی‌باشد";
				break;
			case "35":
				return "وجود شماره موبایل گیرنده در لیست سیاه مخابرات";
				break;
			case "1":
				return "با موفقیت ارسال گردید";
				break;
			default: 
				return "خطای نامشخص";
		}
	}

	public static function send_ippanel ($mobile, $body)
	{
		$mobile = (array) $mobile;

		$url = "https://ippanel.com/services.jspd"; 

		foreach( $mobile as $mob ) 
		{
			$rcpt_nm = array($mob); 
			$param = array ( 
				'uname'		=>	get_option('_dlr_sms_ippanel_username', '' ),
				'pass'		=>	get_option('_dlr_sms_ippanel_password', '' ),
				'from'		=>	get_option('_dlr_sms_ippanel_from', '' ),
				'message'	=>	$body,
				'to'		=>	json_encode($rcpt_nm),
				'op'		=>	'send'
			);
			
			$handler = curl_init($url);             
			curl_setopt($handler, CURLOPT_CUSTOMREQUEST, "POST");
			curl_setopt($handler, CURLOPT_POSTFIELDS, $param);                       
			curl_setopt($handler, CURLOPT_RETURNTRANSFER, true);
			
			$output = curl_exec($handler);

			$status = is_numeric($output[1]) ? 1 : 0;
			self::save_report( 'ippanel', $body, $mob, $status, self::ippanel_status( json_decode($output) ) );

			curl_close($handler);
		}
	}

	private static function ippanel_status($output)
	{
		if ( $output == '' ) return "شناسه قالب نامعتبر می باشد.";
		if ( is_numeric ($output) ) return "پیامک با موفقیت ارسال گردید.";

		if ( !is_array($output) ) return "خطای نامشخص، لطفا با پشتیبانی تماس بگیرید.";

		switch($output[0])
		{
			case "0":
				return "با موفقیت ارسال شد.";
				break;
			case "2":
				return "کاربر محدود گردیده است.";
				break;
			case "3":
				return "خط به شما تعلق ندارد.";
				break;
			case "5":
				return "اعتبار کافی نیست.";
				break;
			case "9":
				return "خط مورد نظر در این ساعت امکان ارسال ندارد.";
				break;
			case "99":
				return "اپراتور خط ارسالی قطع می‌باشد.";
				break;
			case "301":
				return "از حرف ویژه در نام کاربری استفاده گردیده است.";
				break;
			case "303":
				return "نام کاربری وارد نگردیده است.";
				break;
			case "305":
				return "نام کاربری وارد نگردیده است.";
				break;
			case "317":
				return "کلمه عبور وارد نشده است.";
				break;
			case "962":
				return "نام کاربری یا کلمه عبور نادرست می باشد.";
				break;
			case "971":
				return "پترن ارسالی نامعتبر است.";
				break;
			case "970":
				return "پارامتر های ارسالی برای پترن نامعتبر است.";
				break;
			case "994":
				return "لطفا تصویری از کارت بانکی خود را از منو مدارک ارسال کنید";
				break;
			case "998":
				return "کارت ملی یا کارت بانکی شما تایید نشده است.";
				break;
			default: 
				return "خطای نامشخص";
		}
	}

	public static function send_payamresan ($mobile, $body) 
	{
	    $mobile = (array) $mobile;
	    
		foreach ( $mobile as $mob )
		{
			$params = array(
				'ApiKey' 		=>	get_option('_dlr_sms_payamresan_accessKey'),
				'Text'			=>  $body,
				'Sender' 		=>  get_option('_dlr_sms_payamresan_sender'),
				'Recipients' 	=>  $mob,
			);

			$BaseUrl = "http://api.sms-webservice.com/api/V3/";
			$url = $BaseUrl.'Send?' . http_build_query($params);
			$curl = curl_init();
			curl_setopt_array($curl, array(
				CURLOPT_URL => $url,
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING => '',
				CURLOPT_MAXREDIRS => 10,
				CURLOPT_TIMEOUT => 0,
				CURLOPT_FOLLOWLOCATION => true,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_CUSTOMREQUEST => 'GET',
			));
			$response = json_decode( curl_exec($curl) );
			curl_close($curl);

			// Save report
			$status = $response->Success == true ? 1 : 0;
			$result = $response->Success == true ? __('Message sended successfully', 'dlr') : $response->Error;
			self::save_report( 'payamresan', $body, $mob, $status, $result);
		}
	}

	public static function send_kavenegar ($mobile, $body) 
	{
	    $mobile = (array) $mobile;
	    
		foreach( $mobile as $mob ) 
		{
			$message 	= urlencode( $body );
			$key 		= get_option('_dlr_sms_kavenegar_apikey');
			$url 		= "https://api.kavenegar.com/v1/".$key."/sms/send.json?receptor=".$mob."&message=".$message;

			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, $url);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			$response = json_decode( curl_exec($ch) );

			// Save report
			$status = $response->return->status == 200 ? 1 : 0;
			$result = $response->return->status == 200 ? __('Message sended successfully', 'dlr') : $response->return->message;
			self::save_report( 'kavenegar', $body, $mob, $status, $result);

			curl_close($ch);
		}
		
	}

	private static function return_status ($status)
	{
		switch ($status)
		{
			case 'pending':
				return __('Pending', 'dlr');
				break;
			case 'processing':
				return __('Processing', 'dlr');
				break;
			case 'onhold':
				return __('Onhold', 'dlr');
				break;
			case 'completed':
				return __('Completed', 'dlr');
				break;
			case 'cancelled':
				return __('Cancelled', 'dlr');
				break;
			case 'refunded':
				return __('Refunded', 'dlr');
				break;
			case 'failed':
				return __('Failed', 'dlr');
				break;
			case 'draft':
				return __('Draft', 'dlr');
				break;
		}
	}

	private static function return_welcome_variables( $template, $mobile, $args )
	{
		if ($template == '') return [];

		$variables = get_option('_dlr_welcome_sms_template_variables', '');
		if ($variables == '') return [];

		$variables = explode(",", $variables);

		$values = [];
		foreach ( $variables as $variable ) 
		{
			switch ( $variable ) 
			{
				case 'name':
					$name = $args['name'] == '' ? get_option('_dlr_welcome_sms_template_name_replace', '') : $args['name'];
					$values[] = ['name' => 'name', 'value' => $name ];
					break;

				case 'family':
					$values[] = ['name' => 'family', 'value' => $args['family'] ];
					break;
				
				case 'mobile':
					$values[] = ['name' => 'mobile', 'value' => $mobile];
					break;

				case 'email':
					$values[] = ['name' => 'email', 'value' => $args['email'] ];
					break;

				case 'password':
					$values[] = ['name' => 'password', 'value' => $args['password'] ];
					break;
			}
		}
		return $values;
	}

	public static function send_payamresan_template ( $mobile, $template, $type, $args, $admin ) 
	{
	    $mobile = (array) $mobile;
	    
		if ( $type == 'order' ) 
		{
			$variables = self::return_variable_values( $args['status'], $mobile, $args['customer_id'], $args['order_id'], $admin );
		}
		else {
			$variables = self::return_welcome_variables( $template, $mobile[0], $args );
		}
		

		foreach ( $mobile as $mob )
		{
			$params = array(
				'ApiKey' 		=> get_option('_dlr_sms_payamresan_accessKey'),
				'TemplateKey' 	=> $template,
				'Destination' 	=> $mob,
			);

			foreach ( $variables as $key=>$variable ) 
			{
				if ( $key == 0 ) $params['p1']  = $variable['value'];
				if ( $key == 1 ) $params['p2']  = $variable['value'];
				if ( $key == 2 ) $params['p3']  = $variable['value'];
			}

			$BaseUrl = "http://api.sms-webservice.com/api/V3/";

			$url = $BaseUrl.'SendTokenSingle?' . http_build_query($params);
			$curl = curl_init();
			curl_setopt_array($curl, array(
			CURLOPT_URL => $url,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'GET',
			));

			$response = json_decode( curl_exec($curl) );
			curl_close($curl);

			// Save report
			$status = $response->Success == true ? 1 : 0;
			$result = $response->Success == true ? __('Message sended successfully', 'dlr') : $response->Error;
			self::save_report( 'payamresan', $template, $mob, $status, $result);
		}
	}

	public static function send_kavenegar_template ( $mobile, $template, $type, $args, $admin )
	{
	    $mobile = (array) $mobile;
	    
		$key 		= get_option('_dlr_sms_kavenegar_apikey');
        
        $url = 'https://api.kavenegar.com/v1/'.$key.'/verify/lookup.json?';

		foreach( $mobile as $mob ) 
		{
			$fields = array(
				'receptor' 	=> $mob,
				"template" 	=> $template
			);

			if ( $type == 'order' ) 
			{
				$variables = self::return_variable_values( $args['status'], $mobile, $args['customer_id'], $args['order_id'], $admin );
			}
			else {
				$variables = self::return_welcome_variables( $template, $mobile[0], $args );
			}

			foreach ( $variables as $key=>$variable ) 
			{
				if ( $key == 0 ) $fields['token']  = $variable['value'];
				if ( $key == 1 ) $fields['token2'] = $variable['value'];
				if ( $key == 2 ) $fields['token3'] = $variable['value'];
			}

			$ch = curl_init();
			curl_setopt( $ch,CURLOPT_URL, $url );
			curl_setopt( $ch,CURLOPT_POST, true );
			curl_setopt( $ch,CURLOPT_POSTFIELDS, http_build_query($fields) );
			curl_setopt( $ch,CURLOPT_RETURNTRANSFER, true );
			curl_setopt( $ch,CURLOPT_SSL_VERIFYPEER, false );

			$response = json_decode(curl_exec($ch));
			curl_close($ch);

			// Save report
			$status = $response->return->status == 200 ? 1 : 0;
			$result = $response->return->status == 200 ? __('Message sended successfully', 'dlr') : $response->return->message;
			self::save_report( 'kavenegar', $template, $mob, $status, $result);
		}
	}

	public static function send_ippanel_template ( $mobile, $template, $type, $args, $admin )
    {
		$username 	= get_option('_dlr_sms_ippanel_username', '' );
		$password 	= get_option('_dlr_sms_ippanel_password', '' );
		$from 		= get_option('_dlr_sms_ippanel_from', '' );
		
		if ( $type == 'order' ) 
		{
			$variables = self::return_variable_values( $args['status'], $mobile, $args['customer_id'], $args['order_id'], $admin );
		}
		else {
			$variables = self::return_welcome_variables( $template, $mobile[0], $args );
		}

		$input_data = [];

		foreach ( $variables as $variable )
		{
			$input_data[ $variable['name'] ] = $variable['value'];
		}

		$mobile = (array) $mobile;

		foreach( $mobile as $mob ) 
		{
			$to = array($mob);

			$url = "https://ippanel.com/patterns/pattern?username=" . $username . "&password=" . urlencode($password) . "&from=$from&to=" . json_encode($to) . "&input_data=" . urlencode(json_encode($input_data)) . "&pattern_code=$template";
			$handler = curl_init($url);
			curl_setopt($handler, CURLOPT_CUSTOMREQUEST, "POST");
			curl_setopt($handler, CURLOPT_POSTFIELDS, $input_data);
			curl_setopt($handler, CURLOPT_RETURNTRANSFER, true);
			$output = curl_exec($handler);
			
			// Save report
			$status = is_numeric($output) ? 1 : 0;

			self::save_report( 
				'ippanel', 
				$template, 
				$mob, 
				$status, 
				self::ippanel_status( json_decode($output) ) 
			);

		}
    }

	public static function send_melipayamak_template ( $mobile, $template, $type, $args, $admin )
	{
		$mobile = (array) $mobile;

    	$username 	= get_option( '_dlr_sms_melipayamak_username', 0 );
    	$password 	= get_option( '_dlr_sms_melipayamak_password', 0 );

		if ( $type == 'order' ) 
		{
			$variables = self::return_variable_values( $args['status'], $mobile, $args['customer_id'], $args['order_id'], $admin );
		}
		else {
			$variables = self::return_welcome_variables( $template, $mobile[0], $args );
		}

		$text = '';
		foreach ( $variables as $key=>$variable )
		{
			$text .= $variable['value'] . ';';
		}

		$fields_string = "";

		foreach ( $mobile as $mob ) 
		{
			$data = [
				'username' 	=> $username,
				'password' 	=> $password,
				'text' 		=> $text,
				'to' 		=> $mob,
				'bodyId' 	=> $template
			];

			if ( ! is_null($data) ) 
			{
				$fields_string = http_build_query($data);
			}

			$url = "https://rest.payamak-panel.com/api/SendSMS/BaseServiceNumber";

			$handle = curl_init();

			curl_setopt($handle, CURLOPT_URL, $url);
			curl_setopt($handle, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($handle, CURLOPT_SSL_VERIFYHOST, false);
			curl_setopt($handle, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($handle, CURLOPT_POST, true);
			curl_setopt($handle, CURLOPT_POSTFIELDS, $fields_string);

			$server_output = json_decode(curl_exec($handle));

			// Save report
			$status = $server_output->RetStatus == 1 ? 1 : 0;
			$value = $status == 1 ? 1 : $server_output->Value;

			self::save_report( 'melipayamak', $template, $mob, $status, self::melipayamak_status($value) );
		}
	    
	    
	}

	public static function send_farapayamak_template ( $mobile, $template, $type, $args, $admin )
	{
		if ( $type == 'order' ) 
		{
			$variables = self::return_variable_values( $args['status'], $mobile, $args['customer_id'], $args['order_id'], $admin );
		}
		else {
			$variables = self::return_welcome_variables( $template, $mobile[0], $args );
		}

		$mobile = (array) $mobile;

		$text = '';
		foreach ( $variables as $key=>$variable )
		{
			$text .= $variable['value'] . ';';
		}
	    
	    $fields_string = "";

		foreach ( $mobile as $mob ) 
		{

			$data = [
				'username' 	=> get_option('_dlr_sms_farapayamak_username'),
				'password' 	=> get_option('_dlr_sms_farapayamak_password'),
				'text' 		=> $text,
				'to' 		=> $mob,
				'bodyId' 	=> $template
			];

			if ( ! is_null($data) ) 
			{
				$fields_string = http_build_query($data);
			}

			$url = "https://rest.payamak-panel.com/api/SendSMS/BaseServiceNumber";

			$handle = curl_init();

			curl_setopt($handle, CURLOPT_URL, $url);
			curl_setopt($handle, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($handle, CURLOPT_SSL_VERIFYHOST, false);
			curl_setopt($handle, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($handle, CURLOPT_POST, true);
			curl_setopt($handle, CURLOPT_POSTFIELDS, $fields_string);

			$server_output    = json_decode( curl_exec($handle) );

			// Save report
			$status = $server_output->RetStatus == 1 ? 1 : 0;
			$value = $status == 1 ? 1 : $server_output->Value;

			self::save_report( 'farapayamak', $template, $mob, $status, self::melipayamak_status($value) );

		}
	}

	public static function send_payamito_template ( $mobile, $template, $type, $args, $admin )
	{
		if ( $type == 'order' ) 
		{
			$variables = self::return_variable_values( $args['status'], $mobile, $args['customer_id'], $args['order_id'], $admin );
		}
		else {
			$variables = self::return_welcome_variables( $template, $mobile[0], $args );
		}

		$mobile = (array) $mobile;

		$text = '';
		foreach ( $variables as $key=>$variable )
		{
			$text .= $variable['value'] . ';';
		}
	    
	    $fields_string = "";

		foreach ( $mobile as $mob ) 
		{
			$data = [
				'username' 	=> get_option('_dlr_sms_payamito_username'),
				'password' 	=> get_option('_dlr_sms_payamito_password'),
				'text' 		=> $text,
				'to' 		=> $mob,
				'bodyId' 	=> $template
			];

			if ( ! is_null($data) ) 
			{
				$fields_string = http_build_query($data);
			}

			$url = "https://rest.payamak-panel.com/api/SendSMS/BaseServiceNumber";

			$handle = curl_init();

			curl_setopt($handle, CURLOPT_URL, $url);
			curl_setopt($handle, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($handle, CURLOPT_SSL_VERIFYHOST, false);
			curl_setopt($handle, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($handle, CURLOPT_POST, true);
			curl_setopt($handle, CURLOPT_POSTFIELDS, $fields_string);

			$server_output    = json_decode( curl_exec($handle) );

			// Save report
			$status = $server_output->RetStatus == 1 ? 1 : 0;
			$value = $status == 1 ? 1 : $server_output->Value;

			self::save_report( 'payamito', $template, $mob, $status, self::melipayamak_status($value) );

		}
	}

	public static function send_smsir_template ( $mobile, $template, $type, $args, $admin )
	{
	    $mobile = (array) $mobile;
	    
		if ( $type == 'order' ) 
		{
			$variables = json_encode( self::return_variable_values( $args['status'], $mobile, $args['customer_id'], $args['order_id'], $admin ) );
		}
		else {
			$variables = json_encode( self::return_welcome_variables( $template, $mobile[0], $args ) );
		}

		foreach( $mobile as $mob )
		{
			$curl = curl_init();
			curl_setopt_array($curl, array(
				CURLOPT_URL => 'https://api.sms.ir/v1/send/verify',
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING => '',
				CURLOPT_MAXREDIRS => 10,
				CURLOPT_TIMEOUT => 0,
				CURLOPT_FOLLOWLOCATION => true,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_CUSTOMREQUEST => 'POST',
				CURLOPT_POSTFIELDS => '{
					"mobile"	: "'.$mob.'",
					"templateId"	: "'.$template.'",
					"parameters"	: '.$variables.'
				}',
				CURLOPT_HTTPHEADER => array(
					'Content-Type: application/json',
					'Accept: text/plain',
					'x-api-key: '.get_option("_dlr_sms_smsir_secretKey")
				)
			));
			
			$response = json_decode( curl_exec( $curl ) );

			$status = $response->status == 1 ? 1 : 0;
			self::save_report( 'smsir', $template, $mob, $status, $response->message );
		}
        
        curl_close($curl);
	}

	private static function return_variable_values( $status, $mobile, $customer_id, $order_id, $admin ) 
	{
		$opt_name = $admin ? '_dlr_admin_'.$status.'_template_variables' : '_dlr_'.$status.'_template_variables';
		$variables = get_option( $opt_name , '' );
		if ($variables == '') return [];

		require_once dirname( dirname( __FILE__ ) ) . '/libs/jdf.php';

		$customer = get_user_by('id', $customer_id);
		$variables = explode(",", $variables);
		$order = wc_get_order( $order_id );

		$b_country 	= $order->get_billing_country();
		$b_state 	= $order->get_billing_state();

		$b_country2 = isset( WC()->countries->countries[ $b_country ] ) ? WC()->countries->countries[ $b_country ] : '';
		$b_state2 = is_array( WC()->countries->get_states( $b_country ) ) ? WC()->countries->get_states( $b_country )[$b_state] : '';

		$sh_country 	= $order->get_billing_country();
		$sh_state 		= $order->get_billing_state();

		$sh_country2 = isset( WC()->countries->countries[ $sh_country ] ) ? WC()->countries->countries[ $sh_country ] : '';
		$sh_state2 = is_array( WC()->countries->get_states( $sh_country ) ) ? WC()->countries->get_states( $sh_country )[$sh_state] : '';

		$values = [];
		foreach ( $variables as $variable ) 
		{
			switch ( $variable ) 
			{
				case 'mobile':
					$values[] = ['name' => 'mobile', 'value' => (string) $mobile[0]];
					break;
				
				case 'email':
					$values[] = ['name' => 'email', 'value' => (string) $customer->user_email];
					break;

				case 'status':
					$values[] = ['name' => 'status', 'value' => (string) self::return_status($status)];
					break;

				case 'order_id':
					$values[] = ['name' => 'order_id', 'value' => (string) $order_id];
					break;

				case 'quantity':
					$values[] = ['name' => 'quantity', 'value' => (string) count( $order->get_items() )];
					break;

				case 'price':
					$values[] = ['name' => 'price', 'value' => (string) number_format( $order->get_total() ) .' '. html_entity_decode( get_woocommerce_currency_symbol() )];
					break;

				case 'date':
					$values[] = ['name' => 'date', 'value' => (string) jdate1( 'd-m-Y', strtotime( $order->get_date_modified()->format('Y/m/d') ) )];
					break;

				case 'date-time':
					$values[] = ['name' => 'date-time', 'value' => (string) jdate1( 'd-m-Y ساعت H:i', strtotime( $order->get_date_created()->format('Y/m/d h:i:s') ) )];
					break;

				case 'payment':
					$values[] = ['name' => 'date-time', 'value' => (string) $order->get_payment_method_title()];
					break;

				case 'shipping':
					$values[] = ['name' => 'shipping', 'value' => (string) $order->get_shipping_method()];
					break;

				case 'b_name':
					$values[] = ['name' => 'b_name', 'value' => (string) $order->get_billing_first_name()];
					break;

				case 'b_family':
					$values[] = ['name' => 'b_family', 'value' => (string) $order->get_billing_last_name()];
					break;

				case 'b_company':
					$values[] = ['name' => 'b_company', 'value' => (string) $order->get_billing_company()];
					break;

				case 'b_country':
					$values[] = ['name' => 'b_country', 'value' => (string) $b_country2];
					break;

				case 'b_state':
					$values[] = ['name' => 'b_state', 'value' => (string) $b_state2];
					break;

				case 'b_city':
					$values[] = ['name' => 'b_city', 'value' => (string) $order->get_billing_city()];
					break;

				case 'b_post':
					$values[] = ['name' => 'b_post', 'value' => (string) $order->get_billing_postcode()];
					break;

				case 'sh_name':
					$values[] = ['name' => 'sh_name', 'value' => (string) $order->get_shipping_first_name()];
					break;

				case 'sh_family':
					$values[] = ['name' => 'sh_family', 'value' => (string) $order->get_shipping_last_name()];
					break;

				case 'sh_company':
					$values[] = ['name' => 'sh_company', 'value' => (string) $order->get_shipping_company()];
					break;

				case 'sh_country':
					$values[] = ['name' => 'sh_country', 'value' => (string) $sh_country2];
					break;

				case 'sh_state':
					$values[] = ['name' => 'sh_state', 'value' => (string) $sh_state2];
					break;

				case 'sh_city':
					$values[] = ['name' => 'sh_city', 'value' => (string) $order->get_shipping_city()];
					break;

				case 'sh_post':
					$values[] = ['name' => 'sh_post', 'value' => (string) $order->get_shipping_postcode()];
					break;
			}
		}
		return $values;
	}
}