<?php
defined('ABSPATH') or die;

class Mobits 
{
	protected static $wpdb;
    protected static $table;
	protected static $options_table;
	protected static $users_table;

    public function __construct()
    {
		$this->define_variables();
		$this->define_constants();
		$this->includes();
		$this->init();
    }

	private function define_variables() 
	{
		global $wpdb;
		self::$wpdb 			= $wpdb;
		self::$table 			= $wpdb->prefix . "dlr_activation";
		self::$options_table 	= $wpdb->prefix . "options";
		self::$users_table 		= $wpdb->prefix . "users";
	}

	private function define_constants() 
	{
		$this->define( 'DLR_ABSPATH', dirname( DLR_PLUGIN_FILE ) . '/' );
		$this->define( 'DLR_VERSION', DLR_DATA['Version'] );
		$this->define( 'DLR_NAME', 'dlr' );
		$this->define( 'DLR_PULIC_PARTIALS', DLR_ABSPATH . '/public/partials/' );
	}

	protected function includes()
	{
		require_once DLR_ABSPATH . '/includes/class-dlr-sms.php';
		
		if( ! is_admin() ) 
		{
			require_once DLR_ABSPATH . '/public/class-dlr-public.php';
			require_once DLR_ABSPATH . '/public/class-dlr-public-rest.php';
			require_once DLR_ABSPATH . '/includes/class-dlr-shortcodes.php';
		}
		else
		{
			require_once DLR_ABSPATH . '/admin/class-dlr-admin.php';
			
			require_once DLR_ABSPATH . 'admin/partials/class-dlr-users.php';
			require_once DLR_ABSPATH . 'admin/partials/class-dlr-update-notifier.php';
			require_once DLR_ABSPATH . 'admin/partials/class-dlr-enqueue.php';
		}

		if ( get_option('_dlr_support_woocommerce', 1) == 1 )
			require_once DLR_ABSPATH . '/includes/class-woocommerce.php';

		require_once DLR_ABSPATH . '/admin/partials/class-dlr-rest.php';
		require_once DLR_ABSPATH . '/includes/class-dlr-action-scheduler.php';
	}

	protected function init()
	{
		if( ! is_admin() ) 
		{
			new Dlr_Public();
			new Dlr_Shortcodes();
			new Dlr_Public_Rest();
		}

		if( is_admin() ) {
			new Dlr_Admin();
			new Dlr_Admin_Users();
			new Dlr_Admin_Enqueue();
		}

		if( is_admin() && get_option("_dlr_update_notice_in_admin_bar") == 1 ) new Dlr_Update_Notifier();

		new Dlr_Sms();
		new Dlr_action_scheduler();
	}

	protected function define( $name, $value ) 
	{
		if ( ! defined( $name ) ) 
			define( $name, $value );
	}

	private static function _prepare_in ( $values ) 
	{
		return implode( ',', array_map( function ( $value ) {
			return self::$wpdb->prepare( '%s', $value );
		}, $values ) );
	}

	protected static function get_options($args)
	{
		$status = sprintf(
			'option_name IN (%s)',
			self::_prepare_in( $args )
		);

		$table = self::$options_table;

		$results = self::$wpdb->get_results( "SELECT option_name,option_value FROM $table WHERE $status;" );
		
		$output = [];
		
		foreach($results as $item)
			$output[$item->option_name] = $item->option_value;
			
		foreach( $args as $item ) 
			if ( !isset( $output[$item] ) ) $output[$item] = '';

		return $output;
	}
    
    protected static function encrypt_decrypt($action, $string) 
    {
        $output = false;
        $encrypt_method = "AES-256-CBC";
        $secret_key = 'm_sMU?^qS!;3v}k8B<';
        $secret_iv = 'm_sU?^qS!;3vk<';
        // hash
        $key = hash('sha256', $secret_key);
    
        $iv = substr(hash('sha256', $secret_iv), 0, 16);
        if ( $action == 'encrypt' ) {
            $output = openssl_encrypt($string, $encrypt_method, $key, 0, $iv);
            $output = base64_encode($output);
        } else if( $action == 'decrypt' ) {
            $output = openssl_decrypt(base64_decode($string), $encrypt_method, $key, 0, $iv);
        }
        return $output;
	}

	protected static function ok_mobits()
	{
		if( self::encrypt_decrypt('decrypt', get_option('dlr_li3nce', 0) ) != 
		preg_replace('/^www\./', '', $_SERVER['SERVER_NAME']) )
		{
			wp_die( __('You are not allowed to use mobits. Please buy and activate Mobits from a reliable site. If you entered your domain correctly and the plugin is not activated. Send your site access in Telegram to the number 09111259325 so that the installation and activation process will be done for you immediately.', 'dlr') );
		}
	}

	protected static function mobile_validation($mobile)
	{
		$check_mobile = preg_match("/^09[0-9]{9}$/", $mobile);
		$check_mobile2 = preg_match("/^9[0-9]{9}$/", $mobile);

		return $check_mobile || $check_mobile2 ? 1 : false;
	}

	protected static function return_mobile ($user_id)
	{
		$user = get_user_by( 'id', $user_id );
		if ( !$user ) return false;

		// Mobits user (Or digits)
		if ( self::mobile_validation( $user->user_login ) ) 
			return $user->user_login;

		// Digits user
		if( get_option('_dlr_support_digits', 0) == 1 ) 
		{
			$meta1 = get_user_meta( $user_id, 'digits_phone_no', true );
			$meta2 = get_user_meta( $user_id, 'digits_phone', true );

			if ( $meta1 == '' && $meta2 == '' ) return false;

			if ( self::mobile_validation( $meta1 ) ) return "0".$meta1;

			$mobile = str_replace('+98', '', $meta2);
			if ( self::mobile_validation( $mobile ) ) return "0".$mobile;
		}

		return false;
	}
}