<?php
defined('ABSPATH') or die;

class Dlr_Woocommerce extends Mobits
{
    public function __construct()
    {
		add_action( 'woocommerce_order_status_changed', [$this, 'woocommerce_order_status_changed'], 10, 3);
		add_action( 'woocommerce_new_order', [$this, 'woocommerce_new_order'] );
		add_action( 'woocommerce_admin_order_data_after_order_details', [$this, 'woocommerce_admin_order_data_after_order_details'] );

		add_action('init', [$this, 'init']);
		add_filter( 'handle_bulk_actions-edit-shop_order', [$this, 'handle_bulk_actions_edit_shop_order'], 10, 3 );
		add_filter( 'woocommerce_billing_fields', [$this, 'woocommerce_billing_fields'] ); 
    }

	public function init ()
	{
		$this->define_constants();
	}

	public function define_constants ()
	{
		define( 'WOO_STATUSES', $this->return_woo_statuses() );
	}

	public function woocommerce_billing_fields ($fields)
	{
		if ( get_option('_dlr_checkout_billing_email_optional', 0 ) )
			$fields['billing_email']['required']  = false;

		return $fields;
	}

	public function handle_bulk_actions_edit_shop_order ($redirect_to, $action, $ids) 
	{
	    if ( false !== strpos( $action, 'mark_' ) )
	    {
            $new_status = substr( $action, 5 );

			if ( $new_status == 'on-hold' ) $new_status = 'onhold';
		    if ( $new_status == 'checkout-draft' ) $new_status = 'draft';

			if ( get_option( '_dlr_customer_'.$new_status.'_sms_status', 0 ) == 1 )
			{
			    foreach( $ids as $id ) 
                {
                    $order       = wc_get_order( $id );
    		        $customer_id = $order->get_customer_id();
    		        
    		        $this->send_sms( $new_status, $customer_id, $order, $id, false );
                }
			};
        }
        
        return $redirect_to;
	}

	private function return_woo_statuses ()
	{
		if ( ! class_exists( 'WooCommerce' ) ) return [];

		$statuses = wc_get_order_statuses();
		
		$arr = [];
		foreach ( $statuses as $key2=>&$status ) 
		{
			if ( $key2 == 'wc-on-hold' ) $key = 'onhold';
			else if ( $key2 == 'wc-checkout-draft' ) $key = 'draft';
			else $key = $key2;

			$key = str_replace("wc-", "", $key);
			$key = str_replace("-", "_", $key);

			$arr[$key] = $status;
		}

		return $arr;
	}

	public function woocommerce_order_status_changed ( $order_id, $old_status, $new_status )
	{
	    if ( is_admin() && isset($_GET['post_type']) ) return;
	    
		$order = wc_get_order( $order_id );
		$customer_id = $order->get_customer_id();

		$this->send_sms( $new_status, $customer_id, $order, $order_id );
	}

	private function send_sms ($new_status, $customer_id, $order, $order_id, $admin_check=true)
	{
		if ( $new_status == 'on-hold' ) $new_status = 'onhold';
		if ( $new_status == 'checkout-draft' ) $new_status = 'draft';

		// Get customer mobile
		$mobile = parent::return_mobile( $customer_id );

		// Admin side
		if ( is_admin() )
		{
			// User order sms from wp panel
			
			$send = true;
			if ( $admin_check && !isset( $_POST['dlr_order_sms_status'] ) ) 
			{
			    $send = false;
			}

			if ( $send ) 
			{
			    if ( $mobile ) 
			    {
			        $sms_type = get_option('_dlr_'.$new_status.'_sms_type', 'text');

    				$service = get_option('_dlr_woocommerce_webservice', '');
    
    				// User order sms as template
    				if ( $sms_type == 'template' ) 
    				{
    					$template = get_option('_dlr_'.$new_status.'_template_code', '');
    
    					if ( $template != '' ) 
    					{
							
    						Dlr_sms::send_sms_template( $mobile, $template, $service, 'order', [
								'customer_id'	=> $customer_id,
								'status'		=> $new_status,
								'order_id'		=> $order_id
							]);
    					}
    					
    				}
    				// User order sms as text
    				else 
    				{
    					$body = $_POST['dlr_order_sms_body'];
    					if ( $body == '' ) {
    						$body = get_option( '_dlr_customer_'.$new_status.'_sms_body', 0 );
    					}
    					
    					if ( $body != '' ) {
    						$body = $this->return_sms_body($mobile, $body, $order, $customer_id, $new_status, $order_id);
    						Dlr_sms::send_sms( $mobile, $body, $service );
    					}
    					
    				}
			    }
				
			}
			
			// Admin order sms from wp panel

			$admin_ok = get_option('_dlr_admin_order_send_sms', '');

			if ( $admin_ok != 1 ) return;

			$admin_sms_status = get_option('_dlr_admin_'.$new_status.'_sms_status', 0);

			if ( $admin_sms_status != 1 ) return;

			$admin_sms_type = get_option('_dlr_admin_'.$new_status.'_sms_type', 'text');

			$mobile = get_option('_dlr_admin_'.$new_status.'_managers', '');

			$service = get_option('_dlr_woocommerce_admin_webservice', '');

			if ( $admin_sms_type == 'template' ) 
			{
				$template = get_option('_dlr_admin_'.$new_status.'_template_code', '');

				if ( $template == '' ) return;

				Dlr_sms::send_sms_template( $mobile, $template, $service, 'order', [
					'customer_id'	=> $customer_id,
					'status'		=> $new_status,
					'order_id'		=> $order_id
				], 1);
				
				return;
			}
			else 
			{
				$body = get_option( '_dlr_admin_'.$new_status.'_sms_body', 0 );
				
				$body = $this->return_sms_body($mobile, $body, $order, $customer_id, $new_status, $order_id);

				Dlr_sms::send_sms( $mobile, $body, $service );
			}

		}
		// Public side
		else 
		{
			if ( get_option( '_dlr_customer_'.$new_status.'_sms_status', 0 ) == 1 ) 
			{
				if ( $mobile ) 
				{
					$sms_type = get_option('_dlr_'.$new_status.'_sms_type', 'text');
					$service  = get_option('_dlr_woocommerce_webservice', '');

					if ( $sms_type == 'template' ) 
					{
						$template = get_option('_dlr_'.$new_status.'_template_code', '');
						if ( $template == '' ) return;

						Dlr_sms::send_sms_template( $mobile, $template, $service, 'order', [
							'customer_id'	=> $customer_id,
							'status'		=> $new_status,
							'order_id'		=> $order_id
						]);
					}
					else 
					{
						$body = get_option( '_dlr_customer_'.$new_status.'_sms_body', 0 );
						if ( $body == '' ) return false;

						$body = $this->return_sms_body($mobile, $body, $order, $customer_id, $new_status, $order_id);

						Dlr_sms::send_sms( $mobile, $body, $service );
					}
				}
				
			}

			//Admins sms
			$admin_sms_status = get_option('_dlr_admin_'.$new_status.'_sms_status', 0);
			if ( $admin_sms_status != 1 ) return;

			$admin_sms_type = get_option('_dlr_admin_'.$new_status.'_sms_type', 'text');

			$mobile = get_option('_dlr_admin_'.$new_status.'_managers', '');

			$service = get_option('_dlr_woocommerce_admin_webservice', '');

			if ( $admin_sms_type == 'template' ) 
			{
				$template = get_option('_dlr_admin_'.$new_status.'_template_code', '');

				if ( $template == '' ) return;

				Dlr_sms::send_sms_template( $mobile, $template, $service, 'order', [
					'customer_id'	=> $customer_id,
					'status'		=> $new_status,
					'order_id'		=> $order_id
				], 1);
			}
			else 
			{
				$body = get_option( '_dlr_admin_'.$new_status.'_sms_body', 0 );
				
				$body = $this->return_sms_body($mobile, $body, $order, $customer_id, $new_status, $order_id);

				Dlr_sms::send_sms( $mobile, $body, $service );
			}
		}
	}

	public function woocommerce_new_order ($order_id)
	{
		if ( ! is_admin() ) return;

		$order = wc_get_order( $order_id );
		$new_status = $order->get_status();

		if ( $new_status != 'pending' ) return;

		$customer_id = $order->get_customer_id();

		$this->send_sms ($new_status, $customer_id, $order, $order_id);
	}

	private function return_sms_body( $mobile, $body, $order, $user_id, $status, $order_id )
	{
		$user = get_user_by('id', $user_id);

		$body = str_replace( "{mobile}", 		$mobile, $body );
		$body = str_replace( "{email}", 		$user->user_email, $body );
		$body = str_replace( "{status}", 		$this->return_status($status), $body );
		$body = str_replace( "{order_id}", 		$order_id, $body );

		if ( str_contains($body, '{items}') ) 
		{
			$items = '';
			foreach ( $order->get_items() as $item_id => $item ) 
			{
				$items .= get_the_title( $item->get_product_id() ) . " \n";
			}
			$body = str_replace( "{items}", $items, $body );
		}

		require_once dirname( dirname( __FILE__ ) ) . '/libs/jdf.php';

		$body = str_replace( "{quantity}", 		count($order->get_items()) , $body );
		$body = str_replace( "{price}", 		number_format( $order->get_total() ) .' '. html_entity_decode( get_woocommerce_currency_symbol() ) , $body );
		$body = str_replace( "{date}", 			jdate1( 'd-m-Y', strtotime($order->get_date_created()->format('Y/m/d')) ), $body );
		$body = str_replace( "{date-time}", 	jdate1( 'd-m-Y ساعت H:i', strtotime($order->get_date_created()->format('Y/m/d h:i:s')) ), $body );
		$body = str_replace( "{payment}", 		$order->get_payment_method_title(), $body );
		$body = str_replace( "{shipping}", 		$order->get_shipping_method(), $body );
		$body = str_replace( "{note}", 			$order->get_customer_note(), $body );

		$b_country 	= $order->get_billing_country();
		$b_state 	= $order->get_billing_state();

		$body = str_replace( "{b_name}", 		$order->get_billing_first_name(), $body );
		$body = str_replace( "{b_family}", 		$order->get_billing_last_name(), $body );
		$body = str_replace( "{b_company}", 	$order->get_billing_company(), $body );

		if ( isset( WC()->countries->countries[ $b_country ] ) )
			$body = str_replace( "{b_country}", 	WC()->countries->countries[ $b_country ], $body );

		if ( is_array( WC()->countries->get_states( $b_country ) ) )
			$body = str_replace( "{b_state}", 		WC()->countries->get_states( $b_country )[$b_state], $body );

		$body = str_replace( "{b_city}", 		$order->get_billing_city(), $body );
		$body = str_replace( "{b_address1}", 	$order->get_billing_address_1(), $body );
		$body = str_replace( "{b_address2}", 	$order->get_billing_address_2(), $body );
		$body = str_replace( "{b_post}", 		$order->get_billing_postcode(), $body );

		$sh_country 	= $order->get_billing_country();
		$sh_state 		= $order->get_billing_state();

		$body = str_replace( "{sh_name}", 		$order->get_shipping_first_name(), $body );
		$body = str_replace( "{sh_family}", 	$order->get_shipping_last_name(), $body );
		$body = str_replace( "{sh_company}", 	$order->get_shipping_company(), $body );

		if ( isset( WC()->countries->countries[ $sh_country ] ) )
			$body = str_replace( "{sh_country}", 	WC()->countries->countries[ $sh_country ], $body );

		if ( is_array( WC()->countries->get_states( $sh_country ) ) )
			$body = str_replace( "{sh_state}", 		WC()->countries->get_states( $sh_country )[$sh_state], $body );

		$body = str_replace( "{sh_city}", 		$order->get_shipping_city(), $body );
		$body = str_replace( "{sh_address1}", 	$order->get_shipping_address_1(), $body );
		$body = str_replace( "{sh_address2}", 	$order->get_shipping_address_2(), $body );
		$body = str_replace( "{sh_post}", 		$order->get_shipping_postcode(), $body );

		return $body;
	}

	private function return_status ($status)
	{
		switch ($status)
		{
			case 'pending':
				return __('Pending', 'dlr');
				break;
			case 'processing':
				return __('Processing', 'dlr');
				break;
			case 'onhold':
				return __('Onhold', 'dlr');
				break;
			case 'completed':
				return __('Completed', 'dlr');
				break;
			case 'cancelled':
				return __('Cancelled', 'dlr');
				break;
			case 'refunded':
				return __('Refunded', 'dlr');
				break;
			case 'failed':
				return __('Failed', 'dlr');
				break;
			case 'draft':
				return __('Draft', 'dlr');
				break;
		}
	}

	public function woocommerce_admin_order_data_after_order_details ()
	{
		?>

		<script>
		jQuery(document).ready(function($)
		{
			function dlr_order_sms() 
			{
				$('.dlr_order_sms').css('opacity', .5);
				$.ajax({
					type : "POST",
					dataType : "JSON",
					url : '<?php echo home_url(); ?>' + '/wp-json/api/dlrGetOrderSms',
					data : {
						status: $('select[name=order_status]').val()
					},
					success : function(response) {
						$('.dlr_order_sms').html(response);
						$('.dlr_order_sms').css('opacity', 1);
					}
				});
			}

			$(document).on('change', 'select[name=order_status]', function(){
				dlr_order_sms();
			});

			$(document).on('change', '#dlr_order_sms_status', function()
			{
				if( $(this).is(":checked") ) 
				{
					$('.dlr_order_sms_body').fadeIn();
				}
				else {
					$('.dlr_order_sms_body').fadeOut();
				}
			});

			<?php if ( !isset($_GET['action']) ): ?>
			dlr_order_sms();
			<?php endif; ?>
		});
		</script>

		<div class="dlr_order_sms form-field form-field-wide"></div>

		<?php
	}
}

new Dlr_Woocommerce();