<?php
class Dlr_Public_Rest extends Dlr_Public
{
	public function __construct()
	{
		$this->init();
	}

	public function init()
	{
		add_action( 'rest_api_init', [$this, 'dlr_admin_rest_api_init'] );
	}

	public function dlr_admin_rest_api_init()
    {
		register_rest_route( 'api', '/sendSmsMelliPayamak', array(
            'methods' => 'post',
            'callback' => [$this, 'send_mellipayamak_rest_callback'],
			'permission_callback'  => '__return_true'
        ));

		register_rest_route( 'api', '/sendSmsFaraPayamak', array(
            'methods' => 'post',
            'callback' => [$this, 'send_farapayamak_rest_callback'],
			'permission_callback'  => '__return_true'
        ));

		register_rest_route( 'api', '/sendSmsIppanel', array(
            'methods' => 'post',
            'callback' => [$this, 'send_ippanel_rest_callback'],
			'permission_callback'  => '__return_true'
        ));

		register_rest_route( 'api', '/sendSmsIr', array(
            'methods' => 'post',
            'callback' => [$this, 'send_smsir_rest_callback'],
			'permission_callback'  => '__return_true'
        ));

		register_rest_route( 'api', '/sendPayamresan', array(
            'methods' => 'post',
            'callback' => [$this, 'send_payamresan_rest_callback'],
			'permission_callback'  => '__return_true'
        ));

		register_rest_route( 'api', '/sendKavenegar', array(
            'methods' => 'post',
            'callback' => [$this, 'send_kavenegar_rest_callback'],
			'permission_callback'  => '__return_true'
        ));

		register_rest_route( 'api', '/sendPayamito', array(
            'methods' => 'post',
            'callback' => [$this, 'send_payamito_rest_callback'],
			'permission_callback'  => '__return_true'
        ));
    }

	protected static function check_user_code($mobile) 
	{
		global $wpdb;
		$table = $wpdb->prefix . 'dlr_activation';
	    $check = $wpdb->get_row( $wpdb->prepare( "SELECT * FROM $table WHERE mobile='%s'", $mobile ) );

	    return ($check==NULL) ? false : $check;
	}

	protected static function sms_validation($data)
	{
	    $mobile = sanitize_text_field( $data->get_header('mobits-number') );

		// Check code is avilable
		$check = self::check_user_code( $mobile );
	    if ( ! $check ) return -1;

		$now = time();

		// If request is Repeat
		if( sanitize_text_field( $data->get_header('repeat-to') ) == 1 ) 
		{
			if( (int)$now-(int)$check->time > (int)get_option('_dlr_resend_code_time', 120) ) return -2;
		}
		// If request is Login, Register or recovery
		else 
		{
			if ( (int)$now-(int)$check->time > (int)get_option('_dlr_resend_code_time', 120) ) return -3;
		}

		return [$check];
	}

	private static function save_report($webservice, $template, $mobile, $status, $result)
	{
		// Stop if option is disabled;
		if ( get_option("_dlr_webservice_reports") != 1 ) return;

		// Save report
		global $wpdb;
		date_default_timezone_set('Asia/Tehran');
		$wpdb->insert( $wpdb->prefix . 'dlr_send_sms' ,
		[
			'webservice' 	=> $webservice,
			'template' 		=> $template,
			'time' 			=> date('Y/m/d H:i:s'),
			'receiver' 		=> $mobile,
			'status' 		=> $status,
			'result' 		=> $result
		]);
	}

	public static function send_mellipayamak_rest_callback ( $data )
	{
		// Validate sms send
		$status = self::sms_validation($data);
		if ( ! is_array($status) ) return $status;

		$fields_string = "";

		$bodyId = get_option( '_dlr_sms_melipayamak_theme', 0 );
		$mobile = sanitize_text_field( $data->get_header('mobits-number') );

		$data = [
			'username' 	=> get_option( '_dlr_sms_melipayamak_username', 0 ),
			'password' 	=> get_option( '_dlr_sms_melipayamak_password', 0 ),
			'text' 		=> $status[0]->code,
			'to' 		=> $mobile,
			'bodyId' 	=> $bodyId
		];

		if ( ! is_null($data) ) 
		{
			$fields_string = http_build_query($data);
		}

		$url = "https://rest.payamak-panel.com/api/SendSMS/BaseServiceNumber";

		$handle = curl_init();

		curl_setopt($handle, CURLOPT_URL, $url);
		curl_setopt($handle, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($handle, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($handle, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($handle, CURLOPT_POST, true);
		curl_setopt($handle, CURLOPT_POSTFIELDS, $fields_string);

		$server_output  = json_decode( curl_exec($handle) );

		// Save report
		$status = $server_output->RetStatus == 1 ? 1 : 0;
		$value = $status == 1 ? 1 : $server_output->Value;

		self::save_report( 'melipayamak', $bodyId, $mobile, $status, self::melipayamak_status($value) );

		// Support webservice
		if ( $server_output->RetStatus != 1 ) 
			self::run_support_webservice( $mobile, $code );

		// Save webserive in cookie
		set_transient('mobits_webservice', "melipayamak:$bodyId", 30*60);
	}

	public static function melipayamak_status($value)
	{
		switch($value)
		{
			case "-7":
				return "خطایی در شماره فرستنده رخ داده است با پشتیبانی تماس بگیرید";
				break;
			case "-6":
				return "خطای داخلی رخ داده است با پشتیبانی تماس بگیرید";
				break;
			case "-5":
				return "متن ارسالی باتوجه به متغیرهای مشخص شده در متن پیشفرض همخوانی ندارد";
				break;
			case "-4":
				return "کد متن ارسالی صحیح نمی‌باشد و یا توسط مدیر سامانه تأیید نشده است";
				break;
			case "-3":
				return "خط ارسالی در سیستم تعریف نشده است، با پشتیبانی سامانه تماس بگیرید";
				break;
			case "-2":
				return "محدودیت تعداد شماره، محدودیت هربار ارسال یک شماره موبایل می‌باشد";
				break;
			case "-1":
				return "دسترسی برای استفاده از این وبسرویس غیرفعال است. با پشتیبانی تماس بگیرید";
				break;
			case "0":
				return "نام کاربری یا رمزعبور صحیح نمی‌باشد";
				break;
			case "2":
				return "اعتبار کافی نمی‌باشد";
				break;
			case "6":
				return "سامانه درحال بروزرسانی می‌باشد";
				break;
			case "7":
				return "متن حاوی کلمه فیلتر شده می‌باشد، با واحد اداری تماس بگیرید";
				break;
			case "10":
				return "کاربر موردنظر فعال نمی‌باشد";
				break;
			case "11":
				return "ارسال نشده";
				break;
			case "12":
				return "مدارک کاربر کامل نمی‌باشد";
				break;
			case "35":
				return "وجود شماره موبایل گیرنده در لیست سیاه مخابرات";
				break;
			case "1":
				return "با موفقیت ارسال گردید";
				break;
			default: 
				return "خطای نامشخص";
		}
	}

	public static function send_ippanel_rest_callback ( $data )
    {
		$status = self::sms_validation($data);
		if ( ! is_array($status) ) return $status;
	    
	    $code   	= $status[0]->code;
	    $mobile 	= sanitize_text_field( $data->get_header('mobits-number') );

		$username 	= get_option('_dlr_sms_ippanel_username', '' );
		$password 	= get_option('_dlr_sms_ippanel_password', '' );
		$from 		= get_option('_dlr_sms_ippanel_from', '' );
		$pattern_code = get_option('_dlr_sms_ippanel_theme', '' );
		$to 		= array($mobile);
		$input_data = array(
        	"verification-code" => $code
        );
		$url = "https://ippanel.com/patterns/pattern?username=" . $username . "&password=" . urlencode($password) . "&from=$from&to=" . json_encode($to) . "&input_data=" . urlencode(json_encode($input_data)) . "&pattern_code=$pattern_code";
		$handler = curl_init($url);
		curl_setopt($handler, CURLOPT_CUSTOMREQUEST, "POST");
		curl_setopt($handler, CURLOPT_POSTFIELDS, $input_data);
		curl_setopt($handler, CURLOPT_RETURNTRANSFER, true);
		$output = curl_exec($handler);
		
		// Save report
		$status = is_numeric($output) ? 1 : 0;
		self::save_report( 'ippanel', $pattern_code, $mobile, $status, self::ippanel_status( json_decode($output) ) );

		// Support webservice
		if ( ! is_numeric($output) ) 
			self::run_support_webservice( $mobile, $code );

		// Save webserive in cookie
		set_transient('mobits_webservice', "ippanel:$pattern_code", 30*60);
    }

	private static function ippanel_status($output)
	{
		if ( $output == '' ) return "شناسه قالب نامعتبر می باشد.";
		if ( is_numeric ($output) ) return "پیامک با موفقیت ارسال گردید.";

		if ( !is_array($output) ) return "خطای نامشخص، لطفا با پشتیبانی تماس بگیرید.";

		switch($output[0])
		{
			case "2":
				return "کاربر محدود گردیده است.";
				break;
			case "3":
				return "خط به شما تعلق ندارد.";
				break;
			case "5":
				return "اعتبار کافی نیست.";
				break;
			case "9":
				return "خط مورد نظر در این ساعت امکان ارسال ندارد.";
				break;
			case "99":
				return "اپراتور خط ارسالی قطع می‌باشد.";
				break;
			case "301":
				return "از حرف ویژه در نام کاربری استفاده گردیده است.";
				break;
			case "303":
				return "نام کاربری وارد نگردیده است.";
				break;
			case "305":
				return "نام کاربری وارد نگردیده است.";
				break;
			case "317":
				return "کلمه عبور وارد نشده است.";
				break;
			case "962":
				return "نام کاربری یا کلمه عبور نادرست می باشد.";
				break;
			case "971":
				return "پترن ارسالی نامعتبر است.";
				break;
			case "970":
				return "پارامتر های ارسالی برای پترن نامعتبر است.";
				break;
			case "994":
				return "لطفا تصویری از کارت بانکی خود را از منو مدارک ارسال کنید";
				break;
			case "998":
				return "کارت ملی یا کارت بانکی شما تایید نشده است.";
				break;
			default: 
				return "خطای نامشخص";
		}
	}

	public static function send_smsir_rest_callback ( $data )
    {
		$status = self::sms_validation($data);
		if ( ! is_array($status) ) return $status;
	    
	    $code   	= $status[0]->code;
	    $mobile 	= sanitize_text_field( $data->get_header('mobits-number') );
        
        $curl = curl_init();

		$template = get_option("_dlr_sms_smsir_theme");

        curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://api.sms.ir/v1/send/verify',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS =>'{
            "mobile": "'.$mobile.'",
            "templateId": "'.$template.'",
            "parameters": [
                {
                  "name": "CODE",
                  "value": "'.$code.'"
                }
            ]
        }',
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'Accept: text/plain',
            'x-api-key: '.get_option("_dlr_sms_smsir_secretKey")
        ),
        ));
        
        $response = json_decode( curl_exec($curl) );
        
        curl_close($curl);

		// Save report
		$status = $response->status == 1 ? 1 : 0;
		self::save_report( 'smsir', $template, $mobile, $status, $response->message );

		// Support webservice
		if ( $response->status != 1 ) 
			self::run_support_webservice( $mobile, $code );

		// Save webserive in cookie
		set_transient('mobits_webservice', "smsir:$template", 30*60);
    }

	public static function run_support_webservice( $mobile, $code )
	{
		$aw = ['smsir', 'melipayamak', 'payamresan', 'ippanel', 'kavenegar'];
		$op = get_option('_dlr_support_sms_service', '');

		if ( in_array( $op, $aw ) ) 
		{
			switch ($op)
			{
				case 'melipayamak' :
					self::send_mellipayamak_support ( $mobile, $code );
					break;
				case 'ippanel' :
					self::send_ippanel_support ( $mobile, $code );
					break;
				case 'smsir' :
					self::send_smsir_support ( $mobile, $code );
					break;
				case 'payamresan' :
					self::send_payamresan_support ( $mobile, $code );
					break;
				case 'kavenegar' :
					self::send_kavenegar_support ( $mobile, $code );
					break;
			}
		}
	}

	public static function send_mellipayamak_support ( $mobile, $code )
	{
	    $bodyId 	= get_option( '_dlr_sms_melipayamak_theme', 0 );
    	$username 	= get_option( '_dlr_sms_melipayamak_username', 0 );
    	$password 	= get_option( '_dlr_sms_melipayamak_password', 0 );
	    
	    $ch = curl_init();
    	curl_setopt($ch, CURLOPT_URL,"http://rest.payamak-panel.com/api/SendSMS/BaseServiceNumber");
    	curl_setopt($ch, CURLOPT_POST, 1);
    	curl_setopt($ch, CURLOPT_POSTFIELDS, 'username='.$username.'&password='.$password.'&to='.$mobile.'&bodyId='.$bodyId.'&text='.$code);
    	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    	$server_output = json_decode(curl_exec($ch));
    	curl_close ($ch);

		// Save report
		$status = $server_output->RetStatus == 1 ? 1 : 0;
		$value = $status == 1 ? 1 : $server_output->Value;

		self::save_report( 'melipayamak', $bodyId, $mobile, $status, self::melipayamak_status($value) );

		// Save webserive in cookie
		set_transient('mobits_webservice', "melipayamak:$bodyId", 30*60);
	}

	public static function send_payamresan_support ( $mobile, $code )
    {
	   $template   = get_option('_dlr_sms_payamresan_theme');
        
       $params = array(
			'ApiKey' 		=> get_option('_dlr_sms_payamresan_accessKey'),
			'TemplateKey' 	=> $template,
			'Destination' 	=> $mobile,
			'p1' 			=> $code
		);

		$BaseUrl = "http://api.sms-webservice.com/api/V3/";

		$url = $BaseUrl.'SendTokenSingle?' . http_build_query($params);
		$curl = curl_init();
		curl_setopt_array($curl, array(
		CURLOPT_URL => $url,
		CURLOPT_RETURNTRANSFER => true,
		CURLOPT_ENCODING => '',
		CURLOPT_MAXREDIRS => 10,
		CURLOPT_TIMEOUT => 0,
		CURLOPT_FOLLOWLOCATION => true,
		CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		CURLOPT_CUSTOMREQUEST => 'GET',
		));

		$response = json_decode( curl_exec($curl) );
		curl_close($curl);

		// Save report
		$status = $response->Success == true ? 1 : 0;
		$result = $response->Success == true ? __('Message sended successfully', 'dlr') : $response->Error;
		self::save_report( 'payamresan', $template, $mobile, $status, $result);

		// Save webserive in cookie
		set_transient('mobits_webservice', "payamresan:$template", 30*60);
    }

	public static function send_smsir_support ( $mobile, $code )
    {
        $curl = curl_init();
		$template = get_option("_dlr_sms_smsir_theme");

        curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://api.sms.ir/v1/send/verify',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS =>'{
            "mobile": "'.$mobile.'",
            "templateId": "'.$template.'",
            "parameters": [
                {
                  "name": "CODE",
                  "value": "'.$code.'"
                }
            ]
        }',
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'Accept: text/plain',
            'x-api-key: '.get_option("_dlr_sms_smsir_secretKey")
        ),
        ));
        
        $response = json_decode( curl_exec($curl) );
        
        curl_close($curl);

		// Save report
		$status = $response->status == 1 ? 1 : 0;
		self::save_report( 'smsir', $template, $mobile, $status, $response->message );

		// Save webserive in cookie
		set_transient('mobits_webservice', "smsir:$template", 30*60);
    }

	public static function send_ippanel_support ( $mobile, $code )
    {
		$username 	= get_option('_dlr_sms_ippanel_username', '' );
		$password 	= get_option('_dlr_sms_ippanel_password', '' );
		$from 		= get_option('_dlr_sms_ippanel_from', '' );
		$pattern_code = get_option('_dlr_sms_ippanel_theme', '' );
		$to 		= array($mobile);
		$input_data = array(
        	"verification-code" => $code
        );
		$url = "https://ippanel.com/patterns/pattern?username=" . $username . "&password=" . urlencode($password) . "&from=$from&to=" . json_encode($to) . "&input_data=" . urlencode(json_encode($input_data)) . "&pattern_code=$pattern_code";
		$handler = curl_init($url);
		curl_setopt($handler, CURLOPT_CUSTOMREQUEST, "POST");
		curl_setopt($handler, CURLOPT_POSTFIELDS, $input_data);
		curl_setopt($handler, CURLOPT_RETURNTRANSFER, true);
		$output = curl_exec($handler);
		
		// Save report
		$status = is_numeric($output) ? 1 : 0;
		self::save_report( 'ippanel', $pattern_code, $mobile, $status, self::ippanel_status( json_decode($output) ) );

		// Save webserive in cookie
		set_transient('mobits_webservice', "ippanel:$pattern_code", 30*60);
    }

	public static function send_kavenegar_support ( $mobile, $code )
    {
		$template   = get_option('_dlr_sms_kavenegar_theme');
		$key 		= get_option('_dlr_sms_kavenegar_apikey');
        
        $url = 'https://api.kavenegar.com/v1/'.$key.'/verify/lookup.json?';

		$fields = array(
			'receptor' 	=> $mobile,
			"template" 	=> $template,
			"token"		=> $code
		);

		$ch = curl_init();
		curl_setopt( $ch,CURLOPT_URL, $url );
		curl_setopt( $ch,CURLOPT_POST, true );
		curl_setopt( $ch,CURLOPT_POSTFIELDS, http_build_query($fields) );
		curl_setopt( $ch,CURLOPT_RETURNTRANSFER, true );
		curl_setopt( $ch,CURLOPT_SSL_VERIFYPEER, false );

		$response = json_decode(curl_exec($ch));
		curl_close($ch);

		// Save report
		$status = $response->return->status == 200 ? 1 : 0;
		$result = $response->return->status == 200 ? __('Message sended successfully', 'dlr') : $response->return->message;
		self::save_report( 'kavenegar', $template, $mobile, $status, $result);

		// Save webserive in cookie
		set_transient('mobits_webservice', "kavenegar:$template", 30*60);
    }

	public static function send_payamresan_rest_callback ( $data )
    {
		$status = self::sms_validation($data);
		if ( ! is_array($status) ) return $status;
	    
	    $code   	= $status[0]->code;
	    $mobile 	= sanitize_text_field( $data->get_header('mobits-number') );
		$template   = get_option('_dlr_sms_payamresan_theme');
        
        $params = array(
			'ApiKey' 		=> get_option('_dlr_sms_payamresan_accessKey'),
			'TemplateKey' 	=> $template,
			'Destination' 	=> $mobile,
			'p1' 			=> $code
		);

		$BaseUrl = "http://api.sms-webservice.com/api/V3/";

		$url = $BaseUrl.'SendTokenSingle?' . http_build_query($params);
		$curl = curl_init();
		curl_setopt_array($curl, array(
		CURLOPT_URL => $url,
		CURLOPT_RETURNTRANSFER => true,
		CURLOPT_ENCODING => '',
		CURLOPT_MAXREDIRS => 10,
		CURLOPT_TIMEOUT => 0,
		CURLOPT_FOLLOWLOCATION => true,
		CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		CURLOPT_CUSTOMREQUEST => 'GET',
		));

		$response = json_decode( curl_exec($curl) );
		curl_close($curl);

		// Save report
		$status = $response->Success == true ? 1 : 0;
		$result = $response->Success == true ? __('Message sended successfully', 'dlr') : $response->Error;
		self::save_report( 'payamresan', $template, $mobile, $status, $result);

		// Support webservice
		if ( $response->Success != true ) 
			self::run_support_webservice( $mobile, $code );

		// Save webserive in cookie
		set_transient('mobits_webservice', "payamresan:$template", 30*60);
    }

	public static function send_kavenegar_rest_callback ( $data )
    {
		$status = self::sms_validation($data);
		if ( ! is_array($status) ) return $status;
	    
	    $code   	= $status[0]->code;
	    $mobile 	= sanitize_text_field( $data->get_header('mobits-number') );
		$template   = get_option('_dlr_sms_kavenegar_theme');
		$key 		= get_option('_dlr_sms_kavenegar_apikey');
        
        $url = 'https://api.kavenegar.com/v1/'.$key.'/verify/lookup.json?';

		$fields = array(
			'receptor' 	=> $mobile,
			"template" 	=> $template,
			"token"		=> $code
		);

		$ch = curl_init();
		curl_setopt( $ch,CURLOPT_URL, $url );
		curl_setopt( $ch,CURLOPT_POST, true );
		curl_setopt( $ch,CURLOPT_POSTFIELDS, http_build_query($fields) );
		curl_setopt( $ch,CURLOPT_RETURNTRANSFER, true );
		curl_setopt( $ch,CURLOPT_SSL_VERIFYPEER, false );

		$response = json_decode(curl_exec($ch));
		curl_close($ch);

		// Save report
		$status = $response->return->status == 200 ? 1 : 0;
		$result = $response->return->status == 200 ? __('Message sended successfully', 'dlr') : $response->return->message;
		self::save_report( 'kavenegar', $template, $mobile, $status, $result);

		// Support webservice
		if ( $response->return->status != 200 ) 
			self::run_support_webservice( $mobile, $code );

		// Save webserive in cookie
		set_transient('mobits_webservice', "kavenegar:$template", 30*60);
    }

	public static function send_farapayamak_rest_callback ( $data )
    {
		$status = self::sms_validation($data);
		if ( ! is_array($status) ) return $status;
	    
	    $code   = $status[0]->code;
	    $mobile = sanitize_text_field( $data->get_header('mobits-number') );

		$fields_string = "";
		$bodyId = get_option('_dlr_sms_farapayamak_theme');

		$data = [
			'username' 	=> get_option('_dlr_sms_farapayamak_username'),
			'password' 	=> get_option('_dlr_sms_farapayamak_password'),
			'text' 		=> $code,
			'to' 		=> $mobile,
			'bodyId' 	=> $bodyId
		];

		if ( ! is_null($data) ) 
		{
			$fields_string = http_build_query($data);
		}

		$url = "https://rest.payamak-panel.com/api/SendSMS/BaseServiceNumber";

		$handle = curl_init();

		curl_setopt($handle, CURLOPT_URL, $url);
		curl_setopt($handle, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($handle, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($handle, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($handle, CURLOPT_POST, true);
		curl_setopt($handle, CURLOPT_POSTFIELDS, $fields_string);

		$server_output    = json_decode( curl_exec($handle) );
		
		// Save report
		$status = $server_output->RetStatus == 1 ? 1 : 0;
		$value = $status == 1 ? 1 : $server_output->Value;

		self::save_report( 'farapayamak', $bodyId, $mobile, $status, self::melipayamak_status($value) );

		// Support webservice
		if ( $server_output->RetStatus != 1 ) 
			self::run_support_webservice( $mobile, $code );

		// Save webserive in cookie
		set_transient('mobits_webservice', "farapayamak:$bodyId", 30*60);
    }

	public static function send_payamito_rest_callback ( $data )
    {
		$status = self::sms_validation($data);
		if ( ! is_array($status) ) return $status;
	    
	    $code   = $status[0]->code;
	    $mobile = sanitize_text_field( $data->get_header('mobits-number') );

		$fields_string = "";
		$bodyId = get_option('_dlr_sms_payamito_theme');

		$data = [
			'username' 	=> get_option('_dlr_sms_payamito_username'),
			'password' 	=> get_option('_dlr_sms_payamito_password'),
			'text' 		=> $code,
			'to' 		=> $mobile,
			'bodyId' 	=> $bodyId
		];

		if ( ! is_null($data) ) 
		{
			$fields_string = http_build_query($data);
		}

		$url = "https://rest.payamak-panel.com/api/SendSMS/BaseServiceNumber";

		$handle = curl_init();

		curl_setopt($handle, CURLOPT_URL, $url);
		curl_setopt($handle, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($handle, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($handle, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($handle, CURLOPT_POST, true);
		curl_setopt($handle, CURLOPT_POSTFIELDS, $fields_string);

		$server_output    = json_decode( curl_exec($handle) );
		
		// Save report
		$status = $server_output->RetStatus == 1 ? 1 : 0;
		$value = $status == 1 ? 1 : $server_output->Value;

		self::save_report( 'payamito', $bodyId, $mobile, $status, self::melipayamak_status($value) );

		// Support webservice
		if ( $server_output->RetStatus != 1 ) 
			self::run_support_webservice( $mobile, $code );

		// Save webserive in cookie
		set_transient('mobits_webservice', "payamito:$bodyId", 30*60);
    }

}