<?php
defined('ABSPATH') or die;

class Dlr_Public extends Mobits
{
	protected static $slug;

	public function __construct()
	{
		self::$slug = get_option('_dlr_page_slug', 'dlr-login-register');

		add_filter( 'query_vars', [$this, 'query_vars'] );
		add_action( 'wp', [$this, 'wp'] );
		add_action( 'init', [$this, 'init'] );
		add_action( 'template_redirect', [$this, 'template_redirect'] );
		add_filter( 'template_include', [$this, 'template_include'], 99 );
		add_filter( 'get_comment_author', [$this, 'get_comment_author'], 10, 3);
		add_filter( 'wp_logout', [$this, 'wp_logout'], 999);
		//add_filter( 'show_admin_bar' , [$this, 'show_admin_bar']);
	}

	public function show_admin_bar ()
	{
	    $user_id = get_current_user_id();
		if ( ! $user_id ) return false;
		
		$abf = get_user_meta( $user_id, 'show_admin_bar_front', true );
		if ( $abf != 'true' ) return false;
		
		global $current_user;
		global $wp_roles;
		$user_roles = $current_user->roles;

		if ( in_array( 'administrator', $user_roles ) && $abf == 'true' )
			return true;

		$roles = [];
		foreach( $user_roles as $role ) 
		{
			$roles[] = strtolower( $wp_roles->roles[$role]['name'] );
		}

		$limiteds = get_option('_limit_admin_bar_by_role', []);
		
		if ( empty( $limiteds ) ) return false;

		foreach ( $limiteds as $limited ) 
		{
			if ( in_array( $limited, $roles )  ) 
			{
				return false;
			}
		}
		return true;
	}

	public function query_vars ( $vars )
	{
	    $vars[] = self::$slug;
        return $vars;
	}

	public function wp()
	{
	    global $wp_query;
		
		add_rewrite_endpoint( get_option('_dlr_page_slug', 'dlr-login-register'), EP_ROOT );

		$options = parent::get_options(['_dlr_login_force_all']);
	    
	    if( $options['_dlr_login_force_all'] == 1 && ! is_user_logged_in() && !is_admin() && ! array_key_exists ( self::$slug , $wp_query->query_vars ) ) 
        {
            wp_redirect( home_url() .'/'. self::$slug );
            exit;
        }
	}

	public function init()
	{
		add_rewrite_endpoint( get_option('_dlr_page_slug', 'dlr-login-register'), EP_ROOT );
		
		if( !is_user_logged_in() && $GLOBALS['pagenow'] === 'wp-login.php' && get_option('_dlr_admin_login_redirect', 0) == 1 )
	    {
            wp_redirect(home_url() .'/'. get_option('_dlr_page_slug', 'dlr-login-register') . '?back='.home_url().'/wp-admin');
            exit;
        }
	}
	
	public function wp_logout($user_id)
	{
		$options = parent::get_options(['_dlr_redirect_logout']);
		
		$link = $options['_dlr_redirect_logout'] == '' ? home_url() : $options['_dlr_redirect_logout'];
		wp_redirect( $link );
		exit();
	}

	public function template_redirect() 
    {
		global $wp_query;

		$options = parent::get_options(['_dlr_redirect_logout', '_dlr_support_woocommerce', '_dlr_redirect_my_account', 'woocommerce_checkout_page_id', '_dlr_redirect_checkout']);
	    
	    if( isset( $wp_query->query_vars['customer-logout'] ) )
	    {
			// Logout user
	        wp_logout();

			// Redirect
			$link = $options['_dlr_redirect_logout'] == '' ? home_url() : $options['_dlr_redirect_logout'];
    		wp_redirect( $link );
    		exit();
	    }
        
		// If woocommerce options is active
        if( $options['_dlr_support_woocommerce'] == 1 )
        {
			// Redirect logout user from woocommerce to mobits
            if( class_exists( 'woocommerce' ) && is_account_page() && $options['_dlr_redirect_my_account'] == 1 && !is_user_logged_in() )
            { 
        		wp_redirect( home_url() . '/' . self::$slug );
        		exit;
            }
            
			// Redirect logout user from checkout to mobits
            $pageid = $options['woocommerce_checkout_page_id'];
        	if( !is_user_logged_in() && is_page($pageid) && $options['_dlr_redirect_checkout'] == 1 )
        	{
        		wp_redirect( home_url() . '/' . self::$slug . '?back='.urlencode(get_permalink($pageid)) );
        		exit;
        	}
        }
    }

	public function template_include($template) 
	{
	    global $wp_query;
	    
	    $slug  = urlencode(self::$slug);
	    $check = array_search( $slug, $wp_query->query_vars, true );

	    if ( array_key_exists ( self::$slug , $wp_query->query_vars ) || $check ) 
			$template = $this->template();

        return $template;
	}

	public function template()
	{
		$this->ok_mobits();
		return DLR_BASE . 'public/partials/class-dlr-forms.php';
	}

	protected static function dlr_set_cookie ($name, $val, $time)
	{
		if( isset( $_COOKIE[$name] ) ) unset( $_COOKIE[$name] );
		setcookie( $name, $val, $time );
	}

	public function get_comment_author( $author, $comment_ID, $comment )
	{
	    global $post;
	    
	    // Return if isn't product review
	    if ( $post->post_type != 'product' ) return $author;
	       
	    // Get comment author
	    $user = get_user_by( 'ID', $comment->user_id);
	    
	    // Return if author is guest
	    if ( $user==null ) return $author;
	    
	    // Return author
	    switch( get_option('_dlr_review_author', 'user_login') )
	    {
            case 'empty':
                return '';
                break;

			case 'user':
                return __('site user', 'dlr');
                break;

			case 'customer':
                return __('customer', 'dlr');
                break;
                
            case 'user_login':
                return $user->user_login;
                break;
	        
	        case 'name_family':
                $name = $user->first_name . ' ' . $user->last_name;
                return trim($name)!='' ? $name : __('No name', 'dlr');
                break;
	    }
	}
}