var resendTime = document.querySelector('#_dlr_resend_time').value;

function openTab(evt, cityName)
{
    var i, tabcontent, tablinks;
    
    tabcontent = document.getElementsByClassName("tabcontent");
    for (i = 0; i < tabcontent.length; i++) {
    	tabcontent[i].style.display = "none";
    }
    
    tablinks = document.getElementsByClassName("tablinks");
    for (i = 0; i < tablinks.length; i++) {
    	tablinks[i].className = tablinks[i].className.replace(" active", "");
    }
    
    document.getElementById(cityName).style.display = "block";
    evt.currentTarget.className += " active";
}

function openRegister()
{
    openTab(event, 'dlr-register');
    document.getElementById('dlr_login_tab').classList.remove('active');
    document.getElementById('dlr_register_tab').classList.add('active');
}

function InputpassValidate()
{
	const pass = document.querySelector('.loginMobile').value;
	const errorBox = document.querySelector('.login-register-alert');
	if( pass == '' )
    { 
        errorBox.innerHTML = error7;
        errorBox.setAttribute('style', 'display: block !important');
        return false;
    }
}

function forgetPassKeyPress()
{
	const errorBox = document.querySelector('.login-register-alert');
	errorBox.setAttribute('style', 'display: none !important');
}

function loginValidate()
{

	const lt = document.querySelector('#dlr_login_type').value;

    const mobile = document.querySelector('.loginMobile').value;
	const lwm = document.querySelector('input[name=_dlr_login_with_mobile]').value;
	const lwe = document.querySelector('input[name=_dlr_login_with_email]').value;

	var errorText1 = '';
	var errorText2 = '';
	if( lwm == 1 && lwe == 1 )
	{
		errorText1 = error1;
		errorText2 = error4;
	}
	else if( lwm == 1 && lwe == 0 )
	{
		errorText1 = error2;
		errorText2 = error5;
	}
	else if( lwm == 0 && lwe == 1 )
	{
		errorText1 = error3;
		errorText2 = error6;
	}
	else {
		errorText1 = error2;
		errorText2 = error5;
	}
    
    const errorBox = document.querySelector('.login-register-alert');
    
    if( mobile == '' )
    { 
        errorBox.innerHTML = errorText1;
        errorBox.setAttribute('style', 'display: block !important');
        return false;
    }

	if ( lt=='email' ) 
	{
		if( !/\S+@\S+\.\S+/.test(mobile)) 
		{
			errorBox.innerHTML = errorText2;
			errorBox.setAttribute('style', 'display: block !important');
			return false;
		}
	}

	else if ( lt=='mobile' ) 
	{
		if( mobile.length != 11 || ! /(\+98|0|98|0098)?([ ]|-|[()]){0,2}9[0-9]([ ]|-|[()]){0,2}(?:[0-9]([ ]|-|[()]){0,2}){8}/.test(fixNumbers(mobile)) ) 
		{
			errorBox.innerHTML = errorText2;
			errorBox.setAttribute('style', 'display: block !important');
			return false;
		}
	}

	else if ( lt=='emailmobile' )
	{
		if( ! /(\+98|0|98|0098)?([ ]|-|[()]){0,2}9[0-9]([ ]|-|[()]){0,2}(?:[0-9]([ ]|-|[()]){0,2}){8}/.test(fixNumbers(mobile)) && !/\S+@\S+\.\S+/.test(mobile))
		{
			errorBox.innerHTML = errorText2;
			errorBox.setAttribute('style', 'display: block !important');
			return false;
		}
	}
    
    if ( mobile.charAt(0) == '0' ) {
        localStorage.setItem('dlr-mobile', mobile);
    }else {
        localStorage.setItem('dlr-mobile', '0'+mobile);
    }
    
    
    var current = Number (Math.round(+new Date()/1000) );
    
    if ( ! localStorage.getItem('dlr-start') ) 
    {
        localStorage.setItem('dlr-start', current );
    }
    else 
    {
        var dlr_start = Number( localStorage.getItem('dlr-start') );
        
        if( current - dlr_start > resendTime ) 
        {
            localStorage.setItem('dlr-start', current );
        }
    }
    
    return true;
}

function loginValidatePassword()
{
	const lt = document.querySelector('#dlr_login_type').value;
	
    const mobile = document.querySelector('input[name=dlr_username]').value;
	const lwm = document.querySelector('input[name=_dlr_login_with_mobile]').value;
	const lwe = document.querySelector('input[name=_dlr_login_with_email]').value;

	var errorText1 = '';
	var errorText2 = '';
	if( lwm == 1 && lwe == 1 )
	{
		errorText1 = error1;
		errorText2 = error4;
	}
	else if( lwm == 1 && lwe == 0 )
	{
		errorText1 = error2;
		errorText2 = error5;
	}
	else if( lwm == 0 && lwe == 1 )
	{
		errorText1 = error3;
		errorText2 = error6;
	}
	else {
		errorText1 = error2;
		errorText2 = error5;
	}
    
    const errorBox = document.querySelector('.login-register-alert');
    
    if( mobile == '' )
    { 
        errorBox.innerHTML = errorText1;
        errorBox.setAttribute('style', 'display: block !important');
        return false;
    }

	if ( lt=='email' ) 
	{
		if( !/\S+@\S+\.\S+/.test(mobile)) 
		{
			errorBox.innerHTML = errorText2;
			errorBox.setAttribute('style', 'display: block !important');
			return false;
		}
	}

	else if ( lt=='mobile' ) 
	{
		if( mobile.length != 11 || ! /(\+98|0|98|0098)?([ ]|-|[()]){0,2}9[0-9]([ ]|-|[()]){0,2}(?:[0-9]([ ]|-|[()]){0,2}){8}/.test(fixNumbers(mobile)) ) 
		{
			errorBox.innerHTML = errorText2;
			errorBox.setAttribute('style', 'display: block !important');
			return false;
		}
	}

	else if ( lt=='emailmobile' )
	{
		if( ! /(\+98|0|98|0098)?([ ]|-|[()]){0,2}9[0-9]([ ]|-|[()]){0,2}(?:[0-9]([ ]|-|[()]){0,2}){8}/.test(fixNumbers(mobile)) && !/\S+@\S+\.\S+/.test(mobile))
		{
			errorBox.innerHTML = errorText2;
			errorBox.setAttribute('style', 'display: block !important');
			return false;
		}
	}

	const password = document.querySelector('input[name=dlr_password]').value;

	if ( password == '' ) 
	{
		errorBox.innerHTML = error7;
		errorBox.setAttribute('style', 'display: block !important');
		return false;
	}
    
    return true;
}

function dlrTimer() 
{
    var dlr_start = Number( localStorage.getItem('dlr-start') );
    var current = Number( Math.round(+new Date()/1000) );
    
    var time = current - dlr_start;
    
    if( time > resendTime ) 
    {
        document.getElementById('continueCode').setAttribute('style', 'display:none !important');
        document.getElementById('time').setAttribute('style', 'display:none !important');

        document.getElementById('endTimeCode').setAttribute('style', 'display:block !important');
        
        var mobile = localStorage.getItem('dlr-mobile')
        document.querySelector("#dlr-repeat-form").innerHTML = '<input name="codeMobile" type="hidden" id="codeMobile1" value="'+mobile+'" /><input type="submit" name="dlr-sendAgain" class="repeatCode" value="'+sendAgainBtnValue+'"><input type="hidden" name="_dlr_mobits" value="repeatcode" />';

		var fields = document.querySelectorAll('.codeBox');
		for (var i = 0; i < fields.length; ++i) 
		{
			fields[i].disabled = true;
		}
    }
    
    else {
        
        var remain = resendTime - time,
		display = document.querySelector('#time');
		startTimer(remain, display);
        
    }
}

function startTimer(duration, display) 
{
	var timer = duration, minutes, seconds;
	setInterval(function () {
		minutes = parseInt(timer / 60, 10);
		seconds = parseInt(timer % 60, 10);

		minutes = minutes < 10 ? "0" + minutes : minutes;
		seconds = seconds < 10 ? "0" + seconds : seconds;

		display.textContent = minutes + ":" + seconds;
		if (--timer < 0) 
		{
		    
			document.querySelector( '#time' ).setAttribute('style', 'display:none !important');
			document.getElementById('endTimeCode').setAttribute('style', 'display:block !important');
			
			if( !document.getElementById("codeMobile1") ) 
			{
			    var mobile = localStorage.getItem('dlr-mobile');
			    
                document.querySelector("#dlr-repeat-form").innerHTML = '<input name="codeMobile" type="hidden" id="codeMobile1" value="'+mobile+'" /><input type="submit" name="dlr-sendAgain" class="repeatCode" value="'+sendAgainBtnValue+'"><input type="hidden" name="_dlr_mobits" value="repeatcode" />';
			}
			
            document.getElementById('continueCode').setAttribute('style', 'display:none !important');
            document.querySelector('.login-register-alert').setAttribute('style', 'display:none !important');
            
			var fields = document.querySelectorAll('.codeBox');
			for (var i = 0; i < fields.length; ++i) 
			{
				fields[i].disabled = true;
			}
			return;
		}
	}, 1000);
}

function repeatValidate () 
{
    var current = Number (Math.round(+new Date()/1000) );
    localStorage.setItem('dlr-start', current );
    
    return true;
}

var persianNumbers = [/۰/g, /۱/g, /۲/g, /۳/g, /۴/g, /۵/g, /۶/g, /۷/g, /۸/g, /۹/g],
arabicNumbers  = [/٠/g, /١/g, /٢/g, /٣/g, /٤/g, /٥/g, /٦/g, /٧/g, /٨/g, /٩/g],
fixNumbers = function (str) {
    if(typeof str === 'string') {
        
    	for(var i=0; i<10; i++)
    	{
    	    str = str.replace(persianNumbers[i], i).replace(arabicNumbers[i], i);
    	}
    	
    }
    return str;
};

function onFocusEvent(index) {
    
	for (item = 1; item < index; item++) {
		const currentElement = getCodeBoxElement(item);
		if (!currentElement.value) {
			currentElement.focus();
			break;
		}
	}
}

function loginMobileKeyPress(){
	const errorBox = document.querySelector('.login-register-alert');
	errorBox.setAttribute('style', 'display: none !important');
}

function registerMobileKeyPress(){
    
	const errorBox = document.querySelector('.register-register-alert');
	errorBox.setAttribute('style', 'display: none !important');

	const errorBox2 = document.querySelector('.login-register-alert');
	errorBox2.setAttribute('style', 'display: none !important');
}

function registerNameKeyPress(){
    
	const errorBox = document.querySelector('.register-register-alert');
	errorBox.setAttribute('style', 'display: none !important');
}

function registerUsernameKeyPress(){
    
	const errorBox = document.querySelector('.register-register-alert');
	errorBox.setAttribute('style', 'display: none !important');
}

function validateMyFormRecovery() 
{
    const username = document.querySelector('#dlr-login-input-name-field').value;
    const password = document.querySelector('#dlr-login-input-password-field').value;
    const mobile = document.querySelector('#dlr-login-input-mobile2-field').value;
    
    const errorBox = document.querySelector('.recovery-alert');
    
    if( username == '' )
    { 
        errorBox.innerHTML = error12;
        errorBox.setAttribute('style', 'display: block !important');
        return false;
    }
    
    if( password == '' )
    { 
        errorBox.innerHTML = error7;
        errorBox.setAttribute('style', 'display: block !important');
        return false;
    }
    
    if( mobile == '' )
    { 
        errorBox.innerHTML = error2;
        errorBox.setAttribute('style', 'display: block !important');
        return false;
    }
    
    if( ! /(\+98|0|98|0098)?([ ]|-|[()]){0,2}9[0-9]([ ]|-|[()]){0,2}(?:[0-9]([ ]|-|[()]){0,2}){8}/.test(fixNumbers(mobile)) )
    {
        errorBox.innerHTML = error5;
        errorBox.setAttribute('style', 'display: block !important');
        return false;
    }
  
    localStorage.setItem('dlr-mobile', mobile);
    
    var current = Number (Math.round(+new Date()/1000) );
    
    if ( ! localStorage.getItem('dlr-start') ) 
    {
        localStorage.setItem('dlr-start', current );
    }
    else 
    {
        var dlr_start = Number( localStorage.getItem('dlr-start') );
        
        if( current - dlr_start > resendTime ) 
        {
            localStorage.setItem('dlr-start', current );
        }
    }

    return true;
}

function element_exists(selector)
{
	const element = document.querySelector(selector);
	return typeof(element) != 'undefined' && element != null ? element : false;
}

function repeatCodeAgain()
{
    if( document.getElementById('code-alert') )
    {
        document.querySelector('.code-alert').setAttribute('style', 'display:none !important');
    }
}

function checkEmpty()
{
	var fields = document.querySelectorAll('.codeBox');
	for (var i = 0; i < fields.length; ++i) 
	{
		if ( fields[i].value == '') return true;
	}
	return false;
}

function confirmValidate()
{
	var codes = '';
	var fields = document.querySelectorAll('.codeBox');
	for (var i = 0; i < fields.length; ++i) 
	{
		codes += fields[i].value;
	}
	document.getElementById('userCode').value = codes;
    
    const errorBox = document.querySelector('.login-register-alert');
    
    if( checkEmpty() )
    { 
        errorBox.innerHTML = error16;
        errorBox.setAttribute('style', 'display: block !important');
        return false;
    }

    return true;
}

function goTimer(delay)
{
	if(Number(delay)>resendTime)
	{
		var el = document.querySelector( '#time' );
		el.setAttribute('style', 'display:none !important');
		document.getElementById("continueCode").disabled = true;
		var mobile = localStorage.getItem('dlr-mobile')
        document.querySelector("#dlr-repeat-form").innerHTML = '<input name="codeMobile" type="hidden" id="codeMobile1" value="'+mobile+'" /><input type="submit" name="dlr-sendAgain" class="repeatCode" value="'+sendAgainTxt+'">';
            
	}
	else
	{
		window.onload = function () {
			var fiveMinutes = resendTime-delay,
			display = document.querySelector('#time');
			startTimer(fiveMinutes, display);
		};
	}
}

/**
 * code cofirmation
 */
function getCodeBoxElement(index) 
{
	return document.getElementById('codeBox' + index);
}
function onKeyUpEvent(index, event) 
{
	const eventCode = event.which || event.keyCode;
	if (getCodeBoxElement(index).value.length === 1) 
	{
		var numberCodes2 = document.querySelector("#_dlr_number_of_codes").value;
		if ( index != numberCodes2 ) 
		{
			getCodeBoxElement(index + 1).focus();
		} else 
		{
			getCodeBoxElement(index).blur();
		
			var codes = '';
			var fields = document.querySelectorAll('.codeBox');
			for (var i = 0; i < fields.length; ++i) 
			{
				codes += fields[i].value;
			}
			document.getElementById('userCode').value = codes;
			var autoConfirm = document.querySelector("#_dlr_auto_confirm").value;

            if( autoConfirm == 1 ) 
            {
                document.getElementById('confirm-loader').setAttribute('style', 'display: block !important');
    			document.getElementById('confirm-continue').setAttribute('style', 'display: none !important');
    			document.getElementById('continueCode').style.cursor = 'auto';
    			document.getElementById('continueCode').click();
    			document.getElementById("continueCode").disabled = true;
            }
			
        }
    }
    
    if (eventCode === 8 && index !== 1) {
    	getCodeBoxElement(index - 1).focus();
    }
}

function onFocusEvent(index) {
	for (item = 1; item < index; item++) {
		const currentElement = getCodeBoxElement(item);
		if (!currentElement.value) {
			currentElement.focus();
			break;
		}
	}
}

function filterFunction() {
  var input, filter, ul, li, a, i;
  input = document.getElementById("myInput");
  filter = input.value.toUpperCase();
  div = document.getElementById("myDropdown");
  a = div.getElementsByTagName("a");
  for (i = 0; i < a.length; i++) {
    txtValue = a[i].textContent || a[i].innerText;
    if (txtValue.toUpperCase().indexOf(filter) > -1) {
      a[i].style.display = "";
    } else {
      a[i].style.display = "none";
    }
  }
}

// Start timer

if ( document.querySelector('#dlr_page').value == 'confirm' ) 
{
    dlrTimer();
}
else 
{
    var now = Date.now()/1000;
    var time = Number(localStorage.getItem('dlr-start'));
    if( Math.floor(now-time) > resendTime ){
        localStorage.clear();
    }
}


// Enable register tab

if( window.location.hash == '#register' ) 
{
	const login = document.getElementById("dlr_login_tab");
	const register = document.getElementById("dlr_register_tab");

	const login_content = document.getElementById("dlr-login");
	const register_content = document.getElementById("dlr-register");

	login.classList.remove("active");
	register.classList.add("active");

	login_content.classList.remove("active");
	register_content.classList.add("active");

	document.querySelector(".registerName").focus();
}