<?php
defined('ABSPATH') or die;

class Dlr_Public_Forms extends Dlr_Public
{
	protected static $public_options;

	function __construct()
	{
		$this->define_constants();
		
		self::dlr_init();
	}

	protected function define_constants()
	{
		$this->define( 'DLR_PARTIALS', dirname( __FILE__ ) . '/' );
	}

	public static function dlr_init ()
	{
		self::isuser();

		self::backUrl();

		self::dlr_controller();

		self::$public_options = self::dlr_public_options();
		self::include();
	    
	    if( !is_user_logged_in() && $GLOBALS['pagenow'] === 'wp-login.php' && get_option('_dlr_admin_login_redirect', 0) == 1 )
	    {
            wp_redirect(home_url() .'/'. get_option('_dlr_page_slug', 'dlr-login-register') . '?back='.home_url().'/wp-admin');
            exit;
        }
	}

	public static function dlr_controller () 
	{
	    if ( isset( $_POST['_dlr_mobits'] ) )
			require_once DLR_PARTIALS . 'forms/class-dlr-'.$_POST["_dlr_mobits"].'.php';
	}

	protected static function isuser()
	{
		if( is_user_logged_in() )
		{
			wp_redirect( get_option('_dlr_redirect_url', home_url() ) );
			exit;
		}
	}

	protected static function backUrl()
	{
		if ( isset( $_GET['back'] ) ) 
		{
			parent::dlr_set_cookie( 'mobits_back', $_GET['back'], time()+1800 );
		}
		else if ( get_option('_dlr_redirect_previous_page') == 1 && isset( $_SERVER['HTTP_REFERER'] ) ) 
		{
			$back = $_SERVER['HTTP_REFERER'];

			if ( ! str_contains($back, parent::$slug) ) 
			{
				parent::dlr_set_cookie( 'mobits_back', sanitize_text_field($back), time()+1800 );
			}
		}

		else if ( isset( $_COOKIE['mobits_back'] ) ) {}

		else { unset( $_COOKIE['mobits_back'] ); }
	}

	protected static function dlr_public_options()
	{
		return parent::get_options([
			'_dlr_dark_mode_status',
			'_dlr_auto_confirm',
			'_dlr_favicon',
			'_dlr_extra_style',
			'_dlr_color_tab',
			'_dlr_form_width',
			'_dlr_login_status',
			'_dlr_register_status',
			'_dlr_page_slug',
			'_dlr_logo',
			'_dlr_description',
			'_dlr_color',
			'_dlr_design_type',
			'_dlr_background_image',
			'_dlr_button_image',
			'_dlr_google_captcha_in_login_form',
			'_dlr_google_captcha_in_register_form',
			'_dlr_google_captcha_in_recovery_form',
			'_dlr_google_recaptchav2_site_key',
			'_dlr_resend_code_time',
			'_dlr_register_in_login_form',
			'_dlr_login_with_password_status',
			'_dlr_forget_password',
			'_dlr_recovery_status',
			'_dlr_password_field_in_register_status',
			'_dlr_name_field_in_register_status',
			'_dlr_family_field_in_register_status',
			'_dlr_login_with_mobile',
			'_dlr_login_with_email',
			'_dlr_display_header',
			'_dlr_display_footer',
			'_dlr_checkout_notif',
			'_dlr_login_with_mobile',
			'_dlr_login_with_email',
			'_dlr_password_rules_required',
			'_dlr_password_rules_ten_character',
			'_dlr_password_rules_one_letter',
			'_dlr_password_rules_one_specials',
			'_dlr_number_of_codes',
			'_dlr_display_return_back_btn',
			'_dlr_return_back_btn_text',
			'_dlr_login_priority',
			'_dlr_email_field_in_register_status',
			'_dlr_email_field_required_in_register'
		]);
	}

	protected static function is_login_active()
	{
		return self::$public_options['_dlr_login_status'] == 1 && ( self::$public_options['_dlr_login_with_mobile'] == 1 || self::$public_options['_dlr_login_with_email'] == 1 ) ? true : false;
	}

	protected static function is_email_exists()
	{
		// if input isnt email
		if ( $_COOKIE['mobits_input'] != 'email' ) return true;

		// If email not exists
		if ( ! self::dlr_user_email_exist_check( $_COOKIE['mobits_number'] ) ) return false;

		return true;
	}

	protected static function include()
	{
		self::check_recovery();

		self::template_loader('templates/header');

		$types = [
			'recovery',
			'inputpass',
			'forgetpass',
			'sendemail'
		];
    
		if( ! isset( $_GET['type'] ) ) 
		{
		    self::template_loader('templates/primary');
		}
		else if ( isset( $_GET['type'] ) && in_array( $_GET['type'], $types ) ) 
		{
		    self::template_loader('templates/'.$_GET['type'].'-form');
		}
		else 
		{
			self::template_loader('templates/confirm-form');
		}

		self::template_loader('templates/footer');

		if( self::$public_options['_dlr_display_footer'] == 1 ) get_footer();
	}

	public static function dlr_form_title()
	{
		if( isset($_GET['type']) ) 
		{
			switch( $_GET['type'] ) {
				case 'login':
					return __('Login', 'dlr');
					break;
				case 'register':
					return __('Register', 'dlr');
					break;
				case 'recovery':
					return __('Recovery', 'dlr');
					break;
				case 'inputpass':
					return __('Inter password', 'dlr');
					break;
				case 'forgetpass':
					return __('Recover or create password', 'dlr');
					break;
				case 'sendemail':
					if(isset($_GET['hash']))
						return __('Password change', 'dlr');
					else
						return __('Send email', 'dlr');
					break;
			}
		}
	}

	protected static function check_recovery()
	{
		if( isset($_GET['type']) && $_GET['type'] == 'recovery' && get_option('_dlr_recovery_status', 0) != 1 ) 
		{
			wp_redirect( home_url() . '/'. get_option('_dlr_page_slug', 'dlr-login-register') );
			exit;
		}

		return true;
	}
	
	public static function backArrowUrl() 
    {
        return bloginfo('url') . '/' . esc_attr( get_option('_dlr_page_slug', 'dlr-login-register') );
    }

	public static function dlr_user_exist_check ($mobile)
	{
		//create mobile without zero
		$mobile2 = substr($mobile, 1);
	    
		//check mobiles in usernames
		$table = parent::$wpdb->prefix . 'users';
		$user  = parent::$wpdb->get_row(parent::$wpdb->prepare("SELECT * FROM $table WHERE user_login IN (%d,%s)", $mobile, $mobile2));
		if($user) return $user;

		//check mobile in usermeta
		if( get_option('_dlr_support_digits', 0) == 1 ) 
		{
			$users = get_users(
				array(
					'meta_query'=> array(
						'relation'  => 'or',
						array(
							'key' => 'digits_phone_no',
							'value' => $mobile2
						),
						array(
							'key' => 'digits_phone',
							'value' => '+98'.$mobile2
						)
					)
				)
			);

			if( $users != null && isset($users[0]) ) return $users[0];
		}

		return false;
	}

	protected static function template_loader($path)
	{
		require DLR_PARTIALS . 'forms/' . $path . '.php';
	}

	protected static function dlr_js_errors()
	{
		?>
		<script>
			const error1 = '<?php echo __("Please enter your mobile number or email", "dlr"); ?>';
			const error2 = '<?php echo __("Please enter your mobile number", "dlr"); ?>';
			const error3 = '<?php echo __("Please enter your email", "dlr"); ?>';
			const error4 = '<?php echo __("Please enter a valid mobile number or email", "dlr"); ?>';
			const error5 = '<?php echo __("Please enter a valid mobile number", "dlr"); ?>';
			const error6 = '<?php echo __("Please enter a valid email", "dlr"); ?>';

			const error7 	= '<?php echo __("Please enter your password", "dlr"); ?>';
			const error8 	= '<?php echo __("Entered passwords are not the same", "dlr"); ?>';
			const error9 	= '<?php echo __("Password must contain at least ten characters", "dlr"); ?>';
			const error10 	= '<?php echo __("Password must contain at least one English letter", "dlr"); ?>';
			const error11 	= '<?php echo __("The password must contain a special character", "dlr"); ?>';

			const error12 	= '<?php echo __("Please enter your email or username", "dlr"); ?>';
			const error13 	= '<?php echo __("Please enter your name and family", "dlr"); ?>';
			const error14 	= '<?php echo __("Please enter your username", "dlr"); ?>';
			const error15 	= '<?php echo __("Username must contain at least six characters", "dlr"); ?>';

			const error16 	= '<?php echo __("Please enter the verification code in full", "dlr"); ?>';

			const sendAgainTxt 	= '<?php echo __("Resend the code", "dlr"); ?>';
			var resendTime = '<?php echo self::$public_options['_dlr_resend_code_time']; ?>';
		</script>
		<?php
	}

	protected static function dlr_public_font()
	{
		$font = get_option('_dlr_public_font', 'iranyekan');
		$font_name = $font=='iranyekan' ? 'iranyekanweblightfanum' : 'IRANSansX-Regular';

		?>
		<style>
	    @font-face{
			font-family: Mobits;
			src: url(<?php echo DLR_BASE_URL; ?>public/fonts/<?php echo $font_name; ?>.woff) format('woff');		
		}

		* {
			font-family:Mobits;
			-moz-font-feature-settings: "ss02";
			-webkit-font-feature-settings: "ss02";
			font-feature-settings: "ss02";
		}
	    </style>

		<?php
	}

	protected static function no_slash($string)
	{	
		if(substr($string, -1) == '/') {
			return substr($string, 0, -1);
		}
		return $string;
	}

	protected static function dlr_login_lable()
	{
		$options = self::get_options(['_dlr_login_with_mobile','_dlr_login_with_email']);

		if( $options['_dlr_login_with_mobile'] == 1 && $options['_dlr_login_with_email'] == 1 )
		{
			return __('Enter your mobile number or email', 'dlr');
		}
		else if( $options['_dlr_login_with_mobile'] == 1 && $options['_dlr_login_with_email'] == 0 )
		{
			return __('Enter your mobile number', 'dlr');
		}
		else if( $options['_dlr_login_with_mobile'] == 0 && $options['_dlr_login_with_email'] == 1 )
		{
			return __('Enter your email', 'dlr');
		}
	}

	protected static function dlr_login_lable2()
	{
		$options = self::get_options(['_dlr_login_with_mobile','_dlr_login_with_email']);

		if( $options['_dlr_login_with_mobile'] == 1 && $options['_dlr_login_with_email'] == 1 )
		{
			return __('mobile number/email', 'dlr');
		}
		else if( $options['_dlr_login_with_mobile'] == 1 && $options['_dlr_login_with_email'] == 0 )
		{
			return __('mobile number', 'dlr');
		}
		else if( $options['_dlr_login_with_mobile'] == 0 && $options['_dlr_login_with_email'] == 1 )
		{
			return __('email', 'dlr');
		}
	}

	protected static function isMobile() 
    {
		if( get_option('_dlr_login_with_email') == 1 ) return false;

        return preg_match("/(android|avantgo|blackberry|bolt|boost|cricket|docomo|fone|hiptop|mini|mobi|palm|phone|pie|tablet|up\.browser|up\.link|webos|wos)/i", $_SERVER["HTTP_USER_AGENT"]);
    }

	protected static function convert( $string ) {
        $persian = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
        $arabic = ['٩', '٨', '٧', '٦', '٥', '٤', '٣', '٢', '١','٠'];
    
        $num = range(0, 9);
        $convertedPersianNums = str_replace($persian, $num, $string);
        $englishNumbersOnly = str_replace($arabic, $num, $convertedPersianNums);
        
        return $englishNumbersOnly;
    }

	protected static function dlr_user_email_exist_check($email)
	{
		$user_id = email_exists($email);
		return $user_id ? get_user_by('ID', $user_id) : false;
	}

	protected static function dlr_not_found_user_or_wrong_password ()
	{
		if(isset($_GET['status']) && $_GET['status']==0 ) 
		{
			if($_GET['input'] == 'mobile') 
			{
				return '<div id="code-alert" class="code-alert">
				'. __('No user with mobile number', 'dlr') .' '. $_COOKIE["mobits_number"] .' '. __('no found.', 'dlr').' 
				<a href="'.home_url().'/'.get_option('_dlr_page_slug', 'login-register').'#register">ثبت نام</a></div>';
			}
			else 
			{
				return '<div id="code-alert" class="code-alert">
				'. __('No user with email', 'dlr') .' '. $_COOKIE["mobits_number"] .' '. __('no found.', 'dlr').' 
				<a href="'.home_url().'/'.get_option('_dlr_page_slug', 'login-register').'#register">ثبت نام</a></div>';
			}
		}
		else if(isset($_GET['status']) && $_GET['status']==-1 ) 
		{
			return '<div id="code-alert" class="code-alert code-alert-pass">
			'. __('The password is wrong.', 'dlr').' 
			</div>';
		}
	}

	protected static function dlr_display_forget_password_link()
	{
		$options = parent::get_options(['_dlr_forget_password','_dlr_forget_password_email']);

		$dlrfpm = $options['_dlr_forget_password'];
		$dlrfpe = $options['_dlr_forget_password_email'];

		$link = '';

		if( $dlrfpm!=1 && $dlrfpe!=1 ) { return; }

		else if( $dlrfpm==1 && $dlrfpe==1 ) 
		{
			$link = isset($_GET['input']) && $_GET['input'] == 'email' ? '?type=sendemail' : '?type=forgetpass';
		}
		else if( $dlrfpm==1 && $dlrfpe!=1 ) 
		{
			$link = $_COOKIE['mobits_input'] == 'mobile' ? '?type=forgetpass' : '';
			
		}
		else if( $dlrfpm!=1 && $dlrfpe==1 && isset($_GET['input']) && $_GET['input'] == 'email' ) 
		{
			$link = '?type=sendemail';
		}

		$text = $_COOKIE['mobits_input'] == 'email' ? __("Recover a password", "dlr") : __("Recover or create a password", "dlr");
		
		$output = '
		<div class="dlr_login_with_password">
			<a href="'.$link.'">'.$text.'<span>></span></a>
		</div>';

		return $link!='' ? $output : '';
	}

	protected static function create_user_code($mobile, $repeat=false) 
	{
		// Current time
        $now = time();

		// Check code existance
		$table = parent::$table;
	    $check = parent::$wpdb->get_row( parent::$wpdb->prepare( "SELECT * FROM $table WHERE mobile=%s", $mobile ) );

		// Code is available
	    if( $check !== NULL )
	    {
			// Check code expiration
	        if( (int)$now-(int)$check->time > (int)get_option('_dlr_resend_code_time', 120) )
	        {	
				// Send sms
				self::dlr_send_sms( $mobile, $repeat );

				// Update code
	            parent::$wpdb->update( $table, array(
                    'code'   => self::randomNumber( get_option('_dlr_number_of_codes', 4) ),
                    'time'   => time()
                ), array(
                    'mobile' => $mobile
                ));
	        }
	    }
		// If code is not avilable
	    else 
		{
			// Insert new code
	        parent::$wpdb->insert( $table, array(
                'code'   => self::randomNumber( get_option('_dlr_number_of_codes', 4) ),
                'mobile' => $mobile,
                'time'   => time()
            ));
			
			// Send sms
			self::dlr_send_sms( $mobile, $repeat );
	    }
		
	}

	protected static function randomNumber($length) {
		$result = '';

		for($i = 0; $i < $length; $i++) {
			$result .= mt_rand(1, 9);
		}

		return $result;
	}

	protected static function dlr_send_sms( $mobile, $repeat ) 
	{
	    $dlr_sms_service = get_option('_dlr_sms_service', 'melipayamak' );

		self::{$dlr_sms_service}( $mobile, $repeat );
	}

	protected static function melipayamak ( $mobile, $repeat ) 
	{
	    ?>
	    <script>
    	    var xhr = new XMLHttpRequest();
        	xhr.open('Post', '<?php echo home_url(); ?>/wp-json/api/sendSmsMelliPayamak');
        	xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
			xhr.setRequestHeader('Repeat-to', '<?php echo $repeat; ?>' );
			xhr.setRequestHeader('mobits-number', '<?php echo $mobile; ?>' );
        	xhr.onload = function() {};
        	xhr.send();
    	</script>
	    <?php
	}

	protected static function farapayamak ( $mobile, $repeat ) 
	{
	    ?>
	    <script>
    	    var xhr = new XMLHttpRequest();
        	xhr.open('Post', '<?php echo home_url(); ?>/wp-json/api/sendSmsFaraPayamak');
        	xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
			xhr.setRequestHeader('Repeat-to', '<?php echo $repeat; ?>' );
			xhr.setRequestHeader('mobits-number', '<?php echo $mobile; ?>' );
        	xhr.onload = function() {};
        	xhr.send();
    	</script>
	    <?php
	}

	protected static function kavenegar ( $mobile, $repeat ) 
	{
	    ?>
	    <script>
    	    var xhr = new XMLHttpRequest();
        	xhr.open('Post', '<?php echo home_url(); ?>/wp-json/api/sendKavenegar');
        	xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
			xhr.setRequestHeader('Repeat-to', '<?php echo $repeat; ?>' );
			xhr.setRequestHeader('mobits-number', '<?php echo $mobile; ?>' );
        	xhr.onload = function() {};
        	xhr.send();
    	</script>
	    <?php
	}

	protected static function smsir ( $mobile, $repeat ) 
	{
	    ?>
	    <script>
    	    var xhr = new XMLHttpRequest();
        	xhr.open('Post', '<?php echo home_url(); ?>/wp-json/api/sendSmsIr');
        	xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
			xhr.setRequestHeader('Repeat-to', '<?php echo $repeat; ?>' );
			xhr.setRequestHeader('mobits-number', '<?php echo $mobile; ?>' );
        	xhr.onload = function() {};
        	xhr.send();
    	</script>
	    <?php
	}

	protected static function payamresan ( $mobile, $repeat ) 
	{
	    ?>
	    <script>
    	    var xhr = new XMLHttpRequest();
        	xhr.open('Post', '<?php echo home_url(); ?>/wp-json/api/sendPayamresan');
        	xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
			xhr.setRequestHeader('Repeat-to', '<?php echo $repeat; ?>' );
			xhr.setRequestHeader('mobits-number', '<?php echo $mobile; ?>' );
        	xhr.onload = function() {};
        	xhr.send();
    	</script>
	    <?php
	}

	protected static function ippanel ( $mobile, $repeat )
    {
        ?>
	    <script>
    	    var xhr = new XMLHttpRequest();
        	xhr.open('Post', '<?php echo home_url(); ?>/wp-json/api/sendSmsIppanel');
        	xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
			xhr.setRequestHeader('Repeat-to', '<?php echo $repeat; ?>' );
			xhr.setRequestHeader('mobits-number', '<?php echo $mobile; ?>' );
        	xhr.onload = function() {};
        	xhr.send();
    	</script>
	    <?php
    }

	protected static function payamito ( $mobile, $repeat )
    {
        ?>
	    <script>
    	    var xhr = new XMLHttpRequest();
        	xhr.open('Post', '<?php echo home_url(); ?>/wp-json/api/sendPayamito');
        	xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
			xhr.setRequestHeader('Repeat-to', '<?php echo $repeat; ?>' );
			xhr.setRequestHeader('mobits-number', '<?php echo $mobile; ?>' );
        	xhr.onload = function() {};
        	xhr.send();
    	</script>
	    <?php
    }

	protected static function check_user_code($code, $mobile) 
	{
		$table = parent::$table;
	    $check = parent::$wpdb->get_row( parent::$wpdb->prepare( "SELECT * FROM $table WHERE mobile=%d AND code=%s", $mobile, $code ) );
		
	    return ($check==NULL) ? false : true;
	}

	protected static function delete_user_code($mobile) 
	{
        parent::$wpdb->delete( parent::$table, array( 'mobile'=> $mobile ) );
	}

	protected static function dlr_login_and_redirect($user, $code=null) 
	{
		//If user does not exist (false), return false (Depend on dlr_user_exist_check function);
		if(!$user) return false;

		//get options 
		$options = parent::get_options([
			'_dlr_last_login',
			'_dlr_support_woocommerce',
			'_dlr_redirect_checkout',
			'_dlr_redirect_url',
			'woocommerce_checkout_page_id',
			'_dlr_redirect_by_role_role',
			'_dlr_redirect_by_role_address'
		]);

		//Delete code if exist
		if($code!=null) self::delete_user_code( $_COOKIE['mobits_number'] );

		if( get_user_meta($user->ID, 'dlr_user_status', true) == '0' || ( isset( $_COOKIE['mobits_number'] ) && self::dlr_mobile_block( $_COOKIE['mobits_number'] ) ) ) 
			wp_die( __("Your access to this site is restricted. Please contact the site administrator.", "dlr") );

		//Logins user
		wp_clear_auth_cookie();
		wp_set_current_user($user->ID);
		wp_set_auth_cookie($user->ID, true);

		//Save login time
		if( $options['_dlr_last_login'] == 1 )
			update_user_meta( $user->ID, 'dlr_last_login', time() );

		//Redirect user
		if( 
			$options['_dlr_support_woocommerce'] == 1 && $options['_dlr_redirect_checkout'] == 1 && isset( $_COOKIE['mobits_back'] ) && self::no_slash( urldecode( $_COOKIE['mobits_back'] ) ) == self::no_slash( get_permalink( $options['woocommerce_checkout_page_id'] ) )
		){
			wp_redirect( urldecode( $_COOKIE['mobits_back'] ) );
			exit;
		}
		else if ( current_user_can('administrator') ) 
		{
			exit( wp_redirect( admin_url() ) );
		}
		else if ( isset( $_COOKIE['mobits_back'] ) )
		{
			exit( wp_redirect( $_COOKIE['mobits_back'] ) );
		}
		else 
		{
			$rr 	= self::redirect_url($user);
			$url 	= $rr ? $rr : $options['_dlr_redirect_url'];

			wp_redirect( $url );
			exit;
		}
	}

	private static function redirect_url ($user)
	{
		$roles 		= get_option('_dlr_redirect_by_role_role', []);
		$addresses 	= get_option('_dlr_redirect_by_role_address', []);

		if ( !isset( $roles[0] ) ) return false;

		$user_meta = get_userdata($user->ID);
		$current_roles = ( array ) $user_meta->roles;

		foreach ( $roles as $key=>$role ) 
		{
			if ( in_array( $role, $current_roles ) ) {
				return $addresses[$key];
			}
		}

		return false;
	}

	/**
	* Create user
	*
	*/
	protected static function create_user ( $mobile )
	{
		// if the user exists, return true
		$user = self::dlr_user_exist_check($mobile);
	    if( self::dlr_user_exist_check($mobile) ) return $user;

		// Get some options
		$options = parent::get_options([
			'_dlr_support_woocommerce',
			'_dlr_save_name_in_woocommerce',
			'_dlr_save_mobile_in_woocommerce',
			'_dlr_save_family_in_woocommerce',
			'_dlr_name_field_in_register_status',
			'_dlr_family_field_in_register_status',
			'_dlr_welcome_sms_status'
		]);
	    
		/* The new user comes from the login form and must be registered. 
		*  Registration in the login form is active and has already been checked
		*/
		$email = '';
		$password = '';

        if ( $_COOKIE['mobits_status'] == 'login' ) 
        {
	        $userdata = array(
    			'user_login' 		=>  $mobile,
    			'user_pass'			=>  wp_generate_password( 8, true)
    		);
        }

		/* 
		** The new user comes from register form
		**
		*/
		else if( $_COOKIE['mobits_status'] == 'register' )
		{
			$userdata = [];

			// If name and family fields is avilable
			if ( $options['_dlr_name_field_in_register_status'] && $options['_dlr_family_field_in_register_status'] ) 
			{
				$userdata[ 'first_name' ] 	= $_COOKIE['mobits_name'];
				$userdata[ 'last_name' ] 	= $_COOKIE['mobits_family'];
			}

			// If family field is avilable
			else if ( $options['_dlr_name_field_in_register_status'] ) {
				$userdata[ 'first_name' ] 	= $_COOKIE['mobits_name'];
			}
			$password = isset($_COOKIE['mobits_password']) ? $_COOKIE['mobits_password'] : wp_generate_password( 12, true);
			$userdata[ 'user_pass' ] = $password;

			$email = isset($_COOKIE['mobits_email']) ? $_COOKIE['mobits_email'] : '';
			$userdata[ 'email' ] = $email;
			$userdata[ 'user_login' ] = $mobile;
		}

		$name = $options['_dlr_name_field_in_register_status'] && isset($_COOKIE['mobits_name']) ? $_COOKIE['mobits_name'] : '';
		$family = $options['_dlr_family_field_in_register_status'] && isset($_COOKIE['mobits_family']) ? $_COOKIE['mobits_family'] : '';
		
		// Insert new user in db ^_^
		$userId = wp_insert_user( $userdata );

		// Welcome sms
		if ( $options['_dlr_welcome_sms_status'] == 1 ) 
		{
			$sms_type = get_option('_dlr_welcome_sms_type', 'text');

			if ( $sms_type == 'template' ) 
			{
				$template = get_option('_dlr_welcome_sms_template_code', '');

				if ( $template != '' ) 
				{
					$service = get_option('_dlr_sms_service', '');
					Dlr_sms::send_sms_template( [$mobile], $template, $service, 'welcome', [
						'password'		=> $password,
						'email'			=> $email,
						'name'			=> $name,
						'family'		=> $family
					]);
				}
			}
			else 
			{
				$body = get_option('_dlr_welcome_sms_body', '');
				
				if ( $body != '' ) 
				{
					$service = get_option('_dlr_sms_service', '');

					$body = self::return_welcome_sms_body($body, $name, $family, $mobile, $email, $password);

					Dlr_sms::send_sms( $mobile, $body );
				}
			}
		}
		
		// Woocommerce options
		if( $options['_dlr_support_woocommerce'] == 1  ) 
		{
			// Save mobile in woocommerce
		    if( $options['_dlr_save_mobile_in_woocommerce'] == 1 )
		    {
		        update_user_meta( $userId, 'billing_phone', $mobile );
		        update_user_meta( $userId, 'shipping_phone', $mobile );
		    }
		    
			// Save name in woocommerce
		    if( $options['_dlr_save_name_in_woocommerce'] == 1 && isset( $_COOKIE['mobits_name'] ) )
		    {
		        update_user_meta( $userId, 'billing_first_name', $_COOKIE['mobits_name'] );
		        update_user_meta( $userId, 'shipping_first_name', $_COOKIE['mobits_name'] );
		    }

			// Save family in woocommerce
		    if( $options['_dlr_save_family_in_woocommerce'] == 1 && isset( $_COOKIE['mobits_family'] ) )
		    {
		        update_user_meta( $userId, 'billing_last_name', $_COOKIE['mobits_family'] );
		        update_user_meta( $userId, 'shipping_last_name', $_COOKIE['mobits_family'] );
		    }
		}
		
		// Save mobile as metadata
		update_user_meta( $userId, 'mobits_mobile_number', '+98'.$mobile );

		// Hook for after registration is handled
		do_action('dlr_after_create_user', $userId);
        
        return get_user_by( 'id', $userId );
	}

	private static function return_welcome_sms_body( $body, $name, $family, $mobile, $email, $password )
	{
		$body = str_replace("{name}", $name, $body);
		$body = str_replace("{family}", $family, $body);
		$body = str_replace("{mobile}", $mobile, $body);
		$body = str_replace("{email}", $email, $body);
		$body = str_replace("{password}", $password, $body);

		return $body;
	}

	protected static function dlr_login_type()
	{
		$options = parent::get_options(['_dlr_login_with_mobile','_dlr_login_with_email']);

		$lwe = $options['_dlr_login_with_email'] == 1 ? 'email' : '';
		$lwm = $options['_dlr_login_with_mobile'] == 1 ? 'mobile' : '';

		$final = $lwe.$lwm != '' ? $lwe.$lwm : 'mobile';

		return '<input id="dlr_login_type" type="hidden" value="'.$final.'" />';
	}

	protected static function dlr_send_recovery_email()
	{
		$mobile = $_COOKIE['mobits_number'];

		$table = parent::$table;
		$check = parent::$wpdb->get_results( parent::$wpdb->prepare("SELECT * FROM $table WHERE mobile=%s", $mobile) );

		if( isset($check[0]) ) 
		{
			return __('The email recovery link has already been sent to you. Please refer to your email and click on the recovery link. The email may have gone to the spam menu.', 'dlr');
		}
		else {
			$hash = wp_generate_password( 30, false ) . rand(999, 999999);
			parent::$wpdb->insert( $table, [
				'mobile'	=> $mobile,
				'code'		=> $hash,
				'time'		=> 0000
			] );

			$to = $mobile;
			$subject = __('Email password recovery', 'dlr');
			$link = home_url() .'/'. get_option('_dlr_page_slug', 'dlr-login-register') . '?type=sendemail&action=changepass&hash='.$hash;

			$sent = wp_mail($to, $subject . '|' . get_bloginfo('name'), $link);

			return __('The link to recover or create a password has been sent to your email. Please click on it and enter your new password.', 'dlr');
		}
	}

	protected static function dlr_hash_exists($hash)
	{
		$table = parent::$table;

		// Check change password hash is exists
		$results = parent::$wpdb->get_results( parent::$wpdb->prepare( "SELECT * FROM $table WHERE code=%s", $hash) );
		return isset($results[0]) ? $results[0] : false;
	}

	protected static function dlr_user_mobile_block ($mobile)
	{
		//create mobile without zero
		$mobile2 = substr($mobile, 1);
	    
		//check mobiles in usernames
		$table = parent::$wpdb->prefix . 'users';
		$user  = parent::$wpdb->get_row(parent::$wpdb->prepare("SELECT * FROM $table WHERE user_login IN (%d,%s)", $mobile, $mobile2));

		// Return true if mobile is username and user is block
		if ( $user && ( get_user_meta($user->ID, 'dlr_user_status', true) == '0' ) ) return true;

		//check mobile in usermeta
		if( get_option('_dlr_support_digits', 0) == 1 ) 
		{
			$users = get_users(
				array(
					'meta_query'=> array(
						'relation'  => 'or',
						array(
							'key' => 'digits_phone_no',
							'value' => $mobile2
						),
						array(
							'key' => 'digits_phone',
							'value' => '+98'.$mobile2
						)
					)
				)
			);

			if( isset($users[0]) && get_user_meta($users[0]->ID, 'dlr_user_status', true) == '0' ) return true;
		}

		return false;
	}

	protected static function dlr_mobile_block($mobile)
	{
		$table 		= parent::$wpdb->prefix . 'dlr_blocked_mobile_numbers';
		$blocked  	= parent::$wpdb->get_row( parent::$wpdb->prepare("SELECT * FROM $table WHERE mobile=%s", $mobile) );

		return $blocked ? true : false;
	}

	protected static function dlr_user_email_block ($email)
	{
		$user_id = email_exists($email);

		if( $user_id && get_user_meta($user_id, 'dlr_user_status', true) == '0' ) return true;

		return false;
	}
}

new Dlr_Public_Forms();