<?php
defined( 'ABSPATH' ) || exit;

class Dlr_Confirm extends Dlr_Public_Forms
{
	public function __construct() 
	{
		$this->confrim();
	}

	protected static function confrim()
	{
		// Get inserted code
	    $code = sanitize_text_field($_POST['userCode']);

		$code = parent::convert( sanitize_text_field( $code ) );

		if ( !isset($_COOKIE['mobits_number']) ) {
			wp_redirect( home_url() . '/' . parent::$slug );
			exit;
		}

		// Get mobile from cookie
    	$mobile = $_COOKIE['mobits_number'];
    	
		// If code is wrong
    	if( ! parent::check_user_code($code, $mobile) )  
		{
			// Save wrong code report
			self::save_wrong_code();

			$url = '?type='.$_GET['type'].'&status=-1';
			wp_redirect( $url );
			exit;
		}

		// If process is recovery
		if( $_COOKIE['mobits_status'] == 'recovery' ) 
		{
			// Get user
			$user_by_username = get_user_by( 'login', $_COOKIE['mobits_username'] );
			$user_by_email    = get_user_by( 'email', $_COOKIE['mobits_username'] );

			$user = $user_by_username ? $user_by_username : $user_by_email;

			// Set mobile as username
			parent::$wpdb->update( parent::$users_table, array('user_login' => $mobile), array('ID' => $user->ID) );
			
			// Save mobile in woocommerce
			if( get_option('_dlr_support_woocommerce', 0) == 1 && get_option('_dlr_save_mobile_in_woocommerce', 0) == 1 ) 
			{
				update_user_meta( $user->ID, 'billing_phone',  $mobile );
				update_user_meta( $user->ID, 'shipping_phone', $mobile );
			}
			
			// Save mobile as metadata
			update_user_meta( $user->ID, 'mobits_mobile_number', '+98'.$mobile );

			// Login and redirect
			parent::dlr_login_and_redirect($user, $code);
		}

		// If process is login or register (both with mobile)
		$user = parent::create_user($mobile);

		// Update password when existing user is registering
		if( 
			$user && 
			$_COOKIE['mobits_status'] == 'register' && 
			get_option('_dlr_password_field_in_register_status') == 1 && isset( $_COOKIE['mobits_password'] )
		)
			wp_set_password( $_COOKIE['mobits_password'], $user->ID );

		// Update name when existing user is registering
		if( 
			$user && 
			$_COOKIE['mobits_status'] == 'register' && 
			get_option('_dlr_name_field_in_register_status') == 1 
		)
			wp_update_user([ 'ID' => $user->ID, 'first_name' => $_COOKIE['mobits_name'] ]);

		// Update email when existing user is registering
		if( 
			$user && 
			$_COOKIE['mobits_status'] == 'register' && 
			get_option('_dlr_email_field_in_register_status') == 1 && isset($_COOKIE['mobits_email'])
		)
			wp_update_user([ 'ID' => $user->ID, 'user_email' => $_COOKIE['mobits_email'] ]);

		parent::dlr_login_and_redirect($user, $code);
	}

	protected static function save_wrong_code()
	{
		// Stop if option is disabled;
		if ( get_option("_dlr_wrong_code_reports") != 1 ) return;

		// Save report
		date_default_timezone_set('Asia/Tehran');
		$webservice = explode( ":", get_transient('mobits_webservice') );
		$table = parent::$wpdb->prefix . 'dlr_wrong_codes';
		$blocked_table = parent::$wpdb->prefix . 'dlr_blocked_mobile_numbers';
		parent::$wpdb->insert( $table ,
		[
			'webservice' 	=> $webservice[0],
			'template' 		=> $webservice[1],
			'time' 			=> date('Y/m/d H:i:s'),
			'receiver' 		=> $_COOKIE['mobits_number']
		]);

		$limit = get_option('_dlr_limit_wrong_code');

		if( $limit!='' && $limit!=0 )
		{
			$times = parent::$wpdb->get_results( parent::$wpdb->prepare( "select * from $table where receiver=%s and time > date_sub(now(), interval 1 minute)", $_COOKIE['mobits_number'] ) );

			if ( count($times) > (int) $limit ) 
			{
				$name = isset( $_COOKIE['mobits_name'] ) ? $_COOKIE['mobits_name'] : '';
				$family = isset( $_COOKIE['mobits_family'] ) ? $_COOKIE['mobits_family'] : '';

				parent::$wpdb->insert(
					$blocked_table,
					[
						'name' 		=> $name,
						'family'	=> $family,
						'mobile'	=> $_COOKIE['mobits_number']
					]
				);

				wp_redirect( home_url() . '/' . parent::$slug . '?action=block' );
				exit;
			}
		}
	}
}
new Dlr_Confirm();