<?php
defined( 'ABSPATH' ) || exit;

class Dlr_Input_Pass extends Dlr_Public_Forms
{
	public function __construct() 
	{
		self::input_pass();
	}

	protected static function input_pass()
	{
	    $mobile = sanitize_text_field( $_COOKIE['mobits_number'] );
		$input 	= sanitize_text_field( $_COOKIE['mobits_input'] );
		$pass 	= sanitize_text_field( $_POST['loginPassword'] );

		if( $input == 'email' ) 
		{
			$user = parent::dlr_user_email_exist_check($mobile);

			if( $user && wp_check_password( $pass, $user->user_pass, $user->ID ) ) 
			{
				parent::dlr_login_and_redirect($user);
			}

			$input = 'email';
		}
		else 
		{
			$user = parent::dlr_user_exist_check($mobile);
		
			if ( $user && wp_check_password( $pass, $user->user_pass, $user->ID ) )
			{
				parent::dlr_login_and_redirect($user);
			}

			$input = 'mobile';
		}
		
		$status = !$user ? 0 : -1;
		wp_redirect( '?type=inputpass&input='.$input.'&status='.$status );
		exit;
	}
}
new Dlr_Input_Pass();