<?php
defined( 'ABSPATH' ) || exit;

class Dlr_Login extends Dlr_Public_Forms
{
	public function __construct() 
	{
		self::login();
	}

	protected static function login ()
	{
		// Get options
		$options = parent::get_options([
			'_dlr_redirect_new_user_to_register_form',
			'_dlr_register_in_login_form',
			'_dlr_login_priority'
		]);

		if ( $options['_dlr_login_priority'] == 'password' && ! isset($_POST['dlr_mobile_priority']) ) 
		{
			self::login_with_password();
			return;
		}

		// Convert persian number
	    $mobile = parent::convert( sanitize_text_field( $_POST['loginMobile'] ) );

		// Validate email or number
		$check = self::dlr_check_validation($mobile);

		// Set numer and status cookies
		parent::dlr_set_cookie( 'mobits_number', $mobile, time()+1800 );
		parent::dlr_set_cookie( 'mobits_status', 'login', time()+1800 );

		// If input is email
		if( $check )
			self::email_type($options, $mobile);
		
		// If input is mobile
		self::mobile_type($options, $mobile);
	}

	protected static function login_with_password ()
	{
		if ( !isset( $_POST['dlr_username'] ) ) return;

		$username = sanitize_text_field( $_POST['dlr_username'] );
		$password = sanitize_text_field( $_POST['dlr_password'] );

		if ( $password == '' ) wp_die( __("Please enter your password", "dlr") );
		$check = self::dlr_check_validation( $username );

		parent::dlr_set_cookie( 'mobits_username', $username, time()+1800 );

		

		// If input is email
		if( $check ) 
		{
			$user = get_user_by('email', $username);

			// Email not exists
			if ( $user == null ) 
			{
				wp_redirect( '?action=nouser&input=email' );
				exit;
			}

			$check = wp_check_password($password, $user->data->user_pass, $user->ID);
			if ( ! $check ) {
				wp_redirect( '?action=nouser&input=password' );
				exit;
			}
		} 
		else 
		{
			parent::dlr_set_cookie( 'mobits_number', $username, time()+1800 );
			
			// If input is mobile
			$user = parent::dlr_user_exist_check($username);
			if ( ! $user ) 
			{
				wp_redirect( '?action=nouser&input=mobile' );
				exit;
			}

			$userdata = get_user_by('id', $user->ID);
			$check = wp_check_password($password, $userdata->data->user_pass, $user->ID);
			if ( ! $check ) {
				wp_redirect( '?action=nouser&input=password' );
				exit;
			}
		}

		parent::dlr_login_and_redirect($user);
	}

	protected static function dlr_check_validation($mobile)
	{
		$check_mobile = preg_match("/^09[0-9]{9}$/", $mobile);
		$check_email = filter_var( $mobile, FILTER_VALIDATE_EMAIL );

		if( !$check_mobile && !$check_email ) wp_die( __( 'The email or mobile number is not valid, baby!' , 'dlr' ) );

		// If is email
		return !$check_mobile && $check_email;
	}

	protected static function email_type ( $options, $mobile )
	{
		// Check user is block
		if ( parent::dlr_user_email_block($mobile) ) 
		{
			wp_redirect( '?action=block' );
			exit;
		}

		// Set input type cookie
		parent::dlr_set_cookie( 'mobits_input', 'email', time()+1800 );
		
		// New user redirect to register form
		if( $options['_dlr_redirect_new_user_to_register_form'] == 1 && ! parent::dlr_user_email_exist_check($mobile) )
		{
			wp_redirect( '?action=nouser&input=email#register' );
			exit;
		}

		// New user register in login form
		if( ! parent::dlr_user_email_exist_check ($mobile) )
		{
			wp_redirect( '?status=0&input=email' );
			exit;
		}

		// Redirect to input pass
		wp_redirect( '?type=inputpass&input=email' );
		exit;
	}

	public static function mobile_type ( $options, $mobile )
	{
		// Check user is block
		if ( parent::dlr_user_mobile_block($mobile) || parent::dlr_mobile_block($mobile) ) 
		{
			wp_redirect( '?action=block' );
			exit;
		}

		// Set input type cookie
		parent::dlr_set_cookie( 'mobits_input', 'mobile', time()+1800 );
	    
		// New user register in login form
		if( $options['_dlr_redirect_new_user_to_register_form'] == 1 && !parent::dlr_user_exist_check($mobile) )
	    {
			wp_redirect( '?action=nouser&input=mobile#register' );
			exit;
	    }

		// New user register in login form
	    if( $options['_dlr_register_in_login_form'] != 1 && ! parent::dlr_user_exist_check ($mobile) )
	    {
			wp_redirect( '?status=0' );
			exit;
	    }

		// Create code
		parent::create_user_code($mobile, 0);
	}
}
new Dlr_Login();