<?php
defined( 'ABSPATH' ) || exit;

class Dlr_New_Pass extends Dlr_Public_Forms
{
	public function __construct() 
	{
		self::new_pass();
	}

	protected static function new_pass()
	{
		// Get data
	    $mobile 	= sanitize_text_field( $_COOKIE['mobits_number'] );
		$pass 		= sanitize_text_field( $_POST['newPass'] );
		$newPass 	= sanitize_text_field( $_POST['newPassAgain'] );

		// Check user is block
		if ( parent::dlr_user_mobile_block($mobile) || parent::dlr_mobile_block($mobile) ) 
		{
			wp_redirect( '?action=block' );
			exit;
		}

		// Return if pass and repeat is not equel
		if( $pass!=$newPass ) return;

		// Email change password
		if( isset( $_POST['dlr_recovery_hash'] ) ) 
		{
			//check hash exists
			$hash = $_POST['dlr_recovery_hash'];
			$row = parent::dlr_hash_exists($hash);
			if( !isset($row) ) wp_die();

			// get user email from row
			$email = $row->mobile;
			$user = get_user_by('email', $email);

			if( ! $user ) wp_die();

			if( $user )
			{
				// Change password
				wp_set_password( $pass, $user->ID );

				// Delete code from db
				parent::delete_user_code($email, $hash);

				// Login and redirect
				parent::dlr_login_and_redirect($user);
			}
		}
		
		// Mobile change password
		
		// Get user
		$user = parent::dlr_user_exist_check($mobile);

		// If user exists
		if( $user ) 
		{
			// Set new password
			wp_set_password($pass, $user->ID);

			// Login and redirect
			parent::dlr_login_and_redirect($user);
		}
		// If user isnt exists
		else 
		{
			// Insert new user
			$userdata = array(
				'user_login' 	=>  $mobile,
				'user_pass'		=>  $pass
			);
			$userId = wp_insert_user( $userdata );
			
			// Woocommerce options
			if( get_option('_dlr_support_woocommerce', 0) == 1  ) 
			{	
				// Import mobile in woocommerce
				if( get_option('_dlr_save_mobile_in_woocommerce', 0) == 1 )
				{
					update_user_meta( $userId, 'billing_phone', $mobile );
					update_user_meta( $userId, 'shipping_phone', $mobile );
				}
			}
			
			// import mobile as mobits metadata
			update_user_meta( $userId, 'mobits_mobile_number', '+98'.$mobile );

			// Get current new user
			$user = get_user_by('id', $userId);

			// Login and redirect
			parent::dlr_login_and_redirect($user);
		}
	}
}
new Dlr_New_Pass();