<?php
defined( 'ABSPATH' ) || exit;

class Dlr_Recovery extends Dlr_Public_Forms
{
	public function __construct() 
	{
		self::recovery();
	}

	protected static function recovery()
	{	
	    // redirect if recovery is disable
	    if ( get_option('_dlr_recovery_status', 0) != '1' ) 
	    {
	       wp_redirect( home_url() . '/'. get_option('_dlr_page_slug', 'dlr-login-register') );
			exit;
	    }
	    
		// Get mobile and validate
	    $mobile = sanitize_text_field( parent::convert( $_POST['mobile'] ) );
		if( !preg_match("/^09[0-9]{9}$/", $mobile) ) { 
			wp_die(__('The mobile number is not valid, baby!', 'dlr'));
			exit;
		}

		$username = sanitize_text_field( $_POST['username'] );
		$password = sanitize_text_field( $_POST['password'] );

		// Set number, username and status cookies
		parent::dlr_set_cookie( 'mobits_number', $mobile, time()+1800 );
		parent::dlr_set_cookie( 'mobits_username', $username, time()+1800 );
		parent::dlr_set_cookie( 'mobits_password', $password, time()+1800 );
		parent::dlr_set_cookie( 'mobits_status', 'recovery', time()+1800 );
		

		// Get user by username
		$user_by_username 	= get_user_by('login', $username);

		// Get user by email
		$user_by_email 		= get_user_by('email', $username);

		if( $user_by_email && parent::dlr_user_email_block($user_by_email->user_email) ) 
		{
			wp_redirect( '?type=recovery&action=block' );
			exit;
		}

		// Return user if not exists
		if( !$user_by_username && !$user_by_email ) {
			wp_redirect( '?type=recovery&action=-1&err=1' );
			exit;
		}

		// Define username
		$username = $user_by_username ? $username : $user_by_email->user_login;
	    
		// Return if password is wrong
	    $check = wp_authenticate_username_password( null, $username, $password );
		if ( is_wp_error($check) ) {
			wp_redirect( '?type=recovery&action=-1&err=2' );
			exit;
		}	

		// Return if mobile is exists
		if( username_exists( $mobile ) ) wp_redirect( '?type=recovery&action=-1&err=0' );

		// Check user is block
		if ( parent::dlr_user_mobile_block($mobile) ) 
		{
			wp_redirect( '?type=recovery&action=block' );
			exit;
		}
    	
		// Save code and send sms
    	parent::create_user_code($mobile);
	}
}
new Dlr_Recovery();