<?php
defined( 'ABSPATH' ) || exit;

class Dlr_Register extends Dlr_Public_Forms
{
	public function __construct() 
	{
		self::register();
	}

	protected static function register()
	{
		// Get mobile
    	$mobile = sanitize_text_field( parent::convert( $_POST['regMobile'] ) );
		
		// Set mobile cookie
		parent::dlr_set_cookie( 'mobits_number', $mobile, time()+1800 );

		// Check user is block
		if ( parent::dlr_user_mobile_block($mobile) || parent::dlr_mobile_block($mobile) ) 
		{
			wp_redirect( '?action=block#register' );
			exit;
		}

		// Get name if isset and set cookie
		if( isset( $_POST['regName'] ) )
			parent::dlr_set_cookie( 'mobits_name', sanitize_text_field($_POST['regName']), time()+1800 );

		// Get family if isset and set cookie
		if( isset( $_POST['regFamily'] ) )
			parent::dlr_set_cookie( 'mobits_family', sanitize_text_field($_POST['regFamily']), time()+1800 );

		// Validate mobile
		if( !preg_match("/^09[0-9]{9}$/", $mobile) ) { wp_die(__('The mobile number is not valid, baby!', 'dlr')); }

		// If email sent
		if( isset( $_POST['regEmail'] ) && $_POST['regEmail'] != '' ) 
		{
			// Get email
			$email = sanitize_text_field( $_POST['regEmail'] );

			// Validate email
			$check_email = filter_var($email, FILTER_VALIDATE_EMAIL);
			if( !$check_email ) wp_die(__('The Email is not valid, baby!', 'dlr'));

			// Set email cookie
			parent::dlr_set_cookie( 'mobits_email', $email, time()+1800 );

			// Check user is block
			if ( parent::dlr_user_email_block($email) ) 
			{
				wp_redirect( '?action=block#register' );
				exit;
			}

			// Check email existance
			if( email_exists( $email ) ) 
			{
				wp_redirect( '?action=isemail#register' );
				exit;
			}
		}

		// Get password if isset and set cookie
		if( isset( $_POST['regMobilePassword'] ) )
			parent::dlr_set_cookie( 'mobits_password', sanitize_text_field( $_POST['regMobilePassword'] ), time()+1800 );

		// Set status cookie
		parent::dlr_set_cookie( 'mobits_status', 'register', time()+1800 );

		// Hook for before registration is handled
		do_action('dlr_before_register_handle');

		parent::create_user_code($mobile, false);
	}
}
new Dlr_Register();