<?php defined( 'ABSPATH' ) || exit; ?>

<script>
var autoConfirm = '<?php echo esc_attr(self::$public_options['_dlr_auto_confirm']); ?>';
</script>

<div id="dlr-login" class="tabcontent active">
    	  
<form 
method="post" 
action="" 
autocomplete="off" 
id="checkConfirm"
onsubmit="return confirmValidate();"
>

	<div class="dlr-login-input">
	    
	    <label class="dlr-login-text" for="codeBox1">
		    <span class="star">*</span>
		    <?php echo __('Enter the code sent to your mobile', 'dlr'); ?>
		</label>
	    
		<div class="dlr-login-input-field-wrapper confirmCode">
		    
		    <input name="userCode" id="userCode" type="hidden" value="" />

			<?php 
			$codes = esc_attr(get_option('_dlr_number_of_codes', 4));
			for ( $i=0; $i<$codes; $i++ ):
				$form_width = self::$public_options['_dlr_form_width'];
				$margin = $codes * 8;
				$width = $form_width - 50 - $margin;
				$style = 'width: '.($width/$codes).'px;height: '.($width/$codes).'px';
				?>
				<input class="codeBox" style="<?php echo $style; ?>" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" id="codeBox<?php echo ($i+1); ?>" onkeypress="repeatCodeAgain()" <?php if($i==0) echo 'autofocus'; ?> type="tel" maxlength="1" onkeyup="onKeyUpEvent(<?php echo ($i+1); ?>, event)" onfocus="onFocusEvent(<?php echo ($i+1); ?>)"/>
				<?php
			endfor;
			?>
			<input name="codeMobile" type="hidden" id="codeMobile" value="<?php echo get_transient('dlr_mobile'); ?>" />
			
		</div>

	</div>
	<?php 
	if( isset( $_GET['status'] ) && $_GET['status'] == -1 ) 
	{
	    echo '<div id="code-alert" class="code-alert">'.__('The code entered is incorrect.', 'dlr').'</div>';
	}
	?>
	<div class="login-register-alert"></div>

	<?php 

	if( self::dlr_user_exist_check(get_transient('dlr_mobile')) && self::$public_options['_dlr_login_with_password_status'] == 1 ): ?>
	<div class="dlr_login_with_password">
		<a href="<?php echo '?type=inputpass'; ?>"> <?php echo __('Login with password', 'dlr'); ?> <span>></span></a>
	</div>
	<?php endif; ?>

	<?php if( self::$public_options['_dlr_forget_password'] == 1 ): ?>
	<div class="dlr_login_with_password">
		<a href="<?php echo '?type=forgetpass'; ?>"> <?php echo __('Recover or create a password', 'dlr'); ?> <span>></span></a>
	</div>
	<?php endif; ?>

	<button 
		   type="submit" 
		   id="continueCode" 
		   name="dlr-checkCode" 
		   class="dlr-login-button"
	>
	    <div class="lds-ellipsis" id="confirm-loader"><div></div><div></div><div></div><div></div></div>
        
        <span id="confirm-continue"><?php echo __('Next', 'dlr'); ?></span>
	</button>
	<input type="hidden" name="_dlr_mobits" value="confirm" />
	<div id="endTimeCode">
	    <?php echo __('Your time is up', 'dlr'); ?>
	</div>
	
	<span id="time">--:--</span>

</form>

<form
method="post"
action=""
onsubmit="return repeatValidate();"
id="dlr-repeat-form"
>
</form>

</div>